<?php
namespace PTCM;
use PTCM\HelpTab;

final class Plugin {
    private static $instance = null;

    public static function get_instance(): self {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {

        $this->define_constants();
        $this->includes();
        add_action('init', [$this, 'init_services']);
        add_action('admin_init', [$this, 'late_hooks']);

    }

    public function init_services(): void {

        $settings_array = \PTCM\Core::get_settings();
        global $ptcm_settings;
        $ptcm_settings = new \PTCM_Settings_Data($settings_array);

        Column_Manager::init();
        Ajax_Handler::init();
        \PTCM\Settings\SettingsPage::init();

        do_action('ptcm_loaded', $this); // let Pro plugin hook in here
    }

    public function late_hooks(): void {
        // UI actions or get_current_screen() safely go here
        add_filter( 'ptcm_should_enqueue_popup_assets' , [$this, 'insert_screen_assets'] , 10 , 3 );
        add_action('ptcm_current_screen', [$this, 'maybe_render_popup'] , 10 , 2 );
        add_action('admin_enqueue_scripts', ['\\PTCM\\UI_Controller', 'enqueue_assets']);

        add_filter('plugin_action_links_' . PTCM_BASE , array( $this , 'render_plugin_setting_page_link' ) );
        add_action('load-toplevel_page_'.PTCM_SETTING_SLUG, array( $this , 'render_help_tab' ) );
        add_action('in_admin_header', array( $this , 'render_admin_header') );

        HelpTab::load_tabs();
        /*if (
            is_admin() &&
            current_user_can('activate_plugins') &&
            is_plugin_inactive('ptcm-pro-addon/ptcm-pro-addon.php')
        ) {
            activate_plugin('ptcm-pro-addon/ptcm-pro-addon.php');
        }*/
    }

    public function get(string $key = '') {
        if (!defined('PTCM_PRO_LOADED')) {
            return null; // block all others
        }
    
        $info = array(
            'ptcm_slug' => PTCM_SLUG,
            'ptcm_version' => PTCM_VERSION,
            'ptcm_settings_slug' => PTCM_SETTING_SLUG,
        );

        return $key && isset($info[$key]) ? $info[$key] : $info;
    }

    public static function other_base($base){
        return in_array(
            $base,
            apply_filters(
                'ptcm_other_base',
                array(
                    'woocommerce_page_wc-orders'
                )
            )
        );
    }
    

    private static function ditect_screen($screen): bool {
        if (
            ($screen->base === 'edit' && !empty($screen->post_type) ||
            self::other_base($screen->base)
            )
        ){ 
            return true;
        }

        return false;
  
    }

    public static function maybe_render_manage_button($screen_data,$screen): bool {
        /*if (
            !empty($screen->post_type) && 
            Core::is_enabled_for_post_type($screen->post_type) &&
            self::ditect_screen($screen) 
        ) {
            return true;
        }*/
        return apply_filters( 'ptcm_should_enqueue_popup_assets', $screen_data['type'], $screen_data, $screen ) ?? false;

    }

    private function define_constants(): void {
        define('PTCM_VERSION', '1.0.5');
        define('PTCM_SLUG', 'post-type-column-editor');
        define('PTCM_PLUGIN_PATH', plugin_dir_path(__DIR__));
        define('PTCM_PLUGIN_URL', plugin_dir_url(__DIR__));
        define('PTCM_SETTING_SLUG', 'ptcm-settings');


        //db > option_key Prefix >  save column data of post types
        //define('PTCM_DATA_ColSettings', 'ptcm_column_settings_' );
        define('PTCM_DATA_ColSettings', 'ptcm_screen_columns' );


    }

    private function includes(): void {
        require_once PTCM_PLUGIN_PATH . 'includes/class-main.php';
        require_once PTCM_PLUGIN_PATH . 'includes/class-additional-fields.php';  
        require_once PTCM_PLUGIN_PATH . 'includes/class-column-manager.php';
        require_once PTCM_PLUGIN_PATH . 'includes/class-settings-data.php';
        require_once PTCM_PLUGIN_PATH . 'includes/TemplateLoader.php';  
        require_once PTCM_PLUGIN_PATH . 'includes/class-help-tab.php';  
        //require_once PTCM_PLUGIN_PATH . 'includes/class-hook-generate.php';  
            
    }

    

    /**
     * Conditionally render the popup based on admin screen.
     *
     * @param \WP_Screen $screen
     */
    public function maybe_render_popup($screen_data,$screen): void {
        //print_r($screen);
        /*if ( self::ditect_screen($screen) 
        && Core::is_enabled_for_post_type($screen->post_type)
    ) {
            // Render popup only on targeted admin screens
            add_action('admin_footer', ['\\PTCM\\UI_Controller', 'render_popup']);
        }*/
        $do_render_btn = apply_filters( 'ptcm_should_enqueue_popup_assets', $screen_data['type'], $screen_data, $screen );
        if( $do_render_btn ){
            add_action('admin_footer', ['\\PTCM\\UI_Controller', 'render_popup']);
        }
    }


    public function render_plugin_setting_page_link( $links ) {
        global $has_ptcm_pro;

        // Second link: Settings
        $settings_link = '<a href="' . esc_url( admin_url( 'admin.php?page=' . PTCM_SETTING_SLUG ) ) . '">Settings</a>';
        
        if(!$has_ptcm_pro){
            $pro_link = '<a href="#"  style="color:green;font-weight:bold;">Get Admin Columns PRO</a>';
        }
        

        // Prepend both links (reverse order because array_unshift adds in reverse)
        array_unshift( $links, $settings_link );

        if(!$has_ptcm_pro){
            array_unshift( $links, $pro_link );
        }
        
        return $links;
    }

    
    public function render_help_tab() {
        $screen = get_current_screen();

        if ($screen->id !== 'toplevel_page_ptcm-settings') {
            return;
        }
        HelpTab::tab_contents($screen);
        // Help Tab 1: Getting Started
        
    }
    
    public function render_admin_header() {

        if (!is_admin() || !isset($_GET['page']) || $_GET['page'] !== PTCM_SETTING_SLUG) { //phpcs:disable WordPress.Security.NonceVerification.Recommended
            return;
        }
    
        /**
         * Fires before the admin header section.
         */
        do_action('ptcm_before_admin_header');
    
        $wrapper_class = apply_filters('ptcm_admin_header_wrapper_class', 'ptcm-admin-header');
    
        // Allow devs to fully override header content or fall back to default <h2>
        $header_html = apply_filters('ptcm_admin_header_html', null);
        
        echo '<div class="' . esc_attr($wrapper_class) . '">';
    
        if ($header_html !== null) {
            echo wp_kses_post($header_html);
        } else {
            // Default heading with label filter
            $heading_text = apply_filters('ptcm_settings_page_heading', 'WP Admin Columns Settings');
            echo '<h2>' . esc_html($heading_text) . '</h2>';
        }
    
        echo '</div>';
    
        /**
         * Fires after the admin header section.
         */
        do_action('ptcm_after_admin_header');
    }

    public function insert_screen_assets( $screen_type, $screen_data , $screen ) {
        
        if($screen_type == 'post' && !empty($screen_data['post_type'] ) ){
            if( Core::is_enabled_for_post_type( $screen_data['post_type'] ) ){
                return true;
            }
        }
        return apply_filters(
            'ptcm_should_enqueue_popup_assets_extends' , false , $screen_data , $screen
        );
    }
    

}
