<?php
namespace PTCM;

spl_autoload_register(function ($class) {
    if (strpos($class, __NAMESPACE__ . '\\') !== 0) {
        return;
    }

    $class_name = str_replace(__NAMESPACE__ . '\\', '', $class);
    $class_path = plugin_dir_path(__FILE__) . 'class-' . strtolower(str_replace('_', '-', $class_name)) . '.php';

    if (file_exists($class_path)) {
        require_once $class_path;
    }
});
