<?php
namespace PTCM;

class Hook_Generate {

    /**
     * Get sample hook code for post-type columns only.
     *
     * @param string $screen_type Should always be 'post' in free version.
     * @param string $key         Column key.
     * @param array  $context     Optional context (e.g., post_type).
     * @return string
     */
    public static function get_sample_code(string $screen_type, string $key, array $context = []): string {
        if ($screen_type !== 'post') {
            return '<p><em>This feature is available in the Pro version.</em></p>';
        }

        $post_type = $context['post_type'] ?? 'post';
        $hook_name = "ptcm_screen_column_value_{$screen_type}_{$post_type}_{$key}";
        $args      = '$value, $post_id, $screen_data';

        $eol = PHP_EOL;
        return sprintf(
            "<span class='keyword'>add_filter</span>( <span class='string'>'%s'</span>, <span class='keyword'>function</span>( %s ) { $eol  <span class='keyword'>return</span> \$value; $eol }, 10, 3 );</code>",
            esc_html($hook_name),
            esc_html($args)
        );
    }
}

