<?php
namespace PTCM;

class Helpers {

    public static function init(): void { }

    // Core method to return help texts as array
    public static function get_help_texts(): array {
        return apply_filters( 'ptcm_get_help_texts' , [
            'column_enabled' => 'Select/Deselect all columns at once.',
            'column_type'   => 'Select the source of the data you want to display in this column',
            'column_label'   => 'This is the label displayed as the column header in the admin post list table.',
            'column_key'     => 'A unique identifier for the column. Used in filters and hooks. Avoid changing this for Post Fields, Meta Fields, or Core fields.',
            'column_source'  => 'Specifies where the column data comes from — such as a post field, meta key, or a custom source.',
            'column_hook'    => 'Click to see the developer hook used to modify this column’s value programmatically.',
        ]);
        
    }

    // Method to get a help text by key
    public static function help_text(string $key): string {
        $texts = self::get_help_texts();
        return $texts[$key] ?? '';
    }

    public static function get_columns_config(string $post_type): array {
        global $ptcm_settings;
        //echo '<pre>';print_r($ptcm_settings);die;
        $config = $ptcm_settings->get_posttype_column($post_type);
        if(isset($config['columns'])){
            return $config['columns'];
        }
        return [];
    }

    public static function non_editable_columns_array($screen_data): array {
        $sources = self::get_source_dropdown_options($screen_data);
        unset($sources['callback']);
        $source_keys = array_keys($sources);
        return $source_keys;
    }

    public static function get_source_dropdown_options( $screen_data = [] , string $suffix = 'Field'): array {
        $labels = [
            'meta'       => apply_filters('ptcm_label_meta', 'Meta'),
            'post_field' => apply_filters('ptcm_label_post_field', 'Post'),
            'callback'   => apply_filters('ptcm_label_callback', 'Custom'),
            'core'       => apply_filters('ptcm_label_core', 'Core'),
            'additional' => apply_filters('ptcm_label_additional', 'Additional'),
        ];
    
        // Build final options by appending the suffix
        $sources = [];
        foreach ($labels as $key => $label) {
            $sources[$key] = "{$label} {$suffix}";
        }
    
        // 🔁 Allow developers to filter the final set as well
        $sources = apply_filters('ptcm_source_dropdown_options', $sources, $suffix , $screen_data );
    
        return $sources;
    }    
    

    public static function post_type_label($post_type){
        if(!$post_type){
            return '';
        }

        $post_type_obj = get_post_type_object($post_type);

        if ($post_type_obj) {
            return $post_type_obj->labels->name;
        }
    }

    
    public static function get_screen_label($screen_data){
        if(
            isset($screen_data['post_type']) && 
            !empty( $screen_data['post_type'] ) &&
            empty( $screen_data['taxonomy'] )
            ){
            return self::post_type_label( $screen_data['post_type'] );
        }

        if( 
            isset($screen_data['post_type']) &&
            !empty($screen_data['post_type']) &&
            !empty($screen_data['taxonomy'])
        ){
            return ucfirst( $screen_data['taxonomy'] );
        }

        return ucfirst( $screen_data['base'] ); 
        
    }

}
