<?php
namespace PTCM;

use PTCM\UI_Controller;
use PTCM\Plugin;

class HelpTab {

    public static function load_tabs() {
        add_action( 'current_screen', array( __CLASS__ , 'set_screen_tabs') ); 
        
    }

    public static function set_screen_tabs( $screen ) {

        $screen_data = UI_Controller::get_screen_type($screen);
        
        $do_render_btn = Plugin::maybe_render_manage_button( $screen_data ,$screen);
        
        if( !$do_render_btn ) return;

        self::tab_contents($screen);
    }

    public static function tab_contents( $screen ) {
        $screen->add_help_tab([
            'id'    => 'ptcm_help_start',
            'title' => '[WAC] Getting Started',
            'content' => '
                <p>The WP Admin Columns plugin allows you to enable and customize the admin columns shown for different post types in the WordPress dashboard.</p>
                <p><strong>To get started:</strong></p>
                <ol>
                    <li>Go to the "WP Admin Columns" settings page from the admin sidebar.</li>
                    <li>Select the post types for which you want to edit columns.</li>
                    <li>Use the “Edit Columns” popup to add/edit/hide/show columns.</li>
                </ol>
                <p>Changes are saved per post type and reflected immediately in the admin post list view.</p>
            ',
        ]);

        // Help Tab 2: Column Settings
        $screen->add_help_tab([
            'id'    => 'ptcm_help_columns',
            'title' => '[WAC] Column Settings',
            'content' => '
                <p>For each selected screen, you can:</p>
                <ul>
                    <li>Enable or disable individual columns</li>
                    <li>Add and configure custom columns</li>
                    <li>Save custom column layouts</li>
                </ul>
                <p>You can add columns using the <strong>Field Type</strong> selector, which organizes available columns into categories:</p>
                <ul>
                    <li><strong>Core Fields</strong>: Built-in WordPress columns like Title, Date, etc.</li>
                    <li><strong>Post Fields</strong>: Fields related to the post object, like ID, Author, Status</li>
                    <li><strong>Custom Fields</strong>: User-defined fields. To display their values in the column, you need to use the plugin-provided filter hook. Click <strong>Show Hook</strong> to copy the code, then paste it into your theme or plugin and customize it as needed.</li>
                    <li><strong>Additional Fields</strong>: Useful derived values like featured image, word count etc.</li>
                    <li><strong>Meta Fields</strong>: User-defined or plugin-generated metadata fields</li>
                </ul>
                <p>The available fields dynamically update based on the selected <strong>Field Type</strong>. You can then configure the label and key used for the column display.</p>
                <p>Note: Support for advanced post types and custom field detection (e.g., WooCommerce products or orders) may require the Pro version.</p>
            ',
        ]);

        // Help Tab 3: Developer hook
        $screen->add_help_tab([
            'id'    => 'ptcm_help_hooks',
            'title' => '[WAC] Developer Hooks',
            'content' => '
                <p>Developers can extend the WP Admin Columns using WordPress filter hooks. Below are some useful hooks provided by the plugin:</p>
        
                <h4>🧠 Column Content Rendering</h4>
                <code>add_filter( "ptcm_screen_column_value_{$screen_type}_{$post_type}_{$column_key}", function( $value, $post_id, $screen_data ) { ... } );</code>
                <p>This filter lets you control what gets displayed for custom columns.</p>
        
                <h4>🔒 Pro Tip:</h4>
                <p>Use prefixes like <code>ptcm_column_</code> to namespace your custom keys to avoid conflicts.</p>
        
                <h4>🧪 Example:</h4>
                <p>$screen_type = `post`, $post_type = `page`, $column_key = `post_author`</p>
                <pre><code>
add_filter("ptcm_screen_column_value_post_page_post_author", function($value, $post_id , $screen_data) {
    return $value;
}, 10, 2);
</code></pre>

            ',
        ]);

        // Help Tab 4: Troubleshooting
        $screen->add_help_tab([
            'id'    => 'ptcm_help_support',
            'title' => '[WAC] Troubleshooting',
            'content' => '
                <p><strong>Common Issues:</strong></p>
                <ul>
                    <li><strong>Not seeing changes reflected?</strong><br>Clear browser cache or revisit the post list page.</li>
                    <li><strong>Can\'t find certain post types?</strong><br>Ensure they are public and not excluded by custom code/plugins.</li>
                    <li><strong>Saved settings not applying?</strong><br>Make sure you have proper admin permissions.</li>
                </ul>
                <p>If issues persist, contact support or check the documentation.</p>
            ',
        ]);
        
        // Help Sidebar (right panel)
        $screen->set_help_sidebar(
            '<p><strong>[WAC] More Help:</strong></p>' .
            '<p><a href="#" target="_blank">Video Tutorial(Coming Soon)</a></p>' 
        );
    }

}
