<?php
namespace PTCM;

use PTCM\Core;
//use PTCM\PTCM_Settings_Data;

class Get_Columns {

    public static function init(): void {}

    public static function get_columns() {
        check_ajax_referer('ptcm_nonce', 'nonce');
    
        $screen_type    = isset($_POST['screen_type']) ?  sanitize_text_field(wp_unslash($_POST['screen_type'])) : '';
        $screen_context = isset($_POST['screen_context']) ? $_POST['screen_context'] : [];

        $result = apply_filters('ptcm_render_columns_for_screen_type', null, $screen_type, $screen_context);
    
        if (is_array($result)) {
            wp_send_json_success($result);
        } 
        /*elseif ($result === false) {
            wp_send_json_error(['message' => 'Screen type not supported.']);
        }*/
    
        if ($screen_type !== 'post') {
            wp_send_json_error(['message' => 'Screen type not supported in free version.']);
        }
    
        if(isset($screen_context['post_type']) && !empty($screen_context['post_type']) ){
            $post_type = sanitize_text_field(wp_unslash($screen_context['post_type']));
        }elseif(isset( $_POST['post_type'] ) && !empty($_POST['post_type']) ){
            $post_type = sanitize_text_field(wp_unslash($_POST['post_type']));
        }else{
            $post_type = '';
        }

        if (empty($post_type)) {
            wp_send_json_error(['message' => 'Post type missing.']);
        }
    
        // Try to get saved column configuration
        $saved = Helpers::get_columns_config($post_type);
        if (!empty($saved) && is_array($saved)) {
            wp_send_json_success([
                'columns' => array_values($saved),
            ]);
        }
    
        // Otherwise generate native columns
        $native_columns = self::get_native_columns($post_type);
        $column_map = [];
    
        foreach ($native_columns as $key => $label) {
            if ($key === 'cb') continue;
            $column_map[$key] = self::build_column($key, $label, 'core', true);
        }
    
        wp_send_json_success([
            'columns' => array_values($column_map),
        ]);
    }
    

    public static function map_all_columns(array $screen_data): array {
        $column_map = [];
    
        $type = $screen_data['type'];
        $post_type = $screen_data['post_type'] ?? '';
        $taxonomy  = $screen_data['taxonomy'] ?? '';
    
        global $wpdb;
    
        if ($type === 'post' && $post_type) {
            // Only include this in Free version
            $column_map['core'] = [];
            $native_columns = self::get_native_columns($post_type);
            if ($native_columns) {
                foreach ($native_columns as $key => $label) {
                    if ($key === 'cb') continue;
                    $column_map['core'][$key] = self::build_column($key, $label, 'core', true, true);
                }
            }else{
                $column_map['core'] = [];
            }
            
    
            // Post Fields
            $post_fields = self::get_post_fields($wpdb);
            if($post_fields){
                foreach ($post_fields as $field_key) {
                    $column_map['post_fields'][$field_key] = self::build_column($field_key, $field_key, 'post_field', false, true);
                }
            }else{
                $column_map['post_fields'] = [];
            }
            
    
            // Meta
            $meta_keys = self::get_meta_keys($wpdb, $post_type, false);
            if($meta_keys){
                foreach ($meta_keys as $meta_key) {
                    $slug = sanitize_key($meta_key);
                    $column_map['meta_fields'][$slug] = self::build_column($slug, $meta_key, 'meta', false, true);
                }
            }else{
                $column_map['meta_fields'] = [];
            }
            
    
            // Additional fields
            $additional_fields = self::get_additional_keys();
            if($additional_fields){
                foreach ( $additional_fields as $_key) {
                    $_slug = sanitize_key($_key);
                    $column_map['additional'][$_slug] = self::build_column($_key, $_key, 'additional', true, true);
                }
            }else{
                $column_map['additional'] = [];
            }
            
    
            // Custom (callback)
            $custom_keys = self::get_custom_keys($post_type);
            if($custom_keys){
                foreach ( $custom_keys as $key) {
                    $slug = sanitize_key($key);
                    $column_map['callback'][$slug] = self::build_column($key, $key, 'callback', false, true);
                }
            }else{
                $column_map['callback'] = [];
            }
            
        }

    
        return apply_filters('ptcm_map_screen_fields_group', $column_map, $screen_data);
    }
    

    /**
     * Get native WP or WooCommerce admin columns
     */
    public static function get_native_columns(string $post_type): array {
        $columns = [];

        $get_columns = \PTCM_Settings_Data::get_option( 
            Core::$native_column_option_prefix . $post_type 
        );

        if($get_columns){
            return $get_columns;
        }
    
        /**
         * Allow external providers to inject accurate column data
         * (e.g., WooCommerce support in Pro plugin)
         */
        $providers = [];
        do_action_ref_array('ptcm_register_column_providers', [&$providers]);

        foreach ($providers as $provider) {
            if (!is_object($provider) || !method_exists($provider, 'supports')) continue;

            if ($provider->supports($post_type)) {
                $columns = $provider->get_columns($post_type);
            }
        }

        // fallback to WP default
        if (empty($columns)) {
            try {
                require_once ABSPATH . 'wp-admin/includes/screen.php';
                require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
                require_once ABSPATH . 'wp-admin/includes/class-wp-posts-list-table.php';
    
                $_GET['post_type'] = $post_type;
                $_REQUEST['post_type'] = $post_type;
    
                $screen = convert_to_screen('edit-' . $post_type);
                set_current_screen($screen);
    
                $table = new \WP_Posts_List_Table(['screen' => $screen]);
                $table->prepare_items();
                $columns = $table->get_columns();
    
                unset($columns['cb'], $columns['wc_actions']);
            } catch (\Throwable $e) {
                return [];
            }
        }
    
        if($columns){
            if( 
                !\PTCM_Settings_Data::get_option( 
                    Core::$native_column_option_prefix . $post_type 
                )
            ){
                \PTCM_Settings_Data::update_option(
                    Core::$native_column_option_prefix . $post_type,
                    $columns
                );
            }
            
        }
        return $columns;
    }
    
    /**
     * Get WP_Posts fields
     */
    public static function get_post_fields($wpdb): array {
        $cache_key = 'ptcm_post_fields';
        $fields = wp_cache_get($cache_key, 'ptcm');
    
        if ($fields === false) {
            // phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery
            $fields = $wpdb->get_col("DESCRIBE {$wpdb->posts}");
            // phpcs:enable
    
            wp_cache_set($cache_key, $fields, 'ptcm', 12 * HOUR_IN_SECONDS);
        }
    
        return $fields;
    }


    public static function get_additional_keys(): array {    
        $fields = \PTCM\Useful_Fields::get_keys();
        return $fields;
    }

    public static function get_custom_keys(string $post_type ): array {    
        $option_key = Core::$post_type_custom_fields_prefix . $post_type ;
        $options = \PTCM_Settings_Data::get_option( $option_key );
        return $options ? $options : [];

    }   

    /**
     * Get meta keys (public or private)
     */
    public static function get_meta_keys($wpdb, string $post_type, bool $private): array {
        $cache_key = "ptcm_meta_keys_{$post_type}_" . ($private ? 'private' : 'public');
        $meta_keys = wp_cache_get($cache_key, 'ptcm');
    
        if ($meta_keys === false) {
            $like_clause = $private ? "LIKE '\\_%'" : "NOT LIKE '\\_%'";
    
            // Use prepared statement but dynamically append operator safely
            $sql = "
                SELECT DISTINCT pm.meta_key
                FROM {$wpdb->postmeta} pm
                INNER JOIN {$wpdb->posts} p ON p.ID = pm.post_id
                WHERE p.post_type = %s
                AND pm.meta_key {$like_clause}
                AND NOT EXISTS (
                    SELECT 1 FROM {$wpdb->postmeta} sub
                    WHERE sub.post_id = pm.post_id
                        AND sub.meta_key = CONCAT('_', pm.meta_key)
                        AND sub.meta_value LIKE 'field_%%'
                )
                LIMIT 200
            ";
    
            // phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery
            // phpcs:disable WordPress.DB.PreparedSQL.NotPrepared
            $meta_keys = $wpdb->get_col($wpdb->prepare($sql, $post_type));
            // phpcs:enable
    
            wp_cache_set($cache_key, $meta_keys, 'ptcm', 6 * HOUR_IN_SECONDS);
        }
    
        return $meta_keys ? $meta_keys : [] ;
    }
    
    
    /**
     * Build a column array
     */
    public static function build_column(string $key, string $label, string $source, bool $enabled = false, bool $label_enabled = true, bool $key_enabled = false ): array {
        return [
            'key'        => $key,
            'label'      =>  esc_attr(wp_strip_all_tags(ucwords(str_replace( [ '-', '_' ], ' ', $label )))),
            'col_label'  =>  htmlspecialchars($label),
            'source'     => $source,
            'enabled'    => $enabled,
            'label_enabled' => $label_enabled,
            'key_enabled' => $key_enabled,
        ];
    }
}



