<?php
namespace PTCM;
use PTCM\Core;
use PTCM\UI_Controller;

class Column_Manager {

    public static function init(): void {
        add_action('current_screen', [__CLASS__, 'register_columns']);
    }
    

    public static function register_columns(): void {
        $screen = get_current_screen();
    
        if (!$screen) return;

        $screen_data = UI_Controller::get_screen_type($screen);
    
        $post_type = null;
    
        if ($screen->base === 'edit' && !empty($screen->post_type)) {
            $post_type = $screen->post_type;
        } 
    
        if (!$post_type) return;

        if (!in_array( $post_type , Core::get_saved_post_types() )) return;
    
        $columns = Helpers::get_columns_config($post_type);
        if (empty($columns)) return;

      //  echo '<pre>';print_r($columns);die;

        $screen_type = $screen_data['type'];
    
        $filtered_columns = [];
        foreach ($columns as $col) {
            if (!empty($col['enabled'])) {
                $filtered_columns[$col['key']] = stripslashes( $col['col_label'] );
            }
        }
    
        
        add_filter("manage_{$post_type}_posts_columns", function($existing_cols) use ($filtered_columns) {
            //return $existing_cols;
           // $all_cols =  array_merge($existing_cols, $filtered_columns);
            return array_merge(['cb' => '<input type="checkbox" />'], $filtered_columns);
        }, 99999);
    
    
        // Handle column content output for normal post types
        add_action("manage_{$post_type}_posts_custom_column", function($col_key, $post_id) use ($columns, $post_type, $screen_type , $screen_data) {
            foreach ($columns as $col) {
                if ($col['key'] !== $col_key || empty($col['enabled'])) {
                    continue;
                }
        
                $value = '';
        
                switch ($col['source']) {
                    case 'meta':
                        if (!empty($col['key'])) {
                            $value = get_post_meta($post_id, $col['key'], true);
                        }
                        break;
        
                    case 'post_field':
                        if (!empty($col['key'])) {
                            $post_field = $col['key'] === 'id' ? 'ID' : $col['key'];
                            $value = get_post_field($post_field, $post_id);
                        }
                        break;
        
                    case 'additional':
                        if (!empty($col['key'])) {
                            $value = \PTCM\Useful_Fields::get_data($col['key'], $post_id);
                        }
                        break;
        
                    case 'callback':
                        if (!empty($col['callback']) && is_callable($col['callback'])) {
                            $value = call_user_func($col['callback'], $post_id, $col);
                        }
                        break;
        
                    case 'core':
                        /**
                         * Optional: Core WP Columns like "title", "date", etc.
                         * You could replicate those if needed.
                         */
                        $value = ''; // intentionally left blank unless you need something specific
                        break;
        
                    default:
                        $value = apply_filters('ptcm_custom_column_value', '', $col, $post_id, $post_type);
                        break;
                }
                $col_key = strtolower($col_key);
                $filter =  apply_filters( "ptcm_screen_column_value_{$screen_type}_{$post_type}_{$col_key}", $value, $post_id, $screen_data );
        
                echo wp_kses_post($filter);
            }
        }, 99999, 2);
        
    
    }
    

    public static function reload_columns(string $post_type) {
        check_ajax_referer('ptcm_nonce', 'nonce');

        if(empty($post_type)){
            return;
        }
        if (!current_user_can('edit_posts')) {
            wp_send_json_error(['message' => 'Unauthorized']);
        }
    
        // Special case for WooCommerce Orders
        if ($post_type === 'shop_order' && class_exists('\WC_Admin_List_Table_Orders')) {
            require_once WC_ABSPATH . 'includes/admin/list-tables/class-wc-admin-list-table-orders.php';
            $table = new \WC_Admin_List_Table_Orders();
        } else {
            // Simulate screen
            require_once ABSPATH . 'wp-admin/includes/screen.php';
            require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
            require_once ABSPATH . 'wp-admin/includes/class-wp-posts-list-table.php';
    
            set_current_screen('edit-' . $post_type);

            $post_type1 = isset($_REQUEST['post_type']) ? sanitize_text_field(wp_unslash($_REQUEST['post_type'])) : 'post';
            $orderby   = isset($_REQUEST['orderby'])   ? sanitize_text_field(wp_unslash($_REQUEST['orderby']))   : 'date';
            $order     = isset($_REQUEST['order'])     ? sanitize_text_field(wp_unslash($_REQUEST['order']))     : 'desc';
            $paged     = isset($_REQUEST['paged'])     ? absint($_REQUEST['paged']) : 1;

    
            // ✅ Fix for missing data
            // Only if absolutely needed
            $_REQUEST['post_type'] = $post_type1; // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
            $_GET['post_type']     = $post_type1; // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash

            $_REQUEST['orderby'] = $orderby;     // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
            $_REQUEST['order']   = $order;       // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
            $_REQUEST['paged']   = $paged;       // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash

    
            $table = new \WP_Posts_List_Table([
                'screen' => get_current_screen(),
            ]);
        }
    
        ob_start();
        $table->prepare_items();
    
        ?>
        <table class="wp-list-table widefat fixed striped posts">
            <thead><?php $table->print_column_headers(); ?></thead>
            <tbody><?php $table->display_rows(); ?></tbody>
            <tfoot><?php $table->print_column_headers(); ?></tfoot>
        </table>
        <?php
    
        $html = ob_get_clean();
        return $html;
    }

    public static function reset_columns(): void {
        check_ajax_referer('ptcm_nonce', 'nonce');
    
        $screen_type    = isset($_POST['screen_type']) ? sanitize_text_field(wp_unslash($_POST['screen_type'])) : 'post';
        $screen_context = isset($_POST['screen_context']) ? $_POST['screen_context'] : []; // phpcs:ignore
        if (empty($screen_type)) {
            wp_send_json_error(['message' => 'Missing screen type.']);
        }
    
       
        $handled = apply_filters('ptcm_handle_reset_columns_for_screen_type', null, $screen_type, $screen_context);
        if ($handled === true) {
            wp_send_json_success(['message' => 'Reset successfully']);
        }
    
        // Default handling for `post` type screen
        if ($screen_type !== 'post') {
            wp_send_json_error(['message' => 'Screen type not supported.']);
        }
    
        $post_type = sanitize_text_field($screen_context['post_type'] ?? '');
        if (!$post_type) {
            wp_send_json_error(['message' => 'Missing post type.']);
        }
    
        $option_key = PTCM_DATA_ColSettings . '--' . $screen_type . '--' . $post_type;
        update_option($option_key, '');
    
        wp_send_json_success(['message' => 'Reset successfully']);
    }
    
}
