<?php
namespace PTCM;
use PTCM\Core;
use PTCM\Hook_Generate;


class Ajax_Handler {
    public static function init(): void {
        add_action('wp_ajax_ptcm_get_columns', [__CLASS__, 'get_columns']);
        add_action('wp_ajax_ptcm_save_columns', [__CLASS__, 'save_columns']);
        add_action('wp_ajax_ptcm_reload_list_table', [__CLASS__, 'reload_list_table']);
        add_action('wp_ajax_ptcm_reset_columns', [__CLASS__, 'reset_columns']);
        add_action('wp_ajax_ptcm_save_post_type_custom_fields', [__CLASS__, 'ptcm_save_post_type_custom_fields']);
        add_action('wp_ajax_ptcm_get_hook_sample', [__CLASS__, 'ptcm_get_hook_sample']);
    }

    public static function save_columns() {
        $columns = Save_Columns::save_columns();
        wp_send_json_success(['message' => 'Column settings saved.']);
    }

    public static function get_columns(): void {
        $column_map = Get_Columns::get_columns(); 
        wp_send_json_success(array_values($column_map));
    }

    public static function reset_columns(): void {
        Column_Manager::reset_columns(); 
        wp_send_json_success();
    }

    public static function reload_list_table() {
        check_ajax_referer('ptcm_nonce', 'nonce');
        $post_type = isset($_POST['post_type']) ? sanitize_text_field(wp_unslash($_POST['post_type'])) : 'post';
        $html = Column_Manager::reload_columns($post_type);
        wp_send_json_success(['table_html' => $html]);
    }

    public static function ptcm_save_post_type_custom_fields() {
        check_ajax_referer('ptcm_nonce', 'nonce');
        $post_type = isset($_POST['post_type']) ? sanitize_text_field(wp_unslash($_POST['post_type'])) : '';
        $key = isset($_POST['key']) ? sanitize_text_field(wp_unslash($_POST['key'])) : '';
        $label = isset($_POST['label']) ? sanitize_text_field(wp_unslash($_POST['label'])) : '';

        if( $post_type && $key && $label){
            $option_key = Core::$post_type_custom_fields_prefix . $post_type ;

            $options = \PTCM_Settings_Data::get_option( $option_key );

            if (!in_array($key, $options)) {
                $options[ $key ] = $label;
                \PTCM_Settings_Data::update_option( $option_key , $options );
            }

            wp_send_json_success();
        }
    }

    public static function ptcm_get_hook_sample() {
		check_ajax_referer('ptcm_nonce', 'nonce');

		$screen_type = sanitize_text_field($_POST['screen_type'] ?? 'post');
		$key         = sanitize_text_field($_POST['key'] ?? '');
		$context     = $_POST['context'] ?? [];

		// Default hook sample from Free version
		$default_output = Hook_Generate::get_sample_code($screen_type, $key, $context);

		// Allow Pro version or others to override
		$final_output = apply_filters(
			'ptcm_get_hook_sample_output',
			$default_output,
			$screen_type,
			$key,
			$context
		);

		wp_send_json_success([
			'code_sample' => $final_output,
		]);
	}
  
 
}
