<?php
namespace PTCM;

class TemplateLoader {

    public static function load_template( $template_name, $args = [] ) {
        $template_file = self::locate_template( $template_name );

        if ( ! empty( $args ) && is_array( $args ) ) {
            extract( $args );
        }

        if ( file_exists( $template_file ) ) {
            include $template_file;
        } else {
            echo esc_attr("<!-- Template file not found: $template_name -->");
        }
    }

    public static function locate_template( $template_name ) {
        global $ptcm_template_override_dirs;

        $paths = [];

        // 1. Check override dirs (set by Pro plugin or others)
        if ( isset( $ptcm_template_override_dirs ) && is_array( $ptcm_template_override_dirs ) ) {
            foreach ( $ptcm_template_override_dirs as $dir ) {
                $paths[] = $dir . $template_name;
            }
        }

        // 2. Fallback to Free plugin default
        $paths[] =  PTCM_PATH . 'templates/' . $template_name;

        foreach ( $paths as $path ) {
            if ( file_exists( $path ) ) {
                return $path;
            }
        }

        return false;
    }
}
