(function (window, $) {
  const ptcmUtils = {
    config: {},

    setConfig: function (data) {
      this.config = data || {};
    },

    get: function (key, fallback = null) {
      return this.config[key] !== undefined ? this.config[key] : fallback;
    },

    log: function (message) {
      console.log('[PTCM]', message);
    },

    extendAction: function (actionName, object) {
      const event = new CustomEvent('ptcm:' + actionName, { detail: object });
      document.dispatchEvent(event);
    },

    _actions: {},

    addAction(actionName, callback) {
      if (!this._actions[actionName]) {
        this._actions[actionName] = [];
      }
      this._actions[actionName].push(callback);
    },

    doAction(actionName, data) {
      if (this._actions[actionName]) {
        this._actions[actionName].forEach(callback => {
          callback(data);
        });
      }
    },

    filters: {},

    addFilter: function (tag, callback) {
      if (!this.filters[tag]) {
        this.filters[tag] = [];
      }
      this.filters[tag].push(callback);
    },

    applyFilters: function (tag, value, ...args) {
      if (!this.filters[tag]) return value;

      return this.filters[tag].reduce((val, callback) => {
        return callback(val, ...args);
      }, value);
    },

    blockUI: function () {
      $('#ptcm-popup-overlay').css('display', 'flex').fadeIn();
    },

    unblockUI: function () {
      $('#ptcm-popup-overlay').css('display', 'flex').fadeOut();
    },

    toast: function (input = 'Copied!', type = 'success') {
      // Determine message / action
      let message = typeof input === 'string' ? input : (input.message || 'Copied!');
      let actionText = typeof input === 'object' ? input.actionText : null;
      let onAction = typeof input === 'object' ? input.onActionClick : null;
      let messageType = typeof input === 'object' ? (input.type || type) : type;

      // Sanitize type
      const validTypes = ['success', 'warning', 'error'];
      if (!validTypes.includes(messageType)) {
        messageType = 'success';
      }

      // Build toast container with type class
      const $toast = $('<div class="ptcm-toast"></div>')
        .addClass(`ptcm-toast-${messageType}`)
        .text(message);

      // If action provided, append button
      if (actionText && typeof onAction === 'function') {
        const $btn = $('<button class="ptcm-toast-action"></button>')
          .text(actionText)
          .on('click', function (e) {
            e.stopPropagation();
            onAction();
            $toast.remove();
          });
        $toast.append($btn);
      }

      // Append and auto‐remove
      $('body').append($toast);
      $toast.css({
        opacity: 1,
        transition: 'none',
        animation: 'none',
      });
      setTimeout(() => $toast.fadeOut(500, () => $toast.remove()), 5000);
    },


    // Optional: fetch label
    getColTypeLabel: function (key) {
      return window.ptcmData.col_types?.[key] || 'Unknown source';
    },

    escapeHtml: function (string) {
      return String(string).replace(/[&<>"']/g, function (s) {
        return ({
          '&': '&amp;',
          '<': '&lt;',
          '>': '&gt;',
          '"': '&quot;',
          "'": '&#039;'
        })[s];
      });
    },
    isDuplicateKey: function (keyToCheck) {
      const existingKeys = [];

      $('#ptcm-columns-list .ptcm-key').each(function () {
        const val = $(this).val();
        if (val) existingKeys.push(val);
      });

      return existingKeys.includes(keyToCheck);
    },
    scrollToDuplicate: function (keyToCheck) {
      let firstMatch = null;

      $('.ptcm-column-row').each(function () {
        const row = $(this);
        const existingKey = row.find('.ptcm-key').val();

        if (existingKey === keyToCheck) {
          row.addClass('ptcm-duplicate-highlight');

          if (!firstMatch) firstMatch = row;

          setTimeout(() => row.removeClass('ptcm-duplicate-highlight'), 2000);
        }
      });

      // Scroll to matching row inside scroll container
      const scrollContainer = $('.ptcm-popup-body'); // Replace with your actual container
      if (firstMatch && scrollContainer.length) {
        const containerTop = scrollContainer.offset().top;
        const itemTop = firstMatch.offset().top;
        const scrollOffset = itemTop - containerTop + scrollContainer.scrollTop() - 40;

        scrollContainer.animate({ scrollTop: scrollOffset }, 400);
      }
    },
    /*getGroupedLabelOptions: function () {
      const formatGroup = (fields, groupLabel) => {
        if (!fields || typeof fields !== 'object') return null;
        return {
          text: groupLabel,
          children: Object.values(fields).map(f => ({
            id: f.key,
            text: f.label || f.key || '',
            'data-key': f.key,
            'data-source': f.source,
            'data-disable-key': groupLabel === 'Post Fields' || groupLabel === 'Meta Fields' || groupLabel === 'Core Fields' || groupLabel === 'Additional Fields'
          }))
        };
      };

      // Base groups
      let groups = [
        formatGroup(ptcmData.fields.post_fields, 'Post Fields'),
        formatGroup(ptcmData.fields.meta_fields, 'Meta Fields'),
        formatGroup(ptcmData.fields.core, 'Core Fields'),
        formatGroup(ptcmData.fields.additional, 'Additional Fields'),
        formatGroup(ptcmData.fields.callback || {}, 'Custom Fields')
      ].filter(Boolean); // Remove nulls

      groups = this.applyFilters('ptcm.groupedLabelOptions', groups, ptcmData.fields, formatGroup);
      return groups;

    },*/
    getGroupedLabelOptions: function () {
      const fields = ptcmData.fields || {};
      const labels = ptcmData.sources || {};

      let groups = Object.entries(fields).map(([groupKey, groupFields]) => {
        if (!groupFields || typeof groupFields !== 'object') return null;

        const label = labels[groupKey] || groupKey.replace(/_/g, ' ').replace(/\b\w/g, (l) => l.toUpperCase());
        return this.formatGroup(groupFields, label);
      }).filter(Boolean);

      groups = this.applyFilters('ptcm.groupedLabelOptions', groups, fields, this.formatGroup.bind(this));

      return groups;
    },
    formatGroup: function (fields, groupLabel) {
      if (!fields || typeof fields !== 'object') return null;
      return {
        text: groupLabel,
        children: Object.values(fields).map(f => ({
          id: f.key,
          text: f.label || f.key || '',
          'data-key': f.key,
          'data-source': f.source,
          'data-disable-key': groupLabel === 'Post Fields' || groupLabel === 'Meta Fields' || groupLabel === 'Core Fields' || groupLabel === 'Additional Fields'
        }))
      };
    },
    slugify: function slugify(text) {
      return text.toString().toLowerCase()
        .trim()
        .replace(/[\s\_]+/g, '-')       // Replace spaces/underscores with -
        .replace(/[^\w\-]+/g, '')       // Remove all non-word chars
        .replace(/\-\-+/g, '-');        // Replace multiple - with single -
    },

    // Add more helpers here...
  };

  // Expose globally
  window.ptcmUtils = ptcmUtils;
})(window, jQuery);
