(function ($) {
  $.fn.ptcmTooltip = function () {
    const $tooltip = $('<div class="ptcm-tooltip"></div>').appendTo('body');

    $(document).on('mouseenter', '.ptcm-help', function () {
      const $this = $(this);
      const tipText = $this.data('tip');
      if (!tipText) return;

      $tooltip.text(tipText).fadeIn(150);
      const offset = $this.offset();
      const top = offset.top - $tooltip.outerHeight() / 2 + $this.outerHeight() / 2;
      const left = offset.left + $this.outerWidth() + 8;
      $tooltip.css({ top, left });
    });

    $(document).on('mouseleave', '.ptcm-help', function () {
      $tooltip.hide();
    });

    return this;
  };
})(jQuery);
