(function ($) {
  //${col.label ? `<option selected value="${ptcmUtils.escapeHtml(col.label)}">${ptcmUtils.escapeHtml(col.label)}</option>` : ''}
  $.ptcmRenderRow = function (col = {}, addNew = false) {
    col.source = col.source || 'core';
    const colTypeLabel = ptcmUtils.getColTypeLabel(col.source);
    let baseClasses = '';
    if (col.enabled == 1 || addNew === true) baseClasses += 'ptcm-row-enabled';

    const rowClass = ptcmUtils.applyFilters('ptcm.columnRowClass', baseClasses, col, addNew);

    const _disabled = col.key == 'title' ? 'disabled="disabled"' : '';
    const check_disabled = ptcmUtils.applyFilters('ptcm.columnFirstDisabled', _disabled, col, addNew);

    const _removed = col.key == 'title' ? 'style="display:none;"' : '';
    const check_removedHide = ptcmUtils.applyFilters('ptcm.columnRowRemovedHide', _removed, col, addNew);

    const _hookHide = col.source == 'core' ? 'style="display:none;"' : '';
    const check_hookHide = ptcmUtils.applyFilters('ptcm.columnRowRemoved', _hookHide, col, addNew);


    const hookkey = col.source !== 'core' ? col.key : '';
    const check_hookkey = ptcmUtils.applyFilters('ptcm.columnHookKey', hookkey, col, addNew);

    const html_label = !addNew ? col.col_label.replace(/\\"/g, '"') : col.col_label ;

    let rowHtml = `
  <div class="ptcm-column-row ${rowClass}">
    <div class="ptcm-toggle-wrap">
      <input type="checkbox" id="ptcm-check-${col.key}" class="ptcm-enabled ptcm-toggle" ${col.enabled == 1 ? 'checked' : ''} ${check_disabled}>
      <label for="ptcm-check-${col.key}" class="ptcm-toggle-slider" title="Enable/Disable Column"></label>
    </div>
    <div class="ptcm-system-column-wrap">
      <label class="ptcm-system-label">${colTypeLabel}</label>
      <select class="ptcm-input ptcm-label" data-field="label"></select>
      <a href="javascript:;" class="ptcm-display-settings">Display Settings (Pro Only)</a>
    </div>
    <textarea style="width:95%;" class="ptcm-input ptcm-col-label" placeholder="Label" data-field="col_label">${html_label || ''}</textarea>
    <input type="text" class="ptcm-input ptcm-key pctm-p-all-7-10" placeholder="Key" value="${col.key || ''}" data-field="key"/>
    <input type="hidden" class="ptcm-input ptcm-col-source" data-field="source" value="${col.source}">
    <a href="javascript:;" class="ptcm-show-hook pctm-mt-12" data-key="${check_hookkey}" ${check_hookHide}>Show Hook</a>
    <a data-tip="Remove Column" href="javascript:;" class="ptcm-help-icon dashicons dashicons-trash ptcm-remove-column pctm-mt-12" ${check_removedHide}></a>
  </div>
`;

    rowHtml = ptcmUtils.applyFilters('ptcm_row_html', rowHtml, col, rowClass);

    const row = $(rowHtml);

    ptcmUtils.doAction('ptcm.before_column_row_rendered', { row, col, addNew });

    const labelSelect = row.find('.ptcm-label');

    labelSelect.select2({
      placeholder: 'Select or type a label',
      allowClear: true,
      tags: true, // allow custom input
      dropdownAutoWidth: true,
      width: 'resolve',
      data: ptcmUtils.getGroupedLabelOptions(),
      dropdownParent: $('#ptcm-columns-list'),
      matcher: function (params, data) {
        if ($.trim(params.term) === '') {
          return data;
        }
        // If this is a group
        if (data.children && data.children.length > 0) {
          // Filter children without mutating original
          const matchedChildren = data.children
            .map(child => $.extend(true, {}, child)) // deep clone
            .filter(child =>
              child.text && child.text.toLowerCase().includes(params.term.toLowerCase())
            );

          if (matchedChildren.length > 0) {
            const group = $.extend(true, {}, data);
            group.children = matchedChildren;
            return group;
          }

          return null;
        }

        // Individual option
        if (
          data.text &&
          data.text.toLowerCase().includes(params.term.toLowerCase())
        ) {
          return data;
        }

        return null;
      }
    });

    ptcmUtils.labelOptions = ptcmUtils.getGroupedLabelOptions();


    // Preselect existing value (if not in options, Select2 will treat it as a tag)
    if (col.label) {
      // Add the value to the select if it's not in the list already
      if (labelSelect.find(`option[value="${col.label}"]`).length === 0) {
        const newOption = new Option(col.label, col.label, true, true);
        labelSelect.append(newOption).trigger('change');
      } else {
        labelSelect.val(col.label).trigger('change');
      }
    }

    labelSelect.on('select2:select', function (e) {

      const selected = e.params.data;
      const selectedKey = selected.id;

      if (ptcmUtils.isDuplicateKey(selectedKey)) {
        ptcmUtils.toast({
          message: `DUPLICATE ENTRY - The Column "${selectedKey}" is already added.You can REMOVE the row or CHANGE the option in the SELECT input box`,
          type: 'warning'
        });

        // Reset selection
        labelSelect.val(null).trigger('change');
        ptcmUtils.scrollToDuplicate(selectedKey);
        row.find('.ptcm-col-label').val('');
        row.find('.ptcm-key').val('');
        row.find('.ptcm-show-hook').attr( 'data-key' , '');
        return;
      }

      if (!selected || typeof selected.text !== 'string') {
        console.warn('Invalid selection — skipping', selected);
        return;
      }

      const colLabel = row.find('.ptcm-col-label');
      const keyField = row.find('.ptcm-key');
      const sourceField = row.find('.ptcm-col-source');
      const isCustom = !selected['data-key'];

      if (isCustom) {
        let customGroup = ptcmUtils.labelOptions.find(g => g.text === 'Custom Fields');

        if (!customGroup) {
          customGroup = { text: 'Custom Fields', children: [] };
          ptcmUtils.labelOptions.push(customGroup);
        }

        const alreadyExists = customGroup.children.some(c => c.id === ptcmUtils.slugify(selected.id));

        if (!alreadyExists) {
          customGroup.children.push({
            id: ptcmUtils.slugify(selected.id),
            text: selected.text || ptcmUtils.slugify(selected.id) || '',
            'data-key': selected.id,
            'data-source': 'callback',
            'data-disable-key': false
          });

          // Now update Select2 with new data
          labelSelect.select2('destroy').empty().select2({
            placeholder: 'Select or type a label',
            allowClear: true,
            tags: true,
            dropdownAutoWidth: true,
            width: 'resolve',
            data: ptcmUtils.labelOptions,
            dropdownParent: $('#ptcm-columns-list'),
            matcher: function (params, data) {
              // Always return if there's no search term
              if ($.trim(params.term) === '') {
                return data;
              }

              // Ensure text exists
              if (!data.text) {
                return null;
              }

              // Match ignoring case
              if (data.text.toLowerCase().indexOf(params.term.toLowerCase()) > -1) {
                return data;
              }

              return null;
            }
          });

          labelSelect.val(ptcmUtils.slugify(selected.id)).trigger('change');

          const saveButton = $('#ptcm-save-columns');
          saveButton.prop('disabled', true).addClass('ptcm-loading');

          $.post(ptcmData.ajax_url, {
            action: 'ptcm_save_post_type_custom_fields',
            key: ptcmUtils.slugify(selected.id),
            label: selected.text,
            nonce: ptcmData.nonce,
            post_type: ptcmData.post_type
          })
            .done(function (response) {
              // Optional: handle success
              //console.log('Custom label saved:', response);
            })
            .fail(function () {
              // Optional: handle error
              alert('Failed to save custom label. Please try again.');
            })
            .always(function () {
              // Re-enable save button
              saveButton.prop('disabled', false).removeClass('ptcm-loading');
            });


        }
        colLabel.val(selected.text);
        keyField.val(ptcmUtils.slugify(selected.id));
        sourceField.val('callback');
        keyField.prop('disabled', false);
        row.find('.ptcm-show-hook').data('key', ptcmUtils.slugify(selected.id));
        row.find('.ptcm-system-label').html('Custom Column');
      } else {
        colLabel.val(selected.text);
        keyField.val(selected['data-key']);
        sourceField.val(selected['data-source']);
        keyField.prop('disabled', true );
        row.find('.ptcm-show-hook').data('key', selected['data-key']);

        const label = ptcmUtils.getColTypeLabel(sourceField.val());
        //console.log(sourceField.val());
        row.find('.ptcm-system-label').html(label);

      }

      

      row.find('.ptcm-key').prop('disabled', !(sourceField.val() === 'callback' || sourceField.val() === 'meta'));
      if( sourceField.val()  !== 'core'){
        const getKeyField = row.find('.ptcm-key').val();
        row.find('.ptcm-show-hook').attr('data-key' , getKeyField );
        row.find('.ptcm-show-hook').show();
      }else{
        row.find('.ptcm-show-hook').attr('data-key' , '' );
        row.find('.ptcm-show-hook').hide();
      }
    });



    labelSelect.on('select2:clear', function () {
      row.find('.ptcm-key').val('').prop('disabled', false);
      row.find('.ptcm-col-source').val('meta')
    });


    row.find('.ptcm-remove-column').on('click', () => {

      // Create a visual placeholder div that takes the same space
      const placeholder = $('<div class="ptcm-undo-placeholder" style="height: 0; margin-bottom: 10px;"></div>');

      // Red flash effect
      row.css({
        'background-color': '#ffdddd',
        'transition': 'background-color 0.3s ease'
      });

      setTimeout(() => {
        row.fadeOut(300, () => {
          // Insert the placeholder where the row used to be
          placeholder.insertAfter(row);

          // Remove row visually but keep in memory
          row.detach();

          ptcmUtils.extendAction('removeColumn', row);

          let undoTimeout = setTimeout(() => {
            placeholder.remove(); // Remove placeholder if Undo not clicked
          }, 5000);

          // Show toast with Undo
          ptcmUtils.toast({
            message: 'Column removed.',
            actionText: 'Undo',
            onActionClick: () => {
              clearTimeout(undoTimeout);
              restoreRow(row, placeholder);
            },
            type: 'error'
          });
        });
      }, 150);
    });


    function restoreRow(row, placeholder) {
      placeholder.replaceWith(row);
      row.css({
        'background-color': '#e0ffe0', // green flash
        'opacity': 0
      }).show().animate({ opacity: 1 }, 300);

      ptcmUtils.extendAction('restoreColumn', row);
      ptcmUtils.toast('Column restored.');

    }

    

    if( col.source !== 'undefined'){
        col.source !== 'core' ? row.find('.ptcm-label').prop('disabled', false) : row.find('.ptcm-label').prop('disabled', true);
        col.source === 'custom'  ? row.find('.ptcm-key').prop('disabled', false) : row.find('.ptcm-key').prop('disabled', true);
    }else{
      row.find('.ptcm-key').prop('disabled', true);
    }


    $('#ptcm-columns-list').append(row);

    if (addNew === true) {

      
      
      row.find('.ptcm-label').prop('disabled', false);
      row.find('.ptcm-enabled').prop('checked', true);

      const labelSelect = row.find('.ptcm-label');
      row.addClass('ptcm-highlight');

      const validGroups = ptcmUtils.labelOptions.filter(group => group.children && group.children.length > 0);
      const secondGroup = validGroups.length > 1 ? validGroups[1] : null;

      //console.log(secondGroup);

      if (secondGroup) {
        const secondOption = secondGroup.children[0];

        // Step 3: Select the second option
        labelSelect.val(secondOption.id).trigger('change');
        labelSelect.trigger({
          type: 'select2:select',
          params: {
            data: secondOption
          }
        });

        row.find('.ptcm-label').focus();
      }

      setTimeout(() => row.removeClass('ptcm-highlight'), 5000);
      if( col.source !== 'undefined'){
        col.source === 'custom'  ? row.find('.ptcm-key').prop('disabled', false) : row.find('.ptcm-key').prop('disabled', true);
      }else{
        row.find('.ptcm-key').prop('disabled', true);
      }
    }

   /* row.find('.ptcm-show-hook').on('click', () => {
      const key = row.find('.ptcm-show-hook').data('key');
      if(key){
        const hook = `ptcm_column_value_${PTCM.post_type}_${key}`;
        const code = `<span class="keyword">add_filter</span>('<span class="string">${hook}</span>',  <span class="keyword">function</span>($value, $post_id) {\n  <span class="keyword">return</span> $value;\n}, 10, 2);`;
        $('#ptcm-hook-code').html(code);
        $('#ptcm-hook-modal').fadeIn(200);
      }
    });*/

    row.find('.ptcm-show-hook').on('click', () => {
      const key = row.find('.ptcm-show-hook').data('key');

      if (key) {
        const screenType = PTCM.screen_type;
        const contextData = PTCM.screen_context || {};

        $.post(PTCM.ajax_url, {
          action: 'ptcm_get_hook_sample',
          key: key,
          screen_type: screenType,
          context: contextData,
          nonce: PTCM.nonce
        }, function (res) {
          $('#ptcm-hook-code').html(res.data.code_sample);
          $('#ptcm-hook-modal').addClass('active');
        });
      }
    });


    ptcmUtils.doAction('ptcm.after_column_row_rendered', { row, col, addNew });
    
  };
})(jQuery);
