(function ($) {
  $.ptcmColumnManager = {
    fetchColumns(postType, nonce, callback, errorCallback) {
      $.ajax({
        url: PTCM.ajax_url,
        method: 'POST',
        dataType: 'json',
        data: {
          action: 'ptcm_get_columns',
          post_type: postType,
          screen_type: PTCM.screen_type,
          screen_context: PTCM.screen_context,
          nonce
        },
        success(res) {
          console.log(res)
          if(res.success == false ){
            ptcmUtils.toast(res.data.message , 'error');
          }
          
          callback(res);
          ptcmUtils.unblockUI();
        },
        error(xhr, status, error) {
          ptcmUtils.unblockUI();
          if (typeof errorCallback === 'function') {
            errorCallback({ xhr, status, error });
          } else {
            ptcmUtils.toast('Failed to fetch columns. Please try again.' , 'error');
          }
        }
      });
    },
    saveColumns(postType, nonce, columns, callback, errorCallback) {
      $.ajax({
        url: PTCM.ajax_url,
        method: 'POST',
        dataType: 'json',
        data: {
          action: 'ptcm_save_columns',
          post_type: postType,
          screen_type: PTCM.screen_type,
          screen_context: PTCM.screen_context,
          dsdsds : postType,
          nonce,
          columns
        },
        success(res) {  
                  
          callback(res);
          if(res.success == false ){
            ptcmUtils.toast(res.data.message , 'error');
            ptcmUtils.unblockUI();
          }
          //ptcmUtils.unblockUI();
        },
        error(xhr, status, error) {
          ptcmUtils.unblockUI();
          if (typeof errorCallback === 'function') {
            errorCallback({ xhr, status, error });
          } else {
            ptcmUtils.toast('Saving failed. Please try again.' , 'error')
          }
        }
      });
    },
    resetColumns(postType, nonce, callback, errorCallback) {
      $.ajax({
        url: PTCM.ajax_url,
        method: 'POST',
        dataType: 'json',
        data: {
          action: 'ptcm_reset_columns',
          post_type: postType,
          screen_type: PTCM.screen_type,
          screen_context: PTCM.screen_context,
          nonce
        },
        success(res) {
          ptcmUtils.unblockUI();
          callback(res);
        },
        error(xhr, status, error) {
          ptcmUtils.unblockUI();
          if (typeof errorCallback === 'function') {
            errorCallback({ xhr, status, error });
          } else {
            ptcmUtils.toast('Reset failed. Please try again.' , 'error');
          }
        }
      });
    }
  };
})(jQuery);
