jQuery(document).ready(function ($) {
  let ptcmSourceOptions = '';

  $('.ptcm-help').ptcmTooltip();

  const fetchAndRender = () => {
    $.ptcmColumnManager.fetchColumns(PTCM.post_type, PTCM.nonce, (res) => {
      if (res.success && res.data) {
        $('#ptcm-columns-list').empty();

        const sortedCols = res.data.columns.sort((a, b) => {
          return (b.enabled || 0) - (a.enabled || 0); // enabled==1 comes before 0 or undefined
        });

        sortedCols.forEach(col => $.ptcmRenderRow(col));

        ptcmUtils.doAction('ptcm.after_all_column_row_rendered', { sortedCols });

        ptcmUtils.extendAction('columnsRendered', res.data);

        ptcmUtils.unblockUI();
      }
    }, function (err) {
      ptcmUtils.toast('Unexpected error loading columns. [' + err.error + ']', 'error');
      //console.error(err);
    });
  };


  $('#ptcm-add-column').on('click', () => {

    const validGroups = ptcmUtils.labelOptions.filter(group => group.children && group.children.length > 0);
    const secondGroup = validGroups.length > 1 ? validGroups[1] : null;

    if (!secondGroup) return;

    const secondOption = secondGroup.children[0];

    if (ptcmUtils.isDuplicateKey(secondOption.id)) {
      ptcmUtils.toast({
        message: `DUPLICATE ENTRY - The Column "${secondOption.id}" is already added. You can REMOVE the row or CHANGE the option in the SELECT input box`,
        type: 'warning'
      });
      ptcmUtils.scrollToDuplicate(secondOption.id);
      return;
    }


    $.ptcmRenderRow({}, true)
    ptcmUtils.extendAction('addColumn');
  });

  $('#ptcm-save-columns').on('click', () => {
    //ptcmUtils.blockUI();
    const columns = [];
    $('#ptcm-columns-list .ptcm-column-row').each(function () {
      const $row = $(this);
      const key = $row.find('[data-field="key"]').val();
      const label = $row.find('[data-field="label"]').val();

      if (!key || !label) return;
      
      const col_label = $row.find('[data-field="col_label"]').val().trim();
      const source = $row.find('[data-field="source"]').val();
      const enabled = $row.find('.ptcm-enabled').is(':checked') ? 1 : 0;
      
      columns.push({ key, label, col_label, source, enabled });
    });

    $.ptcmColumnManager.saveColumns(PTCM.post_type, PTCM.nonce, columns, (res) => {
      if (res.success) {
        ptcmUtils.toast({
          message: 'Coumns Saved!',
          actionText: 'Redirecting...',
          onActionClick: () => { }
        });

        setTimeout(function () {
          location.reload();
        }, 1000);
      }
      //ptcmUtils.unblockUI();
    }, function (err) {
      ptcmUtils.toast('Unexpected error saving columns. [' + err.error + ']', 'error');
      //console.error(err);
    });
  });

  $('#ptcm-reset-columns').on('click', () => {
    if (confirm('Are you sure!')) {
      $.ptcmColumnManager.resetColumns(PTCM.post_type, PTCM.nonce, (res) => {
        ptcmUtils.blockUI();
        if (res.success) {
          ptcmUtils.toast('Columns Reset Successfully.!');
          setTimeout(function () {
            location.reload();
          }, 1000);
        }

      }, function (err) {
        ptcmUtils.toast('Unexpected error reseting columns. [' + err.error + ']', 'error');
        //console.error(err);
      });
    }
  });

  

  $(document).on('click', '.ptcm-close-icon', function(e) {
    $('#ptcm-hook-modal').removeClass('active');
});

  // Copy code & show toast
  $('#ptcm-copy-hook').on('click', () => {
    const code = $('#ptcm-hook-code').text();
    navigator.clipboard.writeText(code).then(() => {
      ptcmUtils.toast('Hook copied to clipboard!');
      $('#ptcm-hook-modal').removeClass('active');
    });
  });

  $(document).on('click', '#ptcm-open-settings', () => {
    $('#ptcm-post-type-name').text(PTCM.screen_label);
    $('#ptcm-popup').fadeIn();
    ptcmUtils.blockUI();
    document.body.classList.add('ptcm-no-scroll');
    fetchAndRender();
  });

  $('#ptcm-popup-close').on('click', () => {
    $('#ptcm-popup').fadeOut();
    document.body.classList.remove('ptcm-no-scroll');
  });

  $('#ptcm-select-all').on('change', function () {
    const checkboxes = $('#ptcm-columns-list .ptcm-enabled:not(:disabled)');

    if ($(this).is(':checked')) {
      checkboxes.prop('checked', true).trigger('change');
    } else {
      checkboxes.prop('checked', false).trigger('change');
    }

    ptcmUtils.extendAction('columnsToggleAll', {});
  });



  $(document).on('change', '.ptcm-enabled', function () {
    var checkbox = $(this)
    $(this).closest('.ptcm-column-row').toggleClass('ptcm-row-enabled', $(this).is(':checked'));
    ptcmUtils.extendAction('columnsToggleSingle', checkbox);
  });

  const insertBtn = () => {
    if ($('#ptcm-open-settings').length) return;
    const $btn = $('<a class="button button-primary ptcm-editor-btn" id="ptcm-open-settings"><span class="dashicons dashicons-editor-table freeicon"></span>Edit Columns</a>');
    const $btn2 = $('<a class="button button-primary ptcm-editor-btn1" id="ptcm-open-settings"><span class="dashicons dashicons-editor-table freeicon"></span>Edit Columns</a>');
    const $actions = $('.bulkactions');
    const $actions2 = $('#screen-meta-links');
    if ($actions.length) $actions.prepend($btn);
    if ($actions2.length) $actions2.prepend($btn2);
    //else $('#wpbody-content').prepend($btn);
  };

  if (PTCM.do_render_btn) {
    insertBtn();
  }

  function reloadAdminListTable(postType = 'post') {
    $.post(ajaxurl, { action: 'ptcm_reload_list_table', post_type: postType, nonce: PTCM.nonce }, function (res) {
      if (res.success && res.data.table_html) {
        $('.wp-list-table').replaceWith(res.data.table_html);
      } else {
        console.warn('Table reload failed:', res.data?.message || res);
      }
    });
  }



});
