<?php
/**
 * Bootstrap class for Post Picker for Gravity Forms
 *
 * @package post-picker-for-gravity-forms
 * @since   1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Bootstrap class for Post Picker for Gravity Forms.
 *
 * @since 1.0.0
 */
class PPFGF_Bootstrap {

	/**
	 * Initialize the plugin.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public static function init() {
		if ( self::is_gravityforms_active() ) {
			add_action( 'gform_loaded', array( __CLASS__, 'load' ), 5 );
		} else {
			add_action( 'admin_notices', array( __CLASS__, 'admin_notice' ) );
		}
	}

	/**
	 * Check if Gravity Forms is active.
	 *
	 * @since 1.0.0
	 * @return bool
	 */
	public static function is_gravityforms_active() {
		return class_exists( 'GFForms' );
	}

	/**
	 * Display admin notice when Gravity Forms is not active.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public static function admin_notice() {
		if ( ! current_user_can( 'activate_plugins' ) ) {
			return;
		}

		$message = sprintf(
			/* translators: 1: Plugin name, 2: Gravity Forms link */
			__( '%1$s requires %2$s to be installed and activated.', 'post-picker-for-gravity-forms' ),
			'<strong>' . esc_html__( 'Post Picker for Gravity Forms', 'post-picker-for-gravity-forms' ) . '</strong>',
			'<a href="https://www.gravityforms.com/" target="_blank">' . esc_html__( 'Gravity Forms', 'post-picker-for-gravity-forms' ) . '</a>'
		);

		printf(
			'<div class="notice notice-error"><p>%s</p></div>',
			wp_kses_post( $message )
		);
	}

	/**
	 * Load the add-on.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public static function load() {
		if ( ! method_exists( 'GFForms', 'include_addon_framework' ) ) {
			return;
		}

		require_once PPFGF_PATH . 'includes/class-ppfgf-addon.php';

		GFAddOn::register( 'PPFGF_AddOn' );
	}
}
