/**
 * Form editor JavaScript for Post Picker field.
 *
 * @package post-picker-for-gravity-forms
 * @since   1.0.0
 */

(function() {
	'use strict';

	// Add setting to field editor.
	fieldSettings.post_picker = '.label_setting, .description_setting, .post_type_setting, .placeholder_setting, .enable_enhanced_ui_setting, .size_setting, .css_class_setting, .visibility_setting, .conditional_logic_field_setting, .prepopulate_field_setting, .error_message_setting, .admin_label_setting, .rules_setting';

	// Bind to the load field settings event to initialize settings.
	jQuery(document).on('gform_load_field_settings', function(event, field, form) {
		if (field.type === 'post_picker') {
			jQuery('#ppfgf_post_type').val(field.ppfgf_post_type || 'post');
		}
	});

})();

/**
 * Set post type value from field editor.
 *
 * @param {string} value The post type value.
 */
function ppfgfSetPostType(value) {
	SetFieldProperty('ppfgf_post_type', value);
}
