<?php
/**
 * Post Engagement Widget Uninstall
 *
 * Triggered when the user clicks the "Delete" link for the
 * Post Engagement Widget plugin in the WordPress admin.
 *
 * @package   Post_Engagement_Widget
 * @version   1.0.0
 */

// If uninstall is not called from WordPress, exit
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// 1. Delete Options from the wp_options table
// --------------------------------------------------
delete_option('engage_widget_settings');
delete_option('engage_widget_version');


// 2. Delete Post Meta from the wp_postmeta table
// --------------------------------------------------
// This is more efficient than looping through every post.
delete_post_meta_by_key('_engage_widget_likes');
delete_post_meta_by_key('_engage_widget_dislikes');


// 3. Delete Comment Meta from the wp_commentmeta table
// --------------------------------------------------
delete_comment_meta_by_key('_engage_widget_comment_likes');
delete_comment_meta_by_key('_engage_widget_comment_dislikes');