<?php
/**
 * Plugin Name: Post Engagement Widget
 * Description: Adds Like/Dislike buttons with AJAX, color controls, emoji/text labels, guest option and auto-display on post.
 * Version: 1.0.0
 * Author: Vijay Parihar
 * Author URI: https://profiles.wordpress.org/vijayparihar002/
 * Text Domain: post-engagement-widget
 * License: GPL2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! defined( 'ENGAGE_WIDGET_VERSION' ) ) define( 'ENGAGE_WIDGET_VERSION', '1.0.0' );
if ( ! defined( 'ENGAGE_WIDGET_DIR' ) ) define( 'ENGAGE_WIDGET_DIR', plugin_dir_path( __FILE__ ) );
if ( ! defined( 'ENGAGE_WIDGET_URL' ) ) define( 'ENGAGE_WIDGET_URL', plugin_dir_url( __FILE__ ) );
if ( ! defined( 'ENGAGE_WIDGET_INC_DIR' ) ) define( 'ENGAGE_WIDGET_INC_DIR', ENGAGE_WIDGET_DIR . 'includes/' );
if ( ! defined( 'ENGAGE_WIDGET_ASSETS_URL' ) ) define( 'ENGAGE_WIDGET_ASSETS_URL', ENGAGE_WIDGET_URL . 'assets/' );

register_activation_hook( __FILE__, function() {
    if ( ! get_option( 'engage_widget_version' ) ) {
        update_option( 'engage_widget_version', ENGAGE_WIDGET_VERSION );
        update_option( 'engage_widget_settings', array(
            'like_color' => '#0073aa',
            'dislike_color' => '#d63638',
            'allow_guest' => 'no',
            'label_type' => 'emoji',
            'auto_display_on_posts' => 'yes',
            'enable_comment_engagement' => 'no'
        ) );
    }
} );

require_once ENGAGE_WIDGET_INC_DIR . 'class-engage-widget-admin.php';
require_once ENGAGE_WIDGET_INC_DIR . 'class-engage-widget-frontend.php';
require_once ENGAGE_WIDGET_INC_DIR . 'class-engage-widget-ajax.php';

add_action( 'plugins_loaded', function() {
    if ( is_admin() ) {
        $admin = new ENGAGE_WIDGET_Admin();
        $admin->init();
    }
    $frontend = new ENGAGE_WIDGET_Frontend();
    $frontend->init();
    $ajax = new ENGAGE_WIDGET_Ajax();
    $ajax->init();
}, 20);

function engage_widget_shortcode_display() {
    return ENGAGE_WIDGET_Frontend::render_buttons_for_current();
}
add_shortcode( 'engage_widgetment_widget', 'engage_widget_shortcode_display' );
