<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class ENGAGE_WIDGET_Admin {
    public function init() {
        add_action( 'admin_menu', array( $this, 'add_settings_page' ) );
        add_action( 'admin_init', array( $this, 'register_settings' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_assets' ) );
    }

    public function add_settings_page() {
        add_options_page( __( 'Post Engagement Settings', 'post-engagement-widget' ), __( 'Post Engagement', 'post-engagement-widget' ), 'manage_options', 'engage-widget-settings', array( $this, 'settings_page' ) );
    }

    public function register_settings() {
        register_setting( 'engage_widget_settings_group', 'engage_widget_settings', array( $this, 'sanitize' ) );
    }

    public function sanitize( $input ) {
        $out = array();
        $out['like_color'] = isset( $input['like_color'] ) ? sanitize_hex_color( $input['like_color'] ) : '#0073aa';
        $out['dislike_color'] = isset( $input['dislike_color'] ) ? sanitize_hex_color( $input['dislike_color'] ) : '#d63638';
        $out['allow_guest'] = isset( $input['allow_guest'] ) && $input['allow_guest'] === 'yes' ? 'yes' : 'no';
        $out['label_type'] = isset( $input['label_type'] ) && in_array( $input['label_type'], array('text','emoji'), true ) ? $input['label_type'] : 'emoji';
        $out['auto_display_on_posts'] = isset( $input['auto_display_on_posts'] ) && $input['auto_display_on_posts'] === 'yes' ? 'yes' : 'no';
        $out['enable_comment_engagement'] = isset( $input['enable_comment_engagement'] ) && $input['enable_comment_engagement'] === 'yes' ? 'yes' : 'no';

        /**
         * Filter the sanitized settings array before it is saved.
         *
         * @param array $out The sanitized output array.
         * @param array $input The raw input array from the form.
         */
        return apply_filters( 'engage_widget_sanitize_settings', $out, $input );
    }

    public function enqueue_admin_assets( $hook ) {
        if ( $hook !== 'settings_page_engage_widget-settings' ) return;
        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_script( 'engage-widget-admin-js', ENGAGE_WIDGET_ASSETS_URL . 'js/engage-widget-admin.js', array( 'wp-color-picker','jquery' ), ENGAGE_WIDGET_VERSION, true );
    }

    public function settings_page() {
        $settings = get_option( 'engage_widget_settings', array() );
        $like = isset( $settings['like_color'] ) ? $settings['like_color'] : '#0073aa';
        $dislike = isset( $settings['dislike_color'] ) ? $settings['dislike_color'] : '#d63638';
        $allow_guest = isset( $settings['allow_guest'] ) && $settings['allow_guest'] === 'yes' ? 'yes' : 'no';
        $label_type = isset( $settings['label_type'] ) ? $settings['label_type'] : 'emoji';
        $enabled = isset( $settings['post_types'] ) ? $settings['post_types'] : array('post');
        $enable_comments = isset( $settings['enable_comment_engagement'] ) && $settings['enable_comment_engagement'] === 'yes' ? 'yes' : 'no';

        $post_types = get_post_types( array( 'public' => true ), 'objects' );
        ?>
        <div class="wrap">
            <h1><?php echo esc_html( __( 'Post Engagement Settings', 'post-engagement-widget' ) ); ?></h1>
            <form method="post" action="options.php">
                <?php settings_fields( 'engage_widget_settings_group' ); do_settings_sections( 'engage_widget_settings_group' ); $settings_fields = get_option('engage_widget_settings'); ?>
                <table class="form-table">
                    <tr>
                        <th><?php echo esc_html( __( 'Auto Display', 'post-engagement-widget' ) ); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="engage_widget_settings[auto_display_on_posts]" value="yes" <?php checked( $settings['auto_display_on_posts'] ?? 'no', 'yes' ); ?> />
                                <?php echo esc_html( __( 'Automatically display buttons on all Posts', 'post-engagement-widget' ) ); ?>
                            </label>
                            <p class="description"><?php echo esc_html( __( 'If enabled, buttons will be added to the end of every blog post. For other content, use the [engage_widgetment_widget] shortcode.', 'post-engagement-widget' ) ); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th><?php echo esc_html( __( 'Allow Guest Voting', 'post-engagement-widget' ) ); ?></th>
                        <td><label><input type="checkbox" name="engage_widget_settings[allow_guest]" value="yes" <?php checked( $allow_guest, 'yes' ); ?> /> <?php echo esc_html( __( 'Allow non-logged-in users to vote', 'post-engagement-widget' ) ); ?></label></td>
                    </tr>
                    <tr>
                        <th><?php echo esc_html( __( 'Like Button Color', 'post-engagement-widget' ) ); ?></th>
                        <td><input type="text" class="engage-widget-color-field" name="engage_widget_settings[like_color]" value="<?php echo esc_attr( $like ); ?>" /></td>
                    </tr>
                    <tr>
                        <th><?php echo esc_html( __( 'Dislike Button Color', 'post-engagement-widget' ) ); ?></th>
                        <td><input type="text" class="engage-widget-color-field" name="engage_widget_settings[dislike_color]" value="<?php echo esc_attr( $dislike ); ?>" /></td>
                    </tr>
                    <tr>
                        <th><?php echo esc_html( __( 'Button Label Type', 'post-engagement-widget' ) ); ?></th>
                        <td>
                            <select name="engage_widget_settings[label_type]">
                                <option value="text" <?php selected( $label_type, 'text' ); ?>><?php echo esc_html( __( 'Text (Like / Dislike)', 'post-engagement-widget' ) ); ?></option>
                                <option value="emoji" <?php selected( $label_type, 'emoji' ); ?>><?php echo esc_html( __( 'Emoji (👍 👎)', 'post-engagement-widget' ) ); ?></option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th><?php echo esc_html( __( 'Comment Engagement', 'post-engagement-widget' ) ); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="engage_widget_settings[enable_comment_engagement]" value="yes" <?php checked( $enable_comments, 'yes' ); ?> />
                                <?php echo esc_html( __( 'Enable Like/Dislike on comments', 'post-engagement-widget' ) ); ?>
                            </label>
                            <p class="description"><?php echo esc_html( __( 'If enabled, like/dislike buttons will appear on all comments.', 'post-engagement-widget' ) ); ?></p>
                        </td>
                    </tr>
                    <?php
                    /**
                     * Fires after the main PEW settings fields, before the submit button.
                     *
                     * @param array $settings The current plugin settings.
                     */
                    do_action( 'engage_widget_after_settings_fields', $settings );
                    ?>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
        <script>jQuery(function($){$('.engage-widget-color-field').wpColorPicker();});</script>
        <?php
    }
}
