jQuery(document).ready(function ($) {
  "use strict";

  $(document).on(
    "click",
    ".engage-widget-wrapper .engage-widget-btn",
    function (e) {
      e.preventDefault();

      var $this = $(this);
      if ($this.hasClass("active") || $this.prop("disabled")) {
        return; // Agar button active hai to kuch mat karo.
      }

      var $wrapper = $this.closest(".engage-widget-wrapper");
      var $likeBtn = $wrapper.find(".engage-widget-like");
      var $dislikeBtn = $wrapper.find(".engage-widget-dislike");
      var $countSpan = $this.find(".engage-widget-count");

      // --- Optimistic UI Update ---
      // UI ko server response se pehle hi update kar do.
      var originalCount = parseInt($countSpan.text(), 10);
      $countSpan.text(originalCount + 1);

      // Agar vote switch kar rahe hain (like se dislike), to dusre button ka count kam karo.
      var $otherBtn = $this.is(".engage-widget-like") ? $dislikeBtn : $likeBtn;
      if ($otherBtn.hasClass("active")) {
        var $otherCountSpan = $otherBtn.find(".engage-widget-count");
        var otherOriginalCount = parseInt($otherCountSpan.text(), 10);
        $otherCountSpan.text(Math.max(0, otherOriginalCount - 1));
      }

      $likeBtn.removeClass("active").prop("disabled", false);
      $dislikeBtn.removeClass("active").prop("disabled", false);
      $this.addClass("active").prop("disabled", true);

      // AJAX call ke liye data taiyar karo.
      var postId = $wrapper.data("post-id");
      var commentId = $wrapper.data("comment-id");
      var ajaxData = {
        nonce: engage_widget_ajax.nonce,
        vote: $this.data("vote"),
      };

      if (typeof postId !== "undefined") {
        ajaxData.action = "engage_widget_vote";
        ajaxData.post_id = postId;
      } else if (typeof commentId !== "undefined") {
        ajaxData.action = "engage_widget_comment_vote";
        ajaxData.comment_id = commentId;
      } else {
        return;
      }

      $.ajax({
        type: "POST",
        url: engage_widget_ajax.ajax_url,
        data: ajaxData,
        success: function (response) {
          if (response.success) {
            // Success: Server se final count sync kar lo.
            $likeBtn.find(".engage-widget-count").text(response.data.likes);
            $dislikeBtn
              .find(".engage-widget-count")
              .text(response.data.dislikes);
          } else {
            // Failure: UI ko wapas original state me lao.
            alert(response.data.message);
            $countSpan.text(originalCount);
            // Yahan zaroorat ke hisab se full UI revert karna pad sakta hai.
          }
        },
        error: function () {
          // Server/Network Error: UI ko revert karo.
          alert("An error occurred. Please try again.");
          $countSpan.text(originalCount);
          $this.removeClass("active").prop("disabled", false);
          if ($otherBtn.hasClass("active")) {
            $otherBtn.find(".engage-widget-count").text(otherOriginalCount + 1);
          }
        },
      });
    }
  );
});
