const defaultConfig = require('@wordpress/scripts/config/webpack.config');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const IgnoreEmitPlugin = require('ignore-emit-webpack-plugin');

const path = require('path');
const CopyPlugin = require('copy-webpack-plugin');

const camelCaseDash = (string) =>
	string.replace(/-([a-z])/g, (_match, letter) => letter.toUpperCase());

const externals = [
	'api-fetch',
	'block-editor',
	'blocks',
	'components',
	'compose',
	'data',
	'date',
	'htmlEntities',
	'hooks',
	'edit-post',
	'element',
	'editor',
	'i18n',
	'plugins',
	'viewport',
	'ajax',
	'codeEditor',
	'rich-text',
	'primitives',
];

const globals = externals.reduce(
	(external, name) => ({
		...external,
		[`@wordpress/${name}`]: `wp.${camelCaseDash(name)}`,
	}),
	{}
);

const config = {
	...defaultConfig,
	entry: {
		plugin: './src/index.js',
		styling: './src/style.scss',
	},
	output: {
		clean: false,
		path: path.join(__dirname, './dist'),
	},
	plugins: [
		...defaultConfig.plugins,

		new MiniCssExtractPlugin({
			filename: (pathData) => {
				const filename = pathData.chunk.name.replace(
					/(style-|-style)/g,
					''
				);

				return `${filename}.css`;
			},
		}),

		// TODO: can we implement a better logic, other than surpressing the build chunks?
		new IgnoreEmitPlugin(/(base.js)/i),
	],
	externals: {
		wp: 'wp',
		lodash: '_',
		react: 'React',
		'react-dom': 'ReactDOM',
		...globals,
	},
};

module.exports = config;
