/**
 * Checks if the modified date is more recent than the original date.
 *
 * @param {Object} obj - An object containing `date` and `modifiedDate` properties.
 * @param {string} obj.date - The original date in ISO 8601 format.
 * @param {string} obj.modifiedDate - The modified date in ISO 8601 format.
 * @returns {boolean} - Returns true if `modifiedDate` is more recent than `date`, false otherwise.
 */
export function isModified({ date, modifiedDate }) {
	// Parse the dates from the provided ISO 8601 format strings.
	const originalDate = new Date(date);
	const modDate = new Date(modifiedDate);

	// Compare the two dates.
	return modDate > originalDate;
}
