import { isModified as isCurrentPostModified } from './utils';

/**
 * Hook to determine the rendered date type.
 *
 * @param {string} id - The block id.
 *
 * @return {string} The rendered date type.
 */
export function useRenderedDateType(id) {
	const block = document.querySelector(`#block-${id}`);

	if (!block || block?.dataset?.type !== 'core/post-date') {
		return 'published';
	}

	const meta = block.querySelector('.sppl-meta');
	const postId = meta.dataset.postId;
	const postType = meta.dataset.postType;

	const [date] = useEntityProp('postType', postType, 'date', postId);
	const [modifiedDate] = useEntityProp(
		'postType',
		postType,
		'modified',
		postId
	);

	const isModified = isCurrentPostModified({
		date,
		modifiedDate,
	});

	return isModified ? 'modified' : 'published';
}
