# Post Date Labels

![Post Date Labels (Banner)](https://github.com/user-attachments/assets/368caa93-384e-4a92-92b0-5437a8ca74a3)

A lightweight WordPress plugin that enhances the post date block by allowing you to add contextual labels before and after the date.

## 🚀 Features

- **Custom Labels**: Add prefix and suffix labels to post date blocks
- **Smart Detection**: Automatically detects published vs modified dates
- **Separate Controls**: Different labels for published and modified dates
- **Clean Output**: Semantic HTML with proper CSS classes
- **Block Editor Integration**: Native WordPress block editor support
- **Performance Optimized**: Lightweight with minimal resource usage
- **Developer Friendly**: Well-documented, extensible code

## 📋 Requirements

- WordPress 5.8 or higher
- PHP 7.0 or higher

## 🔧 Installation

### From WordPress.org

1. Go to your WordPress admin dashboard
2. Navigate to **Plugins > Add New**
3. Search for "Post Date Labels"
4. Click **Install Now** and then **Activate**

### Manual Installation

1. Download the plugin from the [WordPress.org repository](https://wordpress.org/plugins/post-date-labels/)
2. Upload the `post-date-labels` folder to `/wp-content/plugins/`
3. Activate the plugin through the **Plugins** menu in WordPress

### From GitHub

```bash
cd wp-content/plugins/
git clone https://github.com/smallplugins/post-date-labels.git
```

## 📖 Usage

1. Edit any post or page in the WordPress block editor
2. Add a **Post Date** block
3. In the block sidebar, you'll find new options for:
    - Published date prefix/suffix
    - Modified date prefix/suffix
4. The plugin automatically applies the appropriate labels based on the date type being displayed

### Example Output

```html
<div class="wp-block-post-date">
	<span class="post-date-prefix post-date-published-prefix"
		>Published on</span
	>
	<time datetime="2024-01-15T10:30:00+00:00">January 15, 2024</time>
	<span class="post-date-suffix post-date-published-suffix">UTC</span>
</div>
```

## 🎨 Styling

The plugin provides CSS classes for easy customization:

### General Classes

- `.post-date-affix` - All prefix/suffix elements
- `.post-date-prefix` - All prefix elements
- `.post-date-suffix` - All suffix elements

### Published Date Classes

- `.post-date-published-prefix` - Published date prefix
- `.post-date-published-suffix` - Published date suffix

### Modified Date Classes

- `.post-date-modified-prefix` - Modified date prefix
- `.post-date-modified-suffix` - Modified date suffix

### Example CSS

```css
.post-date-prefix {
	font-weight: bold;
	color: #666;
}

.post-date-published-prefix {
	color: #0073aa;
}

.post-date-modified-prefix {
	color: #d63638;
}
```

## 📝 Changelog

### Version 1.0.1

- Initial release

### Version 1.0.0

- Internal release
- Add prefix and suffix labels to post date blocks
- Automatic detection of published vs modified dates
- Clean HTML output with semantic CSS classes
- Block editor integration with sidebar controls
