<?php
/**
 * The framework typography fields file.
 *
 * @package Smart_Post_Show
 * @subpackage Smart_Post_Show/admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( ! function_exists( 'spf_get_google_fonts' ) ) {
  function spf_get_google_fonts() {
    return array(
      'ABeeZee' => array( array('normal','italic'), array('latin') ),
      'Abel' => array( array('normal'), array('latin') ),
      'Abhaya Libre' => array( array('normal','500','600','700','800'), array('latin-ext','sinhala','latin') ),
      'Abril Fatface' => array( array('normal'), array('latin-ext','latin') ),
      'Aclonica' => array( array('normal'), array('latin') ),
      'Acme' => array( array('normal'), array('latin') ),
      'Actor' => array( array('normal'), array('latin') ),
      'Adamina' => array( array('normal'), array('latin') ),
      'Advent Pro' => array( array('100','200','300','normal','500','600','700'), array('latin-ext','greek','latin') ),
      'Aguafina Script' => array( array('normal'), array('latin-ext','latin') ),
      'Akronim' => array( array('normal'), array('latin-ext','latin') ),
      'Aladin' => array( array('normal'), array('latin-ext','latin') ),
      'Aldrich' => array( array('normal'), array('latin') ),
      'Alef' => array( array('normal','700'), array('hebrew','latin') ),
      'Alegreya' => array( array('normal','italic','500','500italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Alegreya SC' => array( array('normal','italic','500','500italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Alegreya Sans' => array( array('100','100italic','300','300italic','normal','italic','500','500italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Alegreya Sans SC' => array( array('100','100italic','300','300italic','normal','italic','500','500italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Aleo' => array( array('300','300italic','normal','italic','700','700italic'), array('latin-ext','latin') ),
      'Alex Brush' => array( array('normal'), array('latin-ext','latin') ),
      'Alfa Slab One' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Alice' => array( array('normal'), array('cyrillic','cyrillic-ext','latin') ),
      'Alike' => array( array('normal'), array('latin') ),
      'Alike Angular' => array( array('normal'), array('latin') ),
      'Allan' => array( array('normal','700'), array('latin-ext','latin') ),
      'Allerta' => array( array('normal'), array('latin') ),
      'Allerta Stencil' => array( array('normal'), array('latin') ),
      'Allura' => array( array('normal'), array('latin-ext','latin') ),
      'Almendra' => array( array('normal','italic','700','700italic'), array('latin-ext','latin') ),
      'Almendra Display' => array( array('normal'), array('latin-ext','latin') ),
      'Almendra SC' => array( array('normal'), array('latin') ),
      'Amarante' => array( array('normal'), array('latin-ext','latin') ),
      'Amaranth' => array( array('normal','italic','700','700italic'), array('latin') ),
      'Amatic SC' => array( array('normal','700'), array('latin-ext','cyrillic','hebrew','latin','vietnamese') ),
      'Amethysta' => array( array('normal'), array('latin') ),
      'Amiko' => array( array('normal','600','700'), array('latin-ext','latin','devanagari') ),
      'Amiri' => array( array('normal','italic','700','700italic'), array('latin-ext','arabic','latin') ),
      'Amita' => array( array('normal','700'), array('latin-ext','latin','devanagari') ),
      'Anaheim' => array( array('normal'), array('latin-ext','latin') ),
      'Andada' => array( array('normal'), array('latin-ext','latin') ),
      'Andika' => array( array('normal'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Angkor' => array( array('normal'), array('khmer') ),
      'Annie Use Your Telescope' => array( array('normal'), array('latin') ),
      'Anonymous Pro' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','greek','latin') ),
      'Antic' => array( array('normal'), array('latin') ),
      'Antic Didone' => array( array('normal'), array('latin') ),
      'Antic Slab' => array( array('normal'), array('latin') ),
      'Anton' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Arapey' => array( array('normal','italic'), array('latin') ),
      'Arbutus' => array( array('normal'), array('latin-ext','latin') ),
      'Arbutus Slab' => array( array('normal'), array('latin-ext','latin') ),
      'Architects Daughter' => array( array('normal'), array('latin') ),
      'Archivo' => array( array('normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','vietnamese') ),
      'Archivo Black' => array( array('normal'), array('latin-ext','latin') ),
      'Archivo Narrow' => array( array('normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','vietnamese') ),
      'Aref Ruqaa' => array( array('normal','700'), array('arabic','latin') ),
      'Arima Madurai' => array( array('100','200','300','normal','500','700','800','900'), array('latin-ext','tamil','latin','vietnamese') ),
      'Arimo' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','hebrew','latin','greek-ext','vietnamese') ),
      'Arizonia' => array( array('normal'), array('latin-ext','latin') ),
      'Armata' => array( array('normal'), array('latin-ext','latin') ),
      'Arsenal' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Artifika' => array( array('normal'), array('latin') ),
      'Arvo' => array( array('normal','italic','700','700italic'), array('latin') ),
      'Arya' => array( array('normal','700'), array('latin-ext','latin','devanagari') ),
      'Asap' => array( array('normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','vietnamese') ),
      'Asap Condensed' => array( array('normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','vietnamese') ),
      'Asar' => array( array('normal'), array('latin-ext','latin','devanagari') ),
      'Asset' => array( array('normal'), array('latin') ),
      'Assistant' => array( array('200','300','normal','600','700','800'), array('hebrew','latin') ),
      'Astloch' => array( array('normal','700'), array('latin') ),
      'Asul' => array( array('normal','700'), array('latin') ),
      'Athiti' => array( array('200','300','normal','500','600','700'), array('latin-ext','latin','thai','vietnamese') ),
      'Atma' => array( array('300','normal','500','600','700'), array('bengali','latin-ext','latin') ),
      'Atomic Age' => array( array('normal'), array('latin') ),
      'Aubrey' => array( array('normal'), array('latin') ),
      'Audiowide' => array( array('normal'), array('latin-ext','latin') ),
      'Autour One' => array( array('normal'), array('latin-ext','latin') ),
      'Average' => array( array('normal'), array('latin-ext','latin') ),
      'Average Sans' => array( array('normal'), array('latin-ext','latin') ),
      'Averia Gruesa Libre' => array( array('normal'), array('latin-ext','latin') ),
      'Averia Libre' => array( array('300','300italic','normal','italic','700','700italic'), array('latin') ),
      'Averia Sans Libre' => array( array('300','300italic','normal','italic','700','700italic'), array('latin') ),
      'Averia Serif Libre' => array( array('300','300italic','normal','italic','700','700italic'), array('latin') ),
      'B612' => array( array('normal','italic','700','700italic'), array('latin') ),
      'B612 Mono' => array( array('normal','italic','700','700italic'), array('latin') ),
      'Bad Script' => array( array('normal'), array('cyrillic','latin') ),
      'Bahiana' => array( array('normal'), array('latin-ext','latin') ),
      'Bahianita' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Bai Jamjuree' => array( array('200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Baloo' => array( array('normal'), array('latin-ext','latin','devanagari','vietnamese') ),
      'Baloo Bhai' => array( array('normal'), array('latin-ext','gujarati','latin','vietnamese') ),
      'Baloo Bhaijaan' => array( array('normal'), array('latin-ext','arabic','latin','vietnamese') ),
      'Baloo Bhaina' => array( array('normal'), array('latin-ext','oriya','latin','vietnamese') ),
      'Baloo Chettan' => array( array('normal'), array('latin-ext','malayalam','latin','vietnamese') ),
      'Baloo Da' => array( array('normal'), array('bengali','latin-ext','latin','vietnamese') ),
      'Baloo Paaji' => array( array('normal'), array('latin-ext','gurmukhi','latin','vietnamese') ),
      'Baloo Tamma' => array( array('normal'), array('latin-ext','kannada','latin','vietnamese') ),
      'Baloo Tammudu' => array( array('normal'), array('latin-ext','telugu','latin','vietnamese') ),
      'Baloo Thambi' => array( array('normal'), array('latin-ext','tamil','latin','vietnamese') ),
      'Balthazar' => array( array('normal'), array('latin') ),
      'Bangers' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Barlow' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','vietnamese') ),
      'Barlow Condensed' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','vietnamese') ),
      'Barlow Semi Condensed' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','vietnamese') ),
      'Barriecito' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Barrio' => array( array('normal'), array('latin-ext','latin') ),
      'Basic' => array( array('normal'), array('latin-ext','latin') ),
      'Battambang' => array( array('normal','700'), array('khmer') ),
      'Baumans' => array( array('normal'), array('latin') ),
      'Bayon' => array( array('normal'), array('khmer') ),
      'Belgrano' => array( array('normal'), array('latin') ),
      'Bellefair' => array( array('normal'), array('latin-ext','hebrew','latin') ),
      'Belleza' => array( array('normal'), array('latin-ext','latin') ),
      'BenchNine' => array( array('300','normal','700'), array('latin-ext','latin') ),
      'Bentham' => array( array('normal'), array('latin') ),
      'Berkshire Swash' => array( array('normal'), array('latin-ext','latin') ),
      'Beth Ellen' => array( array('normal'), array('latin') ),
      'Bevan' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Bigelow Rules' => array( array('normal'), array('latin-ext','latin') ),
      'Bigshot One' => array( array('normal'), array('latin') ),
      'Bilbo' => array( array('normal'), array('latin-ext','latin') ),
      'Bilbo Swash Caps' => array( array('normal'), array('latin-ext','latin') ),
      'BioRhyme' => array( array('200','300','normal','700','800'), array('latin-ext','latin') ),
      'BioRhyme Expanded' => array( array('200','300','normal','700','800'), array('latin-ext','latin') ),
      'Biryani' => array( array('200','300','normal','600','700','800','900'), array('latin-ext','latin','devanagari') ),
      'Bitter' => array( array('normal','italic','700'), array('latin-ext','latin') ),
      'Black And White Picture' => array( array('normal'), array('korean','latin') ),
      'Black Han Sans' => array( array('normal'), array('korean','latin') ),
      'Black Ops One' => array( array('normal'), array('latin-ext','latin') ),
      'Blinker' => array( array('100','200','300','normal','600','700','800','900'), array('latin-ext','latin') ),
      'Bokor' => array( array('normal'), array('khmer') ),
      'Bonbon' => array( array('normal'), array('latin') ),
      'Boogaloo' => array( array('normal'), array('latin') ),
      'Bowlby One' => array( array('normal'), array('latin') ),
      'Bowlby One SC' => array( array('normal'), array('latin-ext','latin') ),
      'Brawler' => array( array('normal'), array('latin') ),
      'Bree Serif' => array( array('normal'), array('latin-ext','latin') ),
      'Bubblegum Sans' => array( array('normal'), array('latin-ext','latin') ),
      'Bubbler One' => array( array('normal'), array('latin-ext','latin') ),
      'Buda' => array( array('300'), array('latin') ),
      'Buenard' => array( array('normal','700'), array('latin-ext','latin') ),
      'Bungee' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Bungee Hairline' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Bungee Inline' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Bungee Outline' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Bungee Shade' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Butcherman' => array( array('normal'), array('latin-ext','latin') ),
      'Butterfly Kids' => array( array('normal'), array('latin-ext','latin') ),
      'Cabin' => array( array('normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','vietnamese') ),
      'Cabin Condensed' => array( array('normal','500','600','700'), array('latin-ext','latin','vietnamese') ),
      'Cabin Sketch' => array( array('normal','700'), array('latin') ),
      'Caesar Dressing' => array( array('normal'), array('latin') ),
      'Cagliostro' => array( array('normal'), array('latin') ),
      'Cairo' => array( array('200','300','normal','600','700','900'), array('latin-ext','arabic','latin') ),
      'Calligraffitti' => array( array('normal'), array('latin') ),
      'Cambay' => array( array('normal','italic','700','700italic'), array('latin-ext','latin','devanagari') ),
      'Cambo' => array( array('normal'), array('latin') ),
      'Candal' => array( array('normal'), array('latin') ),
      'Cantarell' => array( array('normal','italic','700','700italic'), array('latin') ),
      'Cantata One' => array( array('normal'), array('latin-ext','latin') ),
      'Cantora One' => array( array('normal'), array('latin-ext','latin') ),
      'Capriola' => array( array('normal'), array('latin-ext','latin') ),
      'Cardo' => array( array('normal','italic','700'), array('latin-ext','greek','latin','greek-ext') ),
      'Carme' => array( array('normal'), array('latin') ),
      'Carrois Gothic' => array( array('normal'), array('latin') ),
      'Carrois Gothic SC' => array( array('normal'), array('latin') ),
      'Carter One' => array( array('normal'), array('latin') ),
      'Catamaran' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','tamil','latin') ),
      'Caudex' => array( array('normal','italic','700','700italic'), array('latin-ext','greek','latin','greek-ext') ),
      'Caveat' => array( array('normal','700'), array('latin-ext','cyrillic','cyrillic-ext','latin') ),
      'Caveat Brush' => array( array('normal'), array('latin-ext','latin') ),
      'Cedarville Cursive' => array( array('normal'), array('latin') ),
      'Ceviche One' => array( array('normal'), array('latin-ext','latin') ),
      'Chakra Petch' => array( array('300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Changa' => array( array('200','300','normal','500','600','700','800'), array('latin-ext','arabic','latin') ),
      'Changa One' => array( array('normal','italic'), array('latin') ),
      'Chango' => array( array('normal'), array('latin-ext','latin') ),
      'Charm' => array( array('normal','700'), array('latin-ext','latin','thai','vietnamese') ),
      'Charmonman' => array( array('normal','700'), array('latin-ext','latin','thai','vietnamese') ),
      'Chathura' => array( array('100','300','normal','700','800'), array('telugu','latin') ),
      'Chau Philomene One' => array( array('normal','italic'), array('latin-ext','latin') ),
      'Chela One' => array( array('normal'), array('latin-ext','latin') ),
      'Chelsea Market' => array( array('normal'), array('latin-ext','latin') ),
      'Chenla' => array( array('normal'), array('khmer') ),
      'Cherry Cream Soda' => array( array('normal'), array('latin') ),
      'Cherry Swash' => array( array('normal','700'), array('latin-ext','latin') ),
      'Chewy' => array( array('normal'), array('latin') ),
      'Chicle' => array( array('normal'), array('latin-ext','latin') ),
      'Chivo' => array( array('300','300italic','normal','italic','700','700italic','900','900italic'), array('latin-ext','latin') ),
      'Chonburi' => array( array('normal'), array('latin-ext','latin','thai','vietnamese') ),
      'Cinzel' => array( array('normal','700','900'), array('latin-ext','latin') ),
      'Cinzel Decorative' => array( array('normal','700','900'), array('latin') ),
      'Clicker Script' => array( array('normal'), array('latin-ext','latin') ),
      'Coda' => array( array('normal','800'), array('latin-ext','latin') ),
      'Coda Caption' => array( array('800'), array('latin-ext','latin') ),
      'Codystar' => array( array('300','normal'), array('latin-ext','latin') ),
      'Coiny' => array( array('normal'), array('latin-ext','tamil','latin','vietnamese') ),
      'Combo' => array( array('normal'), array('latin-ext','latin') ),
      'Comfortaa' => array( array('300','normal','500','600','700'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','vietnamese') ),
      'Coming Soon' => array( array('normal'), array('latin') ),
      'Concert One' => array( array('normal'), array('latin-ext','latin') ),
      'Condiment' => array( array('normal'), array('latin-ext','latin') ),
      'Content' => array( array('normal','700'), array('khmer') ),
      'Contrail One' => array( array('normal'), array('latin') ),
      'Convergence' => array( array('normal'), array('latin') ),
      'Cookie' => array( array('normal'), array('latin') ),
      'Copse' => array( array('normal'), array('latin') ),
      'Corben' => array( array('normal','700'), array('latin-ext','latin') ),
      'Cormorant' => array( array('300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Cormorant Garamond' => array( array('300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Cormorant Infant' => array( array('300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Cormorant SC' => array( array('300','normal','500','600','700'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Cormorant Unicase' => array( array('300','normal','500','600','700'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Cormorant Upright' => array( array('300','normal','500','600','700'), array('latin-ext','latin','vietnamese') ),
      'Courgette' => array( array('normal'), array('latin-ext','latin') ),
      'Cousine' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','hebrew','latin','greek-ext','vietnamese') ),
      'Coustard' => array( array('normal','900'), array('latin') ),
      'Covered By Your Grace' => array( array('normal'), array('latin') ),
      'Crafty Girls' => array( array('normal'), array('latin') ),
      'Creepster' => array( array('normal'), array('latin') ),
      'Crete Round' => array( array('normal','italic'), array('latin-ext','latin') ),
      'Crimson Pro' => array( array('200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','vietnamese') ),
      'Crimson Text' => array( array('normal','italic','600','600italic','700','700italic'), array('latin') ),
      'Croissant One' => array( array('normal'), array('latin-ext','latin') ),
      'Crushed' => array( array('normal'), array('latin') ),
      'Cuprum' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Cute Font' => array( array('normal'), array('korean','latin') ),
      'Cutive' => array( array('normal'), array('latin-ext','latin') ),
      'Cutive Mono' => array( array('normal'), array('latin-ext','latin') ),
      'DM Sans' => array( array('normal','italic','500','500italic','700','700italic'), array('latin-ext','latin') ),
      'DM Serif Display' => array( array('normal','italic'), array('latin-ext','latin') ),
      'DM Serif Text' => array( array('normal','italic'), array('latin-ext','latin') ),
      'Damion' => array( array('normal'), array('latin') ),
      'Dancing Script' => array( array('normal','700'), array('latin-ext','latin','vietnamese') ),
      'Dangrek' => array( array('normal'), array('khmer') ),
      'Darker Grotesque' => array( array('300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'David Libre' => array( array('normal','500','700'), array('latin-ext','hebrew','latin','vietnamese') ),
      'Dawning of a New Day' => array( array('normal'), array('latin') ),
      'Days One' => array( array('normal'), array('latin') ),
      'Dekko' => array( array('normal'), array('latin-ext','latin','devanagari') ),
      'Delius' => array( array('normal'), array('latin') ),
      'Delius Swash Caps' => array( array('normal'), array('latin') ),
      'Delius Unicase' => array( array('normal','700'), array('latin') ),
      'Della Respira' => array( array('normal'), array('latin') ),
      'Denk One' => array( array('normal'), array('latin-ext','latin') ),
      'Devonshire' => array( array('normal'), array('latin-ext','latin') ),
      'Dhurjati' => array( array('normal'), array('telugu','latin') ),
      'Didact Gothic' => array( array('normal'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext') ),
      'Diplomata' => array( array('normal'), array('latin-ext','latin') ),
      'Diplomata SC' => array( array('normal'), array('latin-ext','latin') ),
      'Do Hyeon' => array( array('normal'), array('korean','latin') ),
      'Dokdo' => array( array('normal'), array('korean','latin') ),
      'Domine' => array( array('normal','700'), array('latin-ext','latin') ),
      'Donegal One' => array( array('normal'), array('latin-ext','latin') ),
      'Doppio One' => array( array('normal'), array('latin-ext','latin') ),
      'Dorsa' => array( array('normal'), array('latin') ),
      'Dosis' => array( array('200','300','normal','500','600','700','800'), array('latin-ext','latin','vietnamese') ),
      'Dr Sugiyama' => array( array('normal'), array('latin-ext','latin') ),
      'Duru Sans' => array( array('normal'), array('latin-ext','latin') ),
      'Dynalight' => array( array('normal'), array('latin-ext','latin') ),
      'EB Garamond' => array( array('normal','italic','500','500italic','600','600italic','700','700italic','800','800italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Eagle Lake' => array( array('normal'), array('latin-ext','latin') ),
      'East Sea Dokdo' => array( array('normal'), array('korean','latin') ),
      'Eater' => array( array('normal'), array('latin-ext','latin') ),
      'Economica' => array( array('normal','italic','700','700italic'), array('latin-ext','latin') ),
      'Eczar' => array( array('normal','500','600','700','800'), array('latin-ext','latin','devanagari') ),
      'El Messiri' => array( array('normal','500','600','700'), array('cyrillic','arabic','latin') ),
      'Electrolize' => array( array('normal'), array('latin') ),
      'Elsie' => array( array('normal','900'), array('latin-ext','latin') ),
      'Elsie Swash Caps' => array( array('normal','900'), array('latin-ext','latin') ),
      'Emblema One' => array( array('normal'), array('latin-ext','latin') ),
      'Emilys Candy' => array( array('normal'), array('latin-ext','latin') ),
      'Encode Sans' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'Encode Sans Condensed' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'Encode Sans Expanded' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'Encode Sans Semi Condensed' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'Encode Sans Semi Expanded' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'Engagement' => array( array('normal'), array('latin') ),
      'Englebert' => array( array('normal'), array('latin-ext','latin') ),
      'Enriqueta' => array( array('normal','500','600','700'), array('latin-ext','latin') ),
      'Erica One' => array( array('normal'), array('latin-ext','latin') ),
      'Esteban' => array( array('normal'), array('latin-ext','latin') ),
      'Euphoria Script' => array( array('normal'), array('latin-ext','latin') ),
      'Ewert' => array( array('normal'), array('latin-ext','latin') ),
      'Exo' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','vietnamese') ),
      'Exo 2' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','cyrillic','latin') ),
      'Expletus Sans' => array( array('normal','italic','500','500italic','600','600italic','700','700italic'), array('latin') ),
      'Fahkwang' => array( array('200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Fanwood Text' => array( array('normal','italic'), array('latin') ),
      'Farro' => array( array('300','normal','500','700'), array('latin-ext','latin') ),
      'Farsan' => array( array('normal'), array('latin-ext','gujarati','latin','vietnamese') ),
      'Fascinate' => array( array('normal'), array('latin') ),
      'Fascinate Inline' => array( array('normal'), array('latin') ),
      'Faster One' => array( array('normal'), array('latin') ),
      'Fasthand' => array( array('normal'), array('khmer') ),
      'Fauna One' => array( array('normal'), array('latin-ext','latin') ),
      'Faustina' => array( array('normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','vietnamese') ),
      'Federant' => array( array('normal'), array('latin') ),
      'Federo' => array( array('normal'), array('latin') ),
      'Felipa' => array( array('normal'), array('latin-ext','latin') ),
      'Fenix' => array( array('normal'), array('latin-ext','latin') ),
      'Finger Paint' => array( array('normal'), array('latin') ),
      'Fira Code' => array( array('300','normal','500','600','700'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext') ),
      'Fira Mono' => array( array('normal','500','700'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext') ),
      'Fira Sans' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Fira Sans Condensed' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Fira Sans Extra Condensed' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Fjalla One' => array( array('normal'), array('latin-ext','latin') ),
      'Fjord One' => array( array('normal'), array('latin') ),
      'Flamenco' => array( array('300','normal'), array('latin') ),
      'Flavors' => array( array('normal'), array('latin-ext','latin') ),
      'Fondamento' => array( array('normal','italic'), array('latin-ext','latin') ),
      'Fontdiner Swanky' => array( array('normal'), array('latin') ),
      'Forum' => array( array('normal'), array('latin-ext','cyrillic','cyrillic-ext','latin') ),
      'Francois One' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Frank Ruhl Libre' => array( array('300','normal','500','700','900'), array('latin-ext','hebrew','latin') ),
      'Freckle Face' => array( array('normal'), array('latin-ext','latin') ),
      'Fredericka the Great' => array( array('normal'), array('latin-ext','latin') ),
      'Fredoka One' => array( array('normal'), array('latin') ),
      'Freehand' => array( array('normal'), array('khmer') ),
      'Fresca' => array( array('normal'), array('latin-ext','latin') ),
      'Frijole' => array( array('normal'), array('latin') ),
      'Fruktur' => array( array('normal'), array('latin-ext','latin') ),
      'Fugaz One' => array( array('normal'), array('latin') ),
      'GFS Didot' => array( array('normal'), array('greek') ),
      'GFS Neohellenic' => array( array('normal','italic','700','700italic'), array('greek') ),
      'Gabriela' => array( array('normal'), array('cyrillic','cyrillic-ext','latin') ),
      'Gaegu' => array( array('300','normal','700'), array('korean','latin') ),
      'Gafata' => array( array('normal'), array('latin-ext','latin') ),
      'Galada' => array( array('normal'), array('bengali','latin') ),
      'Galdeano' => array( array('normal'), array('latin') ),
      'Galindo' => array( array('normal'), array('latin-ext','latin') ),
      'Gamja Flower' => array( array('normal'), array('korean','latin') ),
      'Gentium Basic' => array( array('normal','italic','700','700italic'), array('latin-ext','latin') ),
      'Gentium Book Basic' => array( array('normal','italic','700','700italic'), array('latin-ext','latin') ),
      'Geo' => array( array('normal','italic'), array('latin') ),
      'Geostar' => array( array('normal'), array('latin') ),
      'Geostar Fill' => array( array('normal'), array('latin') ),
      'Germania One' => array( array('normal'), array('latin') ),
      'Gidugu' => array( array('normal'), array('telugu','latin') ),
      'Gilda Display' => array( array('normal'), array('latin-ext','latin') ),
      'Give You Glory' => array( array('normal'), array('latin') ),
      'Glass Antiqua' => array( array('normal'), array('latin-ext','latin') ),
      'Glegoo' => array( array('normal','700'), array('latin-ext','latin','devanagari') ),
      'Gloria Hallelujah' => array( array('normal'), array('latin') ),
      'Goblin One' => array( array('normal'), array('latin') ),
      'Gochi Hand' => array( array('normal'), array('latin') ),
      'Gorditas' => array( array('normal','700'), array('latin') ),
      'Gothic A1' => array( array('100','200','300','normal','500','600','700','800','900'), array('korean','latin') ),
      'Goudy Bookletter 1911' => array( array('normal'), array('latin') ),
      'Graduate' => array( array('normal'), array('latin') ),
      'Grand Hotel' => array( array('normal'), array('latin-ext','latin') ),
      'Gravitas One' => array( array('normal'), array('latin') ),
      'Great Vibes' => array( array('normal'), array('latin-ext','latin') ),
      'Grenze' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','vietnamese') ),
      'Griffy' => array( array('normal'), array('latin-ext','latin') ),
      'Gruppo' => array( array('normal'), array('latin-ext','latin') ),
      'Gudea' => array( array('normal','italic','700'), array('latin-ext','latin') ),
      'Gugi' => array( array('normal'), array('korean','latin') ),
      'Gurajada' => array( array('normal'), array('telugu','latin') ),
      'Habibi' => array( array('normal'), array('latin-ext','latin') ),
      'Halant' => array( array('300','normal','500','600','700'), array('latin-ext','latin','devanagari') ),
      'Hammersmith One' => array( array('normal'), array('latin-ext','latin') ),
      'Hanalei' => array( array('normal'), array('latin-ext','latin') ),
      'Hanalei Fill' => array( array('normal'), array('latin-ext','latin') ),
      'Handlee' => array( array('normal'), array('latin') ),
      'Hanuman' => array( array('normal','700'), array('khmer') ),
      'Happy Monkey' => array( array('normal'), array('latin-ext','latin') ),
      'Harmattan' => array( array('normal'), array('arabic','latin') ),
      'Headland One' => array( array('normal'), array('latin-ext','latin') ),
      'Heebo' => array( array('100','300','normal','500','700','800','900'), array('hebrew','latin') ),
      'Henny Penny' => array( array('normal'), array('latin') ),
      'Hepta Slab' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'Herr Von Muellerhoff' => array( array('normal'), array('latin-ext','latin') ),
      'Hi Melody' => array( array('normal'), array('korean','latin') ),
      'Hind' => array( array('300','normal','500','600','700'), array('latin-ext','latin','devanagari') ),
      'Hind Guntur' => array( array('300','normal','500','600','700'), array('latin-ext','telugu','latin') ),
      'Hind Madurai' => array( array('300','normal','500','600','700'), array('latin-ext','tamil','latin') ),
      'Hind Siliguri' => array( array('300','normal','500','600','700'), array('bengali','latin-ext','latin') ),
      'Hind Vadodara' => array( array('300','normal','500','600','700'), array('latin-ext','gujarati','latin') ),
      'Holtwood One SC' => array( array('normal'), array('latin') ),
      'Homemade Apple' => array( array('normal'), array('latin') ),
      'Homenaje' => array( array('normal'), array('latin') ),
      'IBM Plex Mono' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'IBM Plex Sans' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','vietnamese') ),
      'IBM Plex Sans Condensed' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','vietnamese') ),
      'IBM Plex Serif' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'IM Fell DW Pica' => array( array('normal','italic'), array('latin') ),
      'IM Fell DW Pica SC' => array( array('normal'), array('latin') ),
      'IM Fell Double Pica' => array( array('normal','italic'), array('latin') ),
      'IM Fell Double Pica SC' => array( array('normal'), array('latin') ),
      'IM Fell English' => array( array('normal','italic'), array('latin') ),
      'IM Fell English SC' => array( array('normal'), array('latin') ),
      'IM Fell French Canon' => array( array('normal','italic'), array('latin') ),
      'IM Fell French Canon SC' => array( array('normal'), array('latin') ),
      'IM Fell Great Primer' => array( array('normal','italic'), array('latin') ),
      'IM Fell Great Primer SC' => array( array('normal'), array('latin') ),
      'Iceberg' => array( array('normal'), array('latin') ),
      'Iceland' => array( array('normal'), array('latin') ),
      'Imprima' => array( array('normal'), array('latin-ext','latin') ),
      'Inconsolata' => array( array('normal','700'), array('latin-ext','latin','vietnamese') ),
      'Inder' => array( array('normal'), array('latin-ext','latin') ),
      'Indie Flower' => array( array('normal'), array('latin') ),
      'Inika' => array( array('normal','700'), array('latin-ext','latin') ),
      'Inknut Antiqua' => array( array('300','normal','500','600','700','800','900'), array('latin-ext','latin','devanagari') ),
      'Irish Grover' => array( array('normal'), array('latin') ),
      'Istok Web' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin') ),
      'Italiana' => array( array('normal'), array('latin') ),
      'Italianno' => array( array('normal'), array('latin-ext','latin') ),
      'Itim' => array( array('normal'), array('latin-ext','latin','thai','vietnamese') ),
      'Jacques Francois' => array( array('normal'), array('latin') ),
      'Jacques Francois Shadow' => array( array('normal'), array('latin') ),
      'Jaldi' => array( array('normal','700'), array('latin-ext','latin','devanagari') ),
      'Jim Nightshade' => array( array('normal'), array('latin-ext','latin') ),
      'Jockey One' => array( array('normal'), array('latin-ext','latin') ),
      'Jolly Lodger' => array( array('normal'), array('latin-ext','latin') ),
      'Jomhuria' => array( array('normal'), array('latin-ext','arabic','latin') ),
      'Josefin Sans' => array( array('100','100italic','300','300italic','normal','italic','600','600italic','700','700italic'), array('latin-ext','latin','vietnamese') ),
      'Josefin Slab' => array( array('100','100italic','300','300italic','normal','italic','600','600italic','700','700italic'), array('latin') ),
      'Joti One' => array( array('normal'), array('latin-ext','latin') ),
      'Jua' => array( array('normal'), array('korean','latin') ),
      'Judson' => array( array('normal','italic','700'), array('latin-ext','latin','vietnamese') ),
      'Julee' => array( array('normal'), array('latin') ),
      'Julius Sans One' => array( array('normal'), array('latin-ext','latin') ),
      'Junge' => array( array('normal'), array('latin') ),
      'Jura' => array( array('300','normal','500','600','700'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Just Another Hand' => array( array('normal'), array('latin') ),
      'Just Me Again Down Here' => array( array('normal'), array('latin-ext','latin') ),
      'K2D' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Kadwa' => array( array('normal','700'), array('latin','devanagari') ),
      'Kalam' => array( array('300','normal','700'), array('latin-ext','latin','devanagari') ),
      'Kameron' => array( array('normal','700'), array('latin') ),
      'Kanit' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Kantumruy' => array( array('300','normal','700'), array('khmer') ),
      'Karla' => array( array('normal','italic','700','700italic'), array('latin-ext','latin') ),
      'Karma' => array( array('300','normal','500','600','700'), array('latin-ext','latin','devanagari') ),
      'Katibeh' => array( array('normal'), array('latin-ext','arabic','latin') ),
      'Kaushan Script' => array( array('normal'), array('latin-ext','latin') ),
      'Kavivanar' => array( array('normal'), array('latin-ext','tamil','latin') ),
      'Kavoon' => array( array('normal'), array('latin-ext','latin') ),
      'Kdam Thmor' => array( array('normal'), array('khmer') ),
      'Keania One' => array( array('normal'), array('latin-ext','latin') ),
      'Kelly Slab' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Kenia' => array( array('normal'), array('latin') ),
      'Khand' => array( array('300','normal','500','600','700'), array('latin-ext','latin','devanagari') ),
      'Khmer' => array( array('normal'), array('khmer') ),
      'Khula' => array( array('300','normal','600','700','800'), array('latin-ext','latin','devanagari') ),
      'Kirang Haerang' => array( array('normal'), array('korean','latin') ),
      'Kite One' => array( array('normal'), array('latin') ),
      'Knewave' => array( array('normal'), array('latin-ext','latin') ),
      'KoHo' => array( array('200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Kodchasan' => array( array('200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Kosugi' => array( array('normal'), array('cyrillic','latin','japanese') ),
      'Kosugi Maru' => array( array('normal'), array('cyrillic','latin','japanese') ),
      'Kotta One' => array( array('normal'), array('latin-ext','latin') ),
      'Koulen' => array( array('normal'), array('khmer') ),
      'Kranky' => array( array('normal'), array('latin') ),
      'Kreon' => array( array('300','normal','500','600','700'), array('latin-ext','latin') ),
      'Kristi' => array( array('normal'), array('latin') ),
      'Krona One' => array( array('normal'), array('latin-ext','latin') ),
      'Krub' => array( array('200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Kumar One' => array( array('normal'), array('latin-ext','gujarati','latin') ),
      'Kumar One Outline' => array( array('normal'), array('latin-ext','gujarati','latin') ),
      'Kurale' => array( array('normal'), array('latin-ext','cyrillic','cyrillic-ext','latin','devanagari') ),
      'La Belle Aurore' => array( array('normal'), array('latin') ),
      'Lacquer' => array( array('normal'), array('latin') ),
      'Laila' => array( array('300','normal','500','600','700'), array('latin-ext','latin','devanagari') ),
      'Lakki Reddy' => array( array('normal'), array('telugu','latin') ),
      'Lalezar' => array( array('normal'), array('latin-ext','arabic','latin','vietnamese') ),
      'Lancelot' => array( array('normal'), array('latin-ext','latin') ),
      'Lateef' => array( array('normal'), array('arabic','latin') ),
      'Lato' => array( array('100','100italic','300','300italic','normal','italic','700','700italic','900','900italic'), array('latin-ext','latin') ),
      'League Script' => array( array('normal'), array('latin') ),
      'Leckerli One' => array( array('normal'), array('latin') ),
      'Ledger' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Lekton' => array( array('normal','italic','700'), array('latin-ext','latin') ),
      'Lemon' => array( array('normal'), array('latin') ),
      'Lemonada' => array( array('300','normal','600','700'), array('latin-ext','arabic','latin','vietnamese') ),
      'Lexend Deca' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Lexend Exa' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Lexend Giga' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Lexend Mega' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Lexend Peta' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Lexend Tera' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Lexend Zetta' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Libre Barcode 128' => array( array('normal'), array('latin') ),
      'Libre Barcode 128 Text' => array( array('normal'), array('latin') ),
      'Libre Barcode 39' => array( array('normal'), array('latin') ),
      'Libre Barcode 39 Extended' => array( array('normal'), array('latin') ),
      'Libre Barcode 39 Extended Text' => array( array('normal'), array('latin') ),
      'Libre Barcode 39 Text' => array( array('normal'), array('latin') ),
      'Libre Baskerville' => array( array('normal','italic','700'), array('latin-ext','latin') ),
      'Libre Caslon Display' => array( array('normal'), array('latin-ext','latin') ),
      'Libre Caslon Text' => array( array('normal','italic','700'), array('latin-ext','latin') ),
      'Libre Franklin' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin') ),
      'Life Savers' => array( array('normal','700','800'), array('latin-ext','latin') ),
      'Lilita One' => array( array('normal'), array('latin-ext','latin') ),
      'Lily Script One' => array( array('normal'), array('latin-ext','latin') ),
      'Limelight' => array( array('normal'), array('latin-ext','latin') ),
      'Linden Hill' => array( array('normal','italic'), array('latin') ),
      'Literata' => array( array('normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','cyrillic','greek','latin','greek-ext','vietnamese') ),
      'Liu Jian Mao Cao' => array( array('normal'), array('chinese-simplified','latin') ),
      'Livvic' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','900','900italic'), array('latin-ext','latin','vietnamese') ),
      'Lobster' => array( array('normal'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Lobster Two' => array( array('normal','italic','700','700italic'), array('latin') ),
      'Londrina Outline' => array( array('normal'), array('latin') ),
      'Londrina Shadow' => array( array('normal'), array('latin') ),
      'Londrina Sketch' => array( array('normal'), array('latin') ),
      'Londrina Solid' => array( array('100','300','normal','900'), array('latin') ),
      'Long Cang' => array( array('normal'), array('chinese-simplified','latin') ),
      'Lora' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Love Ya Like A Sister' => array( array('normal'), array('latin') ),
      'Loved by the King' => array( array('normal'), array('latin') ),
      'Lovers Quarrel' => array( array('normal'), array('latin-ext','latin') ),
      'Luckiest Guy' => array( array('normal'), array('latin') ),
      'Lusitana' => array( array('normal','700'), array('latin') ),
      'Lustria' => array( array('normal'), array('latin') ),
      'M PLUS 1p' => array( array('100','300','normal','500','700','800','900'), array('latin-ext','cyrillic','greek','cyrillic-ext','hebrew','latin','greek-ext','japanese','vietnamese') ),
      'M PLUS Rounded 1c' => array( array('100','300','normal','500','700','800','900'), array('latin-ext','cyrillic','greek','cyrillic-ext','hebrew','latin','greek-ext','japanese','vietnamese') ),
      'Ma Shan Zheng' => array( array('normal'), array('chinese-simplified','latin') ),
      'Macondo' => array( array('normal'), array('latin') ),
      'Macondo Swash Caps' => array( array('normal'), array('latin') ),
      'Mada' => array( array('200','300','normal','500','600','700','900'), array('arabic','latin') ),
      'Magra' => array( array('normal','700'), array('latin-ext','latin') ),
      'Maiden Orange' => array( array('normal'), array('latin') ),
      'Maitree' => array( array('200','300','normal','500','600','700'), array('latin-ext','latin','thai','vietnamese') ),
      'Major Mono Display' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Mako' => array( array('normal'), array('latin') ),
      'Mali' => array( array('200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Mallanna' => array( array('normal'), array('telugu','latin') ),
      'Mandali' => array( array('normal'), array('telugu','latin') ),
      'Manuale' => array( array('normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','vietnamese') ),
      'Marcellus' => array( array('normal'), array('latin-ext','latin') ),
      'Marcellus SC' => array( array('normal'), array('latin-ext','latin') ),
      'Marck Script' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Margarine' => array( array('normal'), array('latin-ext','latin') ),
      'Markazi Text' => array( array('normal','500','600','700'), array('latin-ext','arabic','latin','vietnamese') ),
      'Marko One' => array( array('normal'), array('latin') ),
      'Marmelad' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Martel' => array( array('200','300','normal','600','700','800','900'), array('latin-ext','latin','devanagari') ),
      'Martel Sans' => array( array('200','300','normal','600','700','800','900'), array('latin-ext','latin','devanagari') ),
      'Marvel' => array( array('normal','italic','700','700italic'), array('latin') ),
      'Mate' => array( array('normal','italic'), array('latin') ),
      'Mate SC' => array( array('normal'), array('latin') ),
      'Maven Pro' => array( array('normal','500','700','900'), array('latin-ext','latin','vietnamese') ),
      'McLaren' => array( array('normal'), array('latin-ext','latin') ),
      'Meddon' => array( array('normal'), array('latin') ),
      'MedievalSharp' => array( array('normal'), array('latin-ext','latin') ),
      'Medula One' => array( array('normal'), array('latin') ),
      'Meera Inimai' => array( array('normal'), array('tamil','latin') ),
      'Megrim' => array( array('normal'), array('latin') ),
      'Meie Script' => array( array('normal'), array('latin-ext','latin') ),
      'Merienda' => array( array('normal','700'), array('latin-ext','latin') ),
      'Merienda One' => array( array('normal'), array('latin') ),
      'Merriweather' => array( array('300','300italic','normal','italic','700','700italic','900','900italic'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Merriweather Sans' => array( array('300','300italic','normal','italic','700','700italic','800','800italic'), array('latin-ext','latin') ),
      'Metal' => array( array('normal'), array('khmer') ),
      'Metal Mania' => array( array('normal'), array('latin-ext','latin') ),
      'Metamorphous' => array( array('normal'), array('latin-ext','latin') ),
      'Metrophobic' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Michroma' => array( array('normal'), array('latin') ),
      'Milonga' => array( array('normal'), array('latin-ext','latin') ),
      'Miltonian' => array( array('normal'), array('latin') ),
      'Miltonian Tattoo' => array( array('normal'), array('latin') ),
      'Mina' => array( array('normal','700'), array('bengali','latin-ext','latin') ),
      'Miniver' => array( array('normal'), array('latin') ),
      'Miriam Libre' => array( array('normal','700'), array('latin-ext','hebrew','latin') ),
      'Mirza' => array( array('normal','500','600','700'), array('latin-ext','arabic','latin') ),
      'Miss Fajardose' => array( array('normal'), array('latin-ext','latin') ),
      'Mitr' => array( array('200','300','normal','500','600','700'), array('latin-ext','latin','thai','vietnamese') ),
      'Modak' => array( array('normal'), array('latin-ext','latin','devanagari') ),
      'Modern Antiqua' => array( array('normal'), array('latin-ext','latin') ),
      'Mogra' => array( array('normal'), array('latin-ext','gujarati','latin') ),
      'Molengo' => array( array('normal'), array('latin-ext','latin') ),
      'Molle' => array( array('italic'), array('latin-ext','latin') ),
      'Monda' => array( array('normal','700'), array('latin-ext','latin') ),
      'Monofett' => array( array('normal'), array('latin') ),
      'Monoton' => array( array('normal'), array('latin') ),
      'Monsieur La Doulaise' => array( array('normal'), array('latin-ext','latin') ),
      'Montaga' => array( array('normal'), array('latin') ),
      'Montez' => array( array('normal'), array('latin') ),
      'Montserrat' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Montserrat Alternates' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Montserrat Subrayada' => array( array('normal','700'), array('latin') ),
      'Moul' => array( array('normal'), array('khmer') ),
      'Moulpali' => array( array('normal'), array('khmer') ),
      'Mountains of Christmas' => array( array('normal','700'), array('latin') ),
      'Mouse Memoirs' => array( array('normal'), array('latin-ext','latin') ),
      'Mr Bedfort' => array( array('normal'), array('latin-ext','latin') ),
      'Mr Dafoe' => array( array('normal'), array('latin-ext','latin') ),
      'Mr De Haviland' => array( array('normal'), array('latin-ext','latin') ),
      'Mrs Saint Delafield' => array( array('normal'), array('latin-ext','latin') ),
      'Mrs Sheppards' => array( array('normal'), array('latin-ext','latin') ),
      'Mukta' => array( array('200','300','normal','500','600','700','800'), array('latin-ext','latin','devanagari') ),
      'Mukta Mahee' => array( array('200','300','normal','500','600','700','800'), array('latin-ext','gurmukhi','latin') ),
      'Mukta Malar' => array( array('200','300','normal','500','600','700','800'), array('latin-ext','tamil','latin') ),
      'Mukta Vaani' => array( array('200','300','normal','500','600','700','800'), array('latin-ext','gujarati','latin') ),
      'Muli' => array( array('200','200italic','300','300italic','normal','italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','vietnamese') ),
      'Mystery Quest' => array( array('normal'), array('latin-ext','latin') ),
      'NTR' => array( array('normal'), array('telugu','latin') ),
      'Nanum Brush Script' => array( array('normal'), array('korean','latin') ),
      'Nanum Gothic' => array( array('normal','700','800'), array('korean','latin') ),
      'Nanum Gothic Coding' => array( array('normal','700'), array('korean','latin') ),
      'Nanum Myeongjo' => array( array('normal','700','800'), array('korean','latin') ),
      'Nanum Pen Script' => array( array('normal'), array('korean','latin') ),
      'Neucha' => array( array('normal'), array('cyrillic','latin') ),
      'Neuton' => array( array('200','300','normal','italic','700','800'), array('latin-ext','latin') ),
      'New Rocker' => array( array('normal'), array('latin-ext','latin') ),
      'News Cycle' => array( array('normal','700'), array('latin-ext','latin') ),
      'Niconne' => array( array('normal'), array('latin-ext','latin') ),
      'Niramit' => array( array('200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Nixie One' => array( array('normal'), array('latin') ),
      'Nobile' => array( array('normal','italic','500','500italic','700','700italic'), array('latin-ext','latin') ),
      'Nokora' => array( array('normal','700'), array('khmer') ),
      'Norican' => array( array('normal'), array('latin-ext','latin') ),
      'Nosifer' => array( array('normal'), array('latin-ext','latin') ),
      'Notable' => array( array('normal'), array('latin') ),
      'Nothing You Could Do' => array( array('normal'), array('latin') ),
      'Noticia Text' => array( array('normal','italic','700','700italic'), array('latin-ext','latin','vietnamese') ),
      'Noto Sans' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','devanagari','vietnamese') ),
      'Noto Sans HK' => array( array('100','300','normal','500','700','900'), array('chinese-hongkong','latin') ),
      'Noto Sans JP' => array( array('100','300','normal','500','700','900'), array('latin','japanese') ),
      'Noto Sans KR' => array( array('100','300','normal','500','700','900'), array('korean','latin') ),
      'Noto Sans SC' => array( array('100','300','normal','500','700','900'), array('cyrillic','chinese-simplified','latin','vietnamese') ),
      'Noto Sans TC' => array( array('100','300','normal','500','700','900'), array('chinese-traditional','latin') ),
      'Noto Serif' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Noto Serif JP' => array( array('200','300','normal','500','600','700','900'), array('latin','japanese') ),
      'Noto Serif KR' => array( array('200','300','normal','500','600','700','900'), array('korean','latin') ),
      'Noto Serif SC' => array( array('200','300','normal','500','600','700','900'), array('cyrillic','chinese-simplified','latin','vietnamese') ),
      'Noto Serif TC' => array( array('200','300','normal','500','600','700','900'), array('cyrillic','chinese-traditional','latin','vietnamese') ),
      'Nova Cut' => array( array('normal'), array('latin') ),
      'Nova Flat' => array( array('normal'), array('latin') ),
      'Nova Mono' => array( array('normal'), array('greek','latin') ),
      'Nova Oval' => array( array('normal'), array('latin') ),
      'Nova Round' => array( array('normal'), array('latin') ),
      'Nova Script' => array( array('normal'), array('latin') ),
      'Nova Slim' => array( array('normal'), array('latin') ),
      'Nova Square' => array( array('normal'), array('latin') ),
      'Numans' => array( array('normal'), array('latin') ),
      'Nunito' => array( array('200','200italic','300','300italic','normal','italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','vietnamese') ),
      'Nunito Sans' => array( array('200','200italic','300','300italic','normal','italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','vietnamese') ),
      'Odor Mean Chey' => array( array('normal'), array('khmer') ),
      'Offside' => array( array('normal'), array('latin') ),
      'Old Standard TT' => array( array('normal','italic','700'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Oldenburg' => array( array('normal'), array('latin-ext','latin') ),
      'Oleo Script' => array( array('normal','700'), array('latin-ext','latin') ),
      'Oleo Script Swash Caps' => array( array('normal','700'), array('latin-ext','latin') ),
      'Open Sans' => array( array('300','300italic','normal','italic','600','600italic','700','700italic','800','800italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Open Sans Condensed' => array( array('300','300italic','700'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Oranienbaum' => array( array('normal'), array('latin-ext','cyrillic','cyrillic-ext','latin') ),
      'Orbitron' => array( array('normal','500','700','900'), array('latin') ),
      'Oregano' => array( array('normal','italic'), array('latin-ext','latin') ),
      'Orienta' => array( array('normal'), array('latin-ext','latin') ),
      'Original Surfer' => array( array('normal'), array('latin') ),
      'Oswald' => array( array('200','300','normal','500','600','700'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Over the Rainbow' => array( array('normal'), array('latin') ),
      'Overlock' => array( array('normal','italic','700','700italic','900','900italic'), array('latin-ext','latin') ),
      'Overlock SC' => array( array('normal'), array('latin-ext','latin') ),
      'Overpass' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin') ),
      'Overpass Mono' => array( array('300','normal','600','700'), array('latin-ext','latin') ),
      'Ovo' => array( array('normal'), array('latin') ),
      'Oxygen' => array( array('300','normal','700'), array('latin-ext','latin') ),
      'Oxygen Mono' => array( array('normal'), array('latin-ext','latin') ),
      'PT Mono' => array( array('normal'), array('latin-ext','cyrillic','cyrillic-ext','latin') ),
      'PT Sans' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin') ),
      'PT Sans Caption' => array( array('normal','700'), array('latin-ext','cyrillic','cyrillic-ext','latin') ),
      'PT Sans Narrow' => array( array('normal','700'), array('latin-ext','cyrillic','cyrillic-ext','latin') ),
      'PT Serif' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin') ),
      'PT Serif Caption' => array( array('normal','italic'), array('latin-ext','cyrillic','cyrillic-ext','latin') ),
      'Pacifico' => array( array('normal'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Padauk' => array( array('normal','700'), array('myanmar','latin') ),
      'Palanquin' => array( array('100','200','300','normal','500','600','700'), array('latin-ext','latin','devanagari') ),
      'Palanquin Dark' => array( array('normal','500','600','700'), array('latin-ext','latin','devanagari') ),
      'Pangolin' => array( array('normal'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Paprika' => array( array('normal'), array('latin') ),
      'Parisienne' => array( array('normal'), array('latin-ext','latin') ),
      'Passero One' => array( array('normal'), array('latin-ext','latin') ),
      'Passion One' => array( array('normal','700','900'), array('latin-ext','latin') ),
      'Pathway Gothic One' => array( array('normal'), array('latin-ext','latin') ),
      'Patrick Hand' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Patrick Hand SC' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Pattaya' => array( array('normal'), array('latin-ext','cyrillic','latin','thai','vietnamese') ),
      'Patua One' => array( array('normal'), array('latin') ),
      'Pavanam' => array( array('normal'), array('latin-ext','tamil','latin') ),
      'Paytone One' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Peddana' => array( array('normal'), array('telugu','latin') ),
      'Peralta' => array( array('normal'), array('latin-ext','latin') ),
      'Permanent Marker' => array( array('normal'), array('latin') ),
      'Petit Formal Script' => array( array('normal'), array('latin-ext','latin') ),
      'Petrona' => array( array('normal'), array('latin') ),
      'Philosopher' => array( array('normal','italic','700','700italic'), array('cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Piedra' => array( array('normal'), array('latin-ext','latin') ),
      'Pinyon Script' => array( array('normal'), array('latin') ),
      'Pirata One' => array( array('normal'), array('latin-ext','latin') ),
      'Plaster' => array( array('normal'), array('latin-ext','latin') ),
      'Play' => array( array('normal','700'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','vietnamese') ),
      'Playball' => array( array('normal'), array('latin-ext','latin') ),
      'Playfair Display' => array( array('normal','italic','700','700italic','900','900italic'), array('latin-ext','cyrillic','latin','vietnamese') ),
      'Playfair Display SC' => array( array('normal','italic','700','700italic','900','900italic'), array('latin-ext','cyrillic','latin','vietnamese') ),
      'Podkova' => array( array('normal','500','600','700','800'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Poiret One' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Poller One' => array( array('normal'), array('latin') ),
      'Poly' => array( array('normal','italic'), array('latin') ),
      'Pompiere' => array( array('normal'), array('latin') ),
      'Pontano Sans' => array( array('normal'), array('latin-ext','latin') ),
      'Poor Story' => array( array('normal'), array('korean','latin') ),
      'Poppins' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','devanagari') ),
      'Port Lligat Sans' => array( array('normal'), array('latin') ),
      'Port Lligat Slab' => array( array('normal'), array('latin') ),
      'Pragati Narrow' => array( array('normal','700'), array('latin-ext','latin','devanagari') ),
      'Prata' => array( array('normal'), array('cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Preahvihear' => array( array('normal'), array('khmer') ),
      'Press Start 2P' => array( array('normal'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin') ),
      'Pridi' => array( array('200','300','normal','500','600','700'), array('latin-ext','latin','thai','vietnamese') ),
      'Princess Sofia' => array( array('normal'), array('latin-ext','latin') ),
      'Prociono' => array( array('normal'), array('latin') ),
      'Prompt' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Prosto One' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Proza Libre' => array( array('normal','italic','500','500italic','600','600italic','700','700italic','800','800italic'), array('latin-ext','latin') ),
      'Puritan' => array( array('normal','italic','700','700italic'), array('latin') ),
      'Purple Purse' => array( array('normal'), array('latin-ext','latin') ),
      'Quando' => array( array('normal'), array('latin-ext','latin') ),
      'Quantico' => array( array('normal','italic','700','700italic'), array('latin') ),
      'Quattrocento' => array( array('normal','700'), array('latin-ext','latin') ),
      'Quattrocento Sans' => array( array('normal','italic','700','700italic'), array('latin-ext','latin') ),
      'Questrial' => array( array('normal'), array('latin') ),
      'Quicksand' => array( array('300','normal','500','600','700'), array('latin-ext','latin','vietnamese') ),
      'Quintessential' => array( array('normal'), array('latin-ext','latin') ),
      'Qwigley' => array( array('normal'), array('latin-ext','latin') ),
      'Racing Sans One' => array( array('normal'), array('latin-ext','latin') ),
      'Radley' => array( array('normal','italic'), array('latin-ext','latin') ),
      'Rajdhani' => array( array('300','normal','500','600','700'), array('latin-ext','latin','devanagari') ),
      'Rakkas' => array( array('normal'), array('latin-ext','arabic','latin') ),
      'Raleway' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin') ),
      'Raleway Dots' => array( array('normal'), array('latin-ext','latin') ),
      'Ramabhadra' => array( array('normal'), array('telugu','latin') ),
      'Ramaraja' => array( array('normal'), array('telugu','latin') ),
      'Rambla' => array( array('normal','italic','700','700italic'), array('latin-ext','latin') ),
      'Rammetto One' => array( array('normal'), array('latin-ext','latin') ),
      'Ranchers' => array( array('normal'), array('latin-ext','latin') ),
      'Rancho' => array( array('normal'), array('latin') ),
      'Ranga' => array( array('normal','700'), array('latin-ext','latin','devanagari') ),
      'Rasa' => array( array('300','normal','500','600','700'), array('latin-ext','gujarati','latin') ),
      'Rationale' => array( array('normal'), array('latin') ),
      'Ravi Prakash' => array( array('normal'), array('telugu','latin') ),
      'Red Hat Display' => array( array('normal','italic','500','500italic','700','700italic','900','900italic'), array('latin-ext','latin') ),
      'Red Hat Text' => array( array('normal','italic','500','500italic','700','700italic'), array('latin-ext','latin') ),
      'Redressed' => array( array('normal'), array('latin') ),
      'Reem Kufi' => array( array('normal'), array('arabic','latin') ),
      'Reenie Beanie' => array( array('normal'), array('latin') ),
      'Revalia' => array( array('normal'), array('latin-ext','latin') ),
      'Rhodium Libre' => array( array('normal'), array('latin-ext','latin','devanagari') ),
      'Ribeye' => array( array('normal'), array('latin-ext','latin') ),
      'Ribeye Marrow' => array( array('normal'), array('latin-ext','latin') ),
      'Righteous' => array( array('normal'), array('latin-ext','latin') ),
      'Risque' => array( array('normal'), array('latin-ext','latin') ),
      'Roboto' => array( array('100','100italic','300','300italic','normal','italic','500','500italic','700','700italic','900','900italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Roboto Condensed' => array( array('300','300italic','normal','italic','700','700italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Roboto Mono' => array( array('100','100italic','300','300italic','normal','italic','500','500italic','700','700italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Roboto Slab' => array( array('100','300','normal','700'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Rochester' => array( array('normal'), array('latin') ),
      'Rock Salt' => array( array('normal'), array('latin') ),
      'Rokkitt' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'Romanesco' => array( array('normal'), array('latin-ext','latin') ),
      'Ropa Sans' => array( array('normal','italic'), array('latin-ext','latin') ),
      'Rosario' => array( array('normal','italic','700','700italic'), array('latin') ),
      'Rosarivo' => array( array('normal','italic'), array('latin-ext','latin') ),
      'Rouge Script' => array( array('normal'), array('latin') ),
      'Rozha One' => array( array('normal'), array('latin-ext','latin','devanagari') ),
      'Rubik' => array( array('300','300italic','normal','italic','500','500italic','700','700italic','900','900italic'), array('latin-ext','cyrillic','hebrew','latin') ),
      'Rubik Mono One' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Ruda' => array( array('normal','700','900'), array('latin-ext','latin') ),
      'Rufina' => array( array('normal','700'), array('latin-ext','latin') ),
      'Ruge Boogie' => array( array('normal'), array('latin-ext','latin') ),
      'Ruluko' => array( array('normal'), array('latin-ext','latin') ),
      'Rum Raisin' => array( array('normal'), array('latin-ext','latin') ),
      'Ruslan Display' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Russo One' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Ruthie' => array( array('normal'), array('latin-ext','latin') ),
      'Rye' => array( array('normal'), array('latin-ext','latin') ),
      'Sacramento' => array( array('normal'), array('latin-ext','latin') ),
      'Sahitya' => array( array('normal','700'), array('latin','devanagari') ),
      'Sail' => array( array('normal'), array('latin-ext','latin') ),
      'Saira' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'Saira Condensed' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'Saira Extra Condensed' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'Saira Semi Condensed' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin','vietnamese') ),
      'Saira Stencil One' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Salsa' => array( array('normal'), array('latin') ),
      'Sanchez' => array( array('normal','italic'), array('latin-ext','latin') ),
      'Sancreek' => array( array('normal'), array('latin-ext','latin') ),
      'Sansita' => array( array('normal','italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin') ),
      'Sarabun' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Sarala' => array( array('normal','700'), array('latin-ext','latin','devanagari') ),
      'Sarina' => array( array('normal'), array('latin-ext','latin') ),
      'Sarpanch' => array( array('normal','500','600','700','800','900'), array('latin-ext','latin','devanagari') ),
      'Satisfy' => array( array('normal'), array('latin') ),
      'Sawarabi Gothic' => array( array('normal'), array('latin-ext','cyrillic','latin','japanese','vietnamese') ),
      'Sawarabi Mincho' => array( array('normal'), array('latin-ext','latin','japanese') ),
      'Scada' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','cyrillic-ext','latin') ),
      'Scheherazade' => array( array('normal','700'), array('arabic','latin') ),
      'Schoolbell' => array( array('normal'), array('latin') ),
      'Scope One' => array( array('normal'), array('latin-ext','latin') ),
      'Seaweed Script' => array( array('normal'), array('latin-ext','latin') ),
      'Secular One' => array( array('normal'), array('latin-ext','hebrew','latin') ),
      'Sedgwick Ave' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Sedgwick Ave Display' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Sevillana' => array( array('normal'), array('latin-ext','latin') ),
      'Seymour One' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Shadows Into Light' => array( array('normal'), array('latin') ),
      'Shadows Into Light Two' => array( array('normal'), array('latin-ext','latin') ),
      'Shanti' => array( array('normal'), array('latin') ),
      'Share' => array( array('normal','italic','700','700italic'), array('latin-ext','latin') ),
      'Share Tech' => array( array('normal'), array('latin') ),
      'Share Tech Mono' => array( array('normal'), array('latin') ),
      'Shojumaru' => array( array('normal'), array('latin-ext','latin') ),
      'Short Stack' => array( array('normal'), array('latin') ),
      'Shrikhand' => array( array('normal'), array('latin-ext','gujarati','latin') ),
      'Siemreap' => array( array('normal'), array('khmer') ),
      'Sigmar One' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Signika' => array( array('300','normal','600','700'), array('latin-ext','latin') ),
      'Signika Negative' => array( array('300','normal','600','700'), array('latin-ext','latin') ),
      'Simonetta' => array( array('normal','italic','900','900italic'), array('latin-ext','latin') ),
      'Single Day' => array( array('normal'), array('korean') ),
      'Sintony' => array( array('normal','700'), array('latin-ext','latin') ),
      'Sirin Stencil' => array( array('normal'), array('latin') ),
      'Six Caps' => array( array('normal'), array('latin') ),
      'Skranji' => array( array('normal','700'), array('latin-ext','latin') ),
      'Slabo 13px' => array( array('normal'), array('latin-ext','latin') ),
      'Slabo 27px' => array( array('normal'), array('latin-ext','latin') ),
      'Slackey' => array( array('normal'), array('latin') ),
      'Smokum' => array( array('normal'), array('latin') ),
      'Smythe' => array( array('normal'), array('latin') ),
      'Sniglet' => array( array('normal','800'), array('latin-ext','latin') ),
      'Snippet' => array( array('normal'), array('latin') ),
      'Snowburst One' => array( array('normal'), array('latin-ext','latin') ),
      'Sofadi One' => array( array('normal'), array('latin') ),
      'Sofia' => array( array('normal'), array('latin') ),
      'Song Myung' => array( array('normal'), array('korean','latin') ),
      'Sonsie One' => array( array('normal'), array('latin-ext','latin') ),
      'Sorts Mill Goudy' => array( array('normal','italic'), array('latin-ext','latin') ),
      'Source Code Pro' => array( array('200','300','normal','500','600','700','900'), array('latin-ext','latin') ),
      'Source Sans Pro' => array( array('200','200italic','300','300italic','normal','italic','600','600italic','700','700italic','900','900italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext','vietnamese') ),
      'Source Serif Pro' => array( array('normal','600','700'), array('latin-ext','latin') ),
      'Space Mono' => array( array('normal','italic','700','700italic'), array('latin-ext','latin','vietnamese') ),
      'Special Elite' => array( array('normal'), array('latin') ),
      'Spectral' => array( array('200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic'), array('latin-ext','cyrillic','latin','vietnamese') ),
      'Spectral SC' => array( array('200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic'), array('latin-ext','cyrillic','latin','vietnamese') ),
      'Spicy Rice' => array( array('normal'), array('latin') ),
      'Spinnaker' => array( array('normal'), array('latin-ext','latin') ),
      'Spirax' => array( array('normal'), array('latin') ),
      'Squada One' => array( array('normal'), array('latin') ),
      'Sree Krushnadevaraya' => array( array('normal'), array('telugu','latin') ),
      'Sriracha' => array( array('normal'), array('latin-ext','latin','thai','vietnamese') ),
      'Srisakdi' => array( array('normal','700'), array('latin-ext','latin','thai','vietnamese') ),
      'Staatliches' => array( array('normal'), array('latin-ext','latin') ),
      'Stalemate' => array( array('normal'), array('latin-ext','latin') ),
      'Stalinist One' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Stardos Stencil' => array( array('normal','700'), array('latin') ),
      'Stint Ultra Condensed' => array( array('normal'), array('latin-ext','latin') ),
      'Stint Ultra Expanded' => array( array('normal'), array('latin-ext','latin') ),
      'Stoke' => array( array('300','normal'), array('latin-ext','latin') ),
      'Strait' => array( array('normal'), array('latin') ),
      'Stylish' => array( array('normal'), array('korean','latin') ),
      'Sue Ellen Francisco' => array( array('normal'), array('latin') ),
      'Suez One' => array( array('normal'), array('latin-ext','hebrew','latin') ),
      'Sumana' => array( array('normal','700'), array('latin-ext','latin','devanagari') ),
      'Sunflower' => array( array('300','500','700'), array('korean','latin') ),
      'Sunshiney' => array( array('normal'), array('latin') ),
      'Supermercado One' => array( array('normal'), array('latin') ),
      'Sura' => array( array('normal','700'), array('latin-ext','latin','devanagari') ),
      'Suranna' => array( array('normal'), array('telugu','latin') ),
      'Suravaram' => array( array('normal'), array('telugu','latin') ),
      'Suwannaphum' => array( array('normal'), array('khmer') ),
      'Swanky and Moo Moo' => array( array('normal'), array('latin') ),
      'Syncopate' => array( array('normal','700'), array('latin') ),
      'Tajawal' => array( array('200','300','normal','500','700','800','900'), array('arabic','latin') ),
      'Tangerine' => array( array('normal','700'), array('latin') ),
      'Taprom' => array( array('normal'), array('khmer') ),
      'Tauri' => array( array('normal'), array('latin-ext','latin') ),
      'Taviraj' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Teko' => array( array('300','normal','500','600','700'), array('latin-ext','latin','devanagari') ),
      'Telex' => array( array('normal'), array('latin-ext','latin') ),
      'Tenali Ramakrishna' => array( array('normal'), array('telugu','latin') ),
      'Tenor Sans' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Text Me One' => array( array('normal'), array('latin-ext','latin') ),
      'Thasadith' => array( array('normal','italic','700','700italic'), array('latin-ext','latin','thai','vietnamese') ),
      'The Girl Next Door' => array( array('normal'), array('latin') ),
      'Tienne' => array( array('normal','700','900'), array('latin') ),
      'Tillana' => array( array('normal','500','600','700','800'), array('latin-ext','latin','devanagari') ),
      'Timmana' => array( array('normal'), array('telugu','latin') ),
      'Tinos' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','hebrew','latin','greek-ext','vietnamese') ),
      'Titan One' => array( array('normal'), array('latin-ext','latin') ),
      'Titillium Web' => array( array('200','200italic','300','300italic','normal','italic','600','600italic','700','700italic','900'), array('latin-ext','latin') ),
      'Trade Winds' => array( array('normal'), array('latin') ),
      'Trirong' => array( array('100','100italic','200','200italic','300','300italic','normal','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'), array('latin-ext','latin','thai','vietnamese') ),
      'Trocchi' => array( array('normal'), array('latin-ext','latin') ),
      'Trochut' => array( array('normal','italic','700'), array('latin') ),
      'Trykker' => array( array('normal'), array('latin-ext','latin') ),
      'Tulpen One' => array( array('normal'), array('latin') ),
      'Ubuntu' => array( array('300','300italic','normal','italic','500','500italic','700','700italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext') ),
      'Ubuntu Condensed' => array( array('normal'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext') ),
      'Ubuntu Mono' => array( array('normal','italic','700','700italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','greek-ext') ),
      'Ultra' => array( array('normal'), array('latin') ),
      'Uncial Antiqua' => array( array('normal'), array('latin') ),
      'Underdog' => array( array('normal'), array('latin-ext','cyrillic','latin') ),
      'Unica One' => array( array('normal'), array('latin-ext','latin') ),
      'UnifrakturCook' => array( array('700'), array('latin') ),
      'UnifrakturMaguntia' => array( array('normal'), array('latin') ),
      'Unkempt' => array( array('normal','700'), array('latin') ),
      'Unlock' => array( array('normal'), array('latin') ),
      'Unna' => array( array('normal','italic','700','700italic'), array('latin-ext','latin') ),
      'VT323' => array( array('normal'), array('latin-ext','latin','vietnamese') ),
      'Vampiro One' => array( array('normal'), array('latin-ext','latin') ),
      'Varela' => array( array('normal'), array('latin-ext','latin') ),
      'Varela Round' => array( array('normal'), array('latin-ext','hebrew','latin','vietnamese') ),
      'Vast Shadow' => array( array('normal'), array('latin') ),
      'Vesper Libre' => array( array('normal','500','700','900'), array('latin-ext','latin','devanagari') ),
      'Vibur' => array( array('normal'), array('latin') ),
      'Vidaloka' => array( array('normal'), array('latin') ),
      'Viga' => array( array('normal'), array('latin-ext','latin') ),
      'Voces' => array( array('normal'), array('latin-ext','latin') ),
      'Volkhov' => array( array('normal','italic','700','700italic'), array('latin') ),
      'Vollkorn' => array( array('normal','italic','600','600italic','700','700italic','900','900italic'), array('latin-ext','cyrillic','greek','cyrillic-ext','latin','vietnamese') ),
      'Vollkorn SC' => array( array('normal','600','700','900'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Voltaire' => array( array('normal'), array('latin') ),
      'Waiting for the Sunrise' => array( array('normal'), array('latin') ),
      'Wallpoet' => array( array('normal'), array('latin') ),
      'Walter Turncoat' => array( array('normal'), array('latin') ),
      'Warnes' => array( array('normal'), array('latin-ext','latin') ),
      'Wellfleet' => array( array('normal'), array('latin-ext','latin') ),
      'Wendy One' => array( array('normal'), array('latin-ext','latin') ),
      'Wire One' => array( array('normal'), array('latin') ),
      'Work Sans' => array( array('100','200','300','normal','500','600','700','800','900'), array('latin-ext','latin') ),
      'Yanone Kaffeesatz' => array( array('200','300','normal','700'), array('latin-ext','cyrillic','latin','vietnamese') ),
      'Yantramanav' => array( array('100','300','normal','500','700','900'), array('latin-ext','latin','devanagari') ),
      'Yatra One' => array( array('normal'), array('latin-ext','latin','devanagari') ),
      'Yellowtail' => array( array('normal'), array('latin') ),
      'Yeon Sung' => array( array('normal'), array('korean','latin') ),
      'Yeseva One' => array( array('normal'), array('latin-ext','cyrillic','cyrillic-ext','latin','vietnamese') ),
      'Yesteryear' => array( array('normal'), array('latin') ),
      'Yrsa' => array( array('300','normal','500','600','700'), array('latin-ext','latin') ),
      'ZCOOL KuaiLe' => array( array('normal'), array('chinese-simplified','latin') ),
      'ZCOOL QingKe HuangYou' => array( array('normal'), array('chinese-simplified','latin') ),
      'ZCOOL XiaoWei' => array( array('normal'), array('chinese-simplified','latin') ),
      'Zeyada' => array( array('normal'), array('latin') ),
      'Zhi Mang Xing' => array( array('normal'), array('chinese-simplified','latin') ),
      'Zilla Slab' => array( array('300','300italic','normal','italic','500','500italic','600','600italic','700','700italic'), array('latin-ext','latin') ),
      'Zilla Slab Highlight' => array( array('normal','700'), array('latin-ext','latin') )
    );
  }
}
