<?php
/**
 * Outputs Settings View when no Profiles are connected to the API
 *
 * @since    1.0.0
 *
 * @package post_bridge_social_poster
 * @author  Post Bridge Social Poster
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<div class="postbox">
	<div class="wpzinc-option">
		<p class="description">
			<?php
			esc_html_e( 'You must connect at least one social media account in Post Bridge Social Poster for this Plugin to send status updates to it.', 'post-bridge-social-poster' );
			?>
		</p>
		<p class="description">
			<?php esc_html_e( 'Once complete, refresh this page to enable and configure statuses for each social media account.', 'post-bridge-social-poster' ); ?>
		</p>
	</div>
	<div class="wpzinc-option">
		<a href="<?php echo esc_attr( post_bridge_social_poster()->get_class( 'api' )->get_connect_profiles_url() ); ?>" target="_blank" rel="nofollow noopener" class="button button-primary">
			<?php esc_html_e( 'Connect Profiles', 'post-bridge-social-poster' ); ?>
		</a>
	</div>
</div>
