<?php
/**
 * Outputs Settings View when an error occured fetching Profiles from the API
 *
 * @since    1.0.0
 *
 * @package post_bridge_social_poster
 * @author  Post Bridge Social Poster
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<div class="postbox">
	<div class="wpzinc-option">
		<p class="description">
			<?php echo esc_html( $profiles->get_error_message() ); ?>
		</p>
		<p class="description">
			<?php
			esc_html_e( 'Visit your Post Bridge Social Poster account to resolve this error.', 'post-bridge-social-poster' );
			?>
		</p>
	</div>
	<div class="wpzinc-option">
		<a href="<?php echo esc_attr( post_bridge_social_poster()->get_class( 'api' )->get_connect_profiles_url() ); ?>" target="_blank" rel="nofollow noopener" class="button button-primary">
			<?php
			esc_html_e( 'Visit Post Bridge Social Poster', 'post-bridge-social-poster' );
			?>
		</a>
	</div>
</div>
