<?php
/**
 * Outputs status settings when editing a Post.
 *
 * @package post_bridge_social_poster
 * @author  Post Bridge Social Poster
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<!-- Action Header -->
<div class="postbox">
	<header>
		<h3>
			<?php
			echo esc_html(
				sprintf(
				/* translators: %1$s: Social Media Service (Facebook, Twitter etc.), %2$s: Social Media Profile Name */
					__( '%1$s: %2$s: Settings', 'post-bridge-social-poster' ),
					$profile['service'],
					$profile['formatted_username']
				)
			);
			?>
		</h3>
	</header>

	<!-- Account Enabled -->
	<div class="wpzinc-option">        
		<div class="left">
			<label for="<?php echo esc_attr( $profile_id ); ?>_enabled"><?php esc_html_e( 'Account Enabled', 'post-bridge-social-poster' ); ?></label>
		</div>
		<div class="right">
			<input type="checkbox" id="<?php echo esc_attr( $profile_id ); ?>_enabled" class="enable" name="<?php echo esc_attr( post_bridge_social_poster()->plugin->name ); ?>[<?php echo esc_attr( $profile_id ); ?>][enabled]" id="<?php echo esc_attr( $profile_id ); ?>_enabled" value="1"<?php checked( $this->get_setting( $post_type, '[' . $profile_id . '][enabled]', 0 ), 1, true ); ?> data-tab="profile-<?php echo esc_attr( $profile_id ); ?>" />
			<p class="description"><?php esc_html_e( 'Enabling this social media account means that Posts will be sent to this social media account, if the conditions in the Settings are met.', 'post-bridge-social-poster' ); ?></p>
		</div>
	</div>
</div>
