<?php
/**
 * Outputs settings for a specific profile and action.
 *
 * @package post_bridge_social_poster
 * @author  Post Bridge Social Poster
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<!-- Action -->
<div id="profile-<?php echo esc_attr( $profile_id ); ?>-<?php echo esc_attr( $post_action ); ?>" class="postbox">
	<header>
		<h3>
			<?php
			if ( $profile_id === 'default' ) {
				echo esc_html(
					sprintf(
						/* translators: Translated Action (Publish, Update, Repost, Bulk Publish) */
						__( 'Defaults: ', 'post-bridge-social-poster' ),
						$action_label
					)
				);
			} else {
				echo esc_html( sprintf( '%s: %s: %s', $profile['service'], $profile['formatted_username'], $action_label ) );
			}
			?>

			<label for="<?php echo esc_attr( $profile_id ); ?>_<?php echo esc_attr( $post_action ); ?>_enabled">
				<input type="checkbox" id="<?php echo esc_attr( $profile_id ); ?>_<?php echo esc_attr( $post_action ); ?>_enabled" class="enable" name="<?php echo esc_attr( post_bridge_social_poster()->plugin->name ); ?>[<?php echo esc_attr( $profile_id ); ?>][<?php echo esc_attr( $post_action ); ?>][enabled]" value="1"<?php checked( $this->get_setting( $post_type, '[' . $profile_id . '][' . $post_action . '][enabled]', 0 ), 1, true ); ?> data-tab="profile-<?php echo esc_attr( $profile_id ); ?>-<?php echo esc_attr( $post_action ); ?>" data-conditional="<?php echo esc_attr( $post_type ); ?>-<?php echo esc_attr( $profile_id ); ?>-<?php echo esc_attr( $post_action ); ?>-statuses" />
				<?php esc_html_e( 'Enabled', 'post-bridge-social-poster' ); ?>
			</label>
		</h3>

		<p class="description">
			<?php
			echo esc_html(
				sprintf(
				/* translators: %1$s: Post Type, Singular, %2$s: Translated Action (Publish, Update, Repost, Bulk Publish), %3$s: Additional Translated Message */
					__( 'If enabled, any status(es) defined here will be sent to Post Bridge Social Poster when a WordPress %1$s is %2$s %3$s', 'post-bridge-social-poster' ),
					$post_type_object->labels->singular_name,
					strtolower( $actions_plural[ $post_action ] ),
					( $profile_id === 'default' ? '' : sprintf(
					/* translators: Profile username */
						__( 'to %s. These override the status(es) specified on the Defaults tab.', 'post-bridge-social-poster' ),
						$profile['formatted_username']
					) )
				)
			);
			?>
		</p>
	</header>

	<div id="<?php echo esc_attr( $post_type ); ?>-<?php echo esc_attr( $profile_id ); ?>-<?php echo esc_attr( $post_action ); ?>-statuses" class="statuses" data-profile-id="<?php echo esc_attr( $profile_id ); ?>" data-profile='<?php echo ( isset( $profile ) ? wp_json_encode( $profile, JSON_HEX_APOS ) : '' ); ?>' data-action="<?php echo esc_attr( $post_action ); ?>">
		<div class="wpzinc-option">
			<div class="full">
				<table class="widefat striped">
					<thead>
						<tr>
							<th>&nbsp;</th>
							<th><?php esc_html_e( 'Actions', 'post-bridge-social-poster' ); ?></th>
							<th><?php esc_html_e( 'Type', 'post-bridge-social-poster' ); ?></th>
							<th><?php esc_html_e( 'Text', 'post-bridge-social-poster' ); ?></th>
							<th><?php esc_html_e( 'Schedule', 'post-bridge-social-poster' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php
						// Fetch Publish / Update / Repost Statuses.
						$statuses = $this->get_setting( $post_type, '[' . $profile_id . '][' . $post_action . '][status]' );

						if ( ! is_array( $statuses ) || ! count( $statuses ) ) {
							$statuses = array(
								post_bridge_social_poster()->get_class( 'settings' )->get_default_status( $post_type, false, 'now' ),
							);
						}

						// Iterate through saved statuses.
						foreach ( $statuses as $key => $status ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
							$status = post_bridge_social_poster()->get_class( 'settings' )->get_status( $status, $post_type ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
							$labels = post_bridge_social_poster()->get_class( 'settings' )->get_status_value_labels( $status, $post_type );
							$row    = post_bridge_social_poster()->get_class( 'settings' )->get_status_row( $status, $post_type, $post_action );

							// Load sub view.
							require POST_BRIDGE_SOCIAL_POSTER_PLUGIN_PATH . 'views/settings-post-action-status-row.php';
						}
						?>
						<tr class="hidden status-form-container"><td colspan="6"></td></tr>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
