<?php
/**
 * Outputs the Settings screen when the Plugin is authenticated with
 * the third party API service.
 *
 * @package post_bridge_social_poster
 * @author  Post Bridge Social Poster
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<div class="postbox wpzinc-vertical-tabbed-ui">
	<!-- Second level tabs -->
	<ul class="wpzinc-nav-tabs wpzinc-js-tabs" data-panels-container="#settings-container" data-panel=".panel" data-active="wpzinc-nav-tab-vertical-active">
		<li class="wpzinc-nav-tab lock">
			<a href="#authentication" class="wpzinc-nav-tab-vertical-active" data-documentation="https://www.wpzinc.com/documentation/post-bridge/authentication-settings/">
				<?php esc_html_e( 'Authentication', 'post-bridge-social-poster' ); ?>
			</a>
		</li>
		<li class="wpzinc-nav-tab default">
			<a href="#general-settings" data-documentation="https://www.wpzinc.com/documentation/post-bridge/general-settings/">
				<?php esc_html_e( 'General Settings', 'post-bridge-social-poster' ); ?>
			</a>
		</li>
		<li class="wpzinc-nav-tab file-text">
			<a href="#log-settings" data-documentation="https://www.wpzinc.com/documentation/post-bridge/log-settings/">
				<?php esc_html_e( 'Log Settings', 'post-bridge-social-poster' ); ?>
			</a>
		</li>
	</ul>

	<!-- Content -->
	<div id="settings-container" class="wpzinc-nav-tabs-content">
		<!-- Authentication -->
		<div id="authentication" class="panel">
			<div class="postbox">
				<header>
					<h3><?php esc_html_e( 'Authentication', 'post-bridge-social-poster' ); ?></h3>

					<p class="description">
						<?php
						esc_html_e( 'Authentication allows Post Bridge Social Poster to post to your social media profiles.', 'post-bridge-social-poster' );
						?>
					</p>
				</header>

				<div class="wpzinc-option">
					<div class="full">
						<?php
						esc_html_e( 'Thanks - you\'ve authorized the plugin to post updates to your Post Bridge account.', 'post-bridge-social-poster' );
						?>
					</div>
				</div>
				<div class="wpzinc-option">
					<div class="full">
						<a href="<?php echo esc_url( $disconnect_url ); ?>" class="button wpzinc-button-red">
							<?php esc_html_e( 'Deauthorize Plugin', 'post-bridge-social-poster' ); ?>
						</a>
					</div>
				</div>
			</div>   
		</div>

		<!-- General Settings -->
		<div id="general-settings" class="panel">
			<div class="postbox">
				<header>
					<h3><?php esc_html_e( 'General Settings', 'post-bridge-social-poster' ); ?></h3>
					<p class="description">
						<?php esc_html_e( 'Provides options for logging, Post default level settings and whether to use WordPress Cron when publishing or updating Posts.', 'post-bridge-social-poster' ); ?>
					</p>
				</header>

				<div class="wpzinc-option">
					<div class="left">
						<label for="test_mode"><?php esc_html_e( 'Enable Test Mode', 'post-bridge-social-poster' ); ?></label>
					</div>
					<div class="right">
						<input type="checkbox" name="test_mode" id="test_mode" value="1" <?php checked( $this->get_setting( '', 'test_mode' ), 1 ); ?> />

						<p class="description">
							<?php
							esc_html_e( 'If enabled, status(es) are not sent to Post Bridge Social Poster, but will appear in the Log, if logging is enabled. This is useful to test status text, conditions etc.', 'post-bridge-social-poster' );
							?>
						</p>
					</div>
				</div>

				<div class="wpzinc-option">
					<div class="left">
						<label for="force_trailing_forwardslash"><?php esc_html_e( 'Force Trailing Forwardslash?', 'post-bridge-social-poster' ); ?></label>
					</div>
					<div class="right">
						<input type="checkbox" name="force_trailing_forwardslash" id="force_trailing_forwardslash" value="1" <?php checked( $this->get_setting( '', 'force_trailing_forwardslash' ), 1 ); ?> />

						<p class="description">
							<?php
							esc_html_e( 'If enabled, any URLs in statuses will always end with a forwardslash. This might be required if the wrong image is shared with a status.', 'post-bridge-social-poster' );
							?>
							<br />
							<?php
							printf(
								'%1$s <a href="options-permalink.php">%2$s</a> %3$s',
								esc_html__( 'It\'s better to ensure your', 'post-bridge-social-poster' ),
								esc_html__( 'Permalink', 'post-bridge-social-poster' ),
								esc_html__( 'settings end with a forwardslash, but this option is a useful fallback if changing Permalink structure isn\'t possible.', 'post-bridge-social-poster' )
							);
							?>
						</p>
					</div>
				</div>

				<div class="wpzinc-option">
					<div class="left">
						<label for="proxy"><?php esc_html_e( 'Use Proxy?', 'post-bridge-social-poster' ); ?></label>
					</div>
					<div class="right">
						<input type="checkbox" name="proxy" id="proxy" value="1" <?php checked( $this->get_setting( '', 'proxy' ), 1 ); ?> />

						<p class="description">
							<?php
							echo esc_html(
								sprintf(
									/* translators: %1$s: Social Media Service Name */
									__( 'If enabled, statuses sent to %1$s are performed through our proxy. This is useful if your ISP or host\'s country prevents access to %1$s.', 'post-bridge-social-poster' ),
									post_bridge_social_poster()->plugin->account
								)
							);
							?>
							<br />
							<?php esc_html_e( 'You may still need to use a VPN for initial Authentication when setting up the Plugin for the first time.', 'post-bridge-social-poster' ); ?>
						</p>
					</div>
				</div>
			</div>
		</div>

		<!-- Log Settings -->
		<div id="log-settings" class="panel">
			<div class="postbox">
				<header>
					<h3><?php esc_html_e( 'Log Settings', 'post-bridge-social-poster' ); ?></h3>
					<p class="description">
						<?php esc_html_e( 'Provides options to enable logging, display logs on Posts and how long to keep logs for.', 'post-bridge-social-poster' ); ?>
					</p>
				</header>

				<div class="wpzinc-option">
					<div class="left">
						<label for="log_enabled"><?php esc_html_e( 'Enable Logging?', 'post-bridge-social-poster' ); ?></label>
					</div>
					<div class="right">
						<input type="checkbox" name="log[enabled]" id="log_enabled" value="1" <?php checked( $this->get_setting( 'log', '[enabled]' ), 1 ); ?> data-conditional="enable_logging" />
						<p class="description">
							<?php
							if ( $this->get_setting( 'log', '[enabled]' ) ) {
								printf(
									'%1$s <a href="%2$s">%3$s</a> %4$s',
									esc_html__( 'If enabled, the', 'post-bridge-social-poster' ),
									esc_html( admin_url( 'admin.php?page=post-bridge-social-poster-log' ) ),
									esc_html__( 'Plugin Logs', 'post-bridge-social-poster' ),
									esc_html__( 'will detail status(es) sent to Post Bridge Social Poster, including any errors or reasons why no status(es) were sent.', 'post-bridge-social-poster' )
								);
							} else {
								// Don't link "Plugin Log" text, as Logs are disabled so it won't show anything.
								esc_html_e( 'If enabled, the Plugin Logs will detail status(es) sent to Post Bridge Social Poster, including any errors or reasons why no status(es) were sent.', 'post-bridge-social-poster' );
							}
							?>
						</p>
					</div>
				</div>

				<div id="enable_logging">
					<div class="wpzinc-option">
						<div class="left">
							<label for="log_display_on_posts"><?php esc_html_e( 'Display on Posts?', 'post-bridge-social-poster' ); ?></label>
						</div>
						<div class="right">
							<input type="checkbox" name="log[display_on_posts]" id="log_display_on_posts" value="1" <?php checked( $this->get_setting( 'log', '[display_on_posts]' ), 1 ); ?> />
			   
							<p class="description">
								<?php
								if ( $this->get_setting( 'log', '[enabled]' ) ) {
									printf(
										'%1$s <a href="%2$s">%3$s</a> %4$s',
										esc_html__( 'If enabled, a Log will be displayed when editing a Post.  Logs are always available through the', 'post-bridge-social-poster' ),
										esc_html( admin_url( 'admin.php?page=post-bridge-social-poster-log' ) ),
										esc_html__( 'Plugin Logs', 'post-bridge-social-poster' ),
										esc_html__( 'screen', 'post-bridge-social-poster' )
									);
								} else {
									// Don't link "Plugin Log" text, as Logs are disabled so it won't show anything.
									esc_html_e( 'If enabled, a Log will be displayed when editing a Post.  Logs are always available through the Plugin Logs screen.', 'post-bridge-social-poster' );
								}
								?>
							</p>
						</div>
					</div>

					<div class="wpzinc-option">
						<div class="left">
							<label for="log_level"><?php esc_html_e( 'Log Level', 'post-bridge-social-poster' ); ?></label>
						</div>
						<div class="right">
							<?php
							$log_levels_settings = $this->get_setting( 'log', 'log_level' );

							foreach ( $log_levels as $log_level => $label ) {
								?>
								<label for="log_level_<?php echo esc_attr( $log_level ); ?>">
									<input  type="checkbox" 
											name="log[log_level][]" 
											id="log_level_<?php echo esc_attr( $log_level ); ?>"
											value="<?php echo esc_attr( $log_level ); ?>"
											<?php echo ( in_array( $log_level, $log_levels_settings, true ) || $log_level === 'error' ? ' checked' : '' ); ?>
											<?php echo ( ( $log_level === 'error' ) ? ' disabled' : '' ); ?>
											/>

									<?php echo esc_html( $label ); ?>
								</label>
								<br />
								<?php
							}
							?>

							<p class="description">
								<?php esc_html_e( 'Defines which log results to save to the Log database. Errors will always be logged.', 'post-bridge-social-poster' ); ?>
							</p>
						</div>
					</div>

					<div class="wpzinc-option">
						<div class="left">
							<label for="log_preserve_days"><?php esc_html_e( 'Preserve Logs', 'post-bridge-social-poster' ); ?></strong>
						</div>
						<div class="right">
							<input type="number" name="log[preserve_days]" id="log_preserve_days" value="<?php echo esc_attr( $this->get_setting( 'log', '[preserve_days]' ) ); ?>" min="0" max="9999" step="1" />
							<?php esc_html_e( 'days', 'post-bridge-social-poster' ); ?>
					   
							<p class="description">
								<?php
								esc_html_e( 'The number of days to preserve logs for.  Zero means logs are kept indefinitely.', 'post-bridge-social-poster' );
								?>
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
