<?php
/**
 * Outputs a screen with a button/link/form to authenticate the Plugin
 * with the third party API service.
 *
 * @package post_bridge_social_poster
 * @author  Post Bridge Social Poster
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<header>
	<h1>
		<?php esc_html_e( 'Post Bridge Social Poster', 'post-bridge-social-poster' ); ?>

		<span>
			<?php esc_html_e( 'Settings', 'post-bridge-social-poster' ); ?>
		</span>
	</h1>
</header>

<div class="wrap">
	<div class="wrap-inner">
		<!-- Notices -->
		<hr class="wp-header-end" />

		<div id="poststuff">
			<div id="post-body" class="metabox-holder columns-1">
				<div id="post-body-content">
					<div id="normal-sortables" class="meta-box-sortables ui-sortable">
						<div class="postbox"> 
							<form method="post" action="<?php echo esc_url( $admin_url ); ?>">
								<div class="wpzinc-option">
									<p class="description">
										<?php
										esc_html_e( 'To allow this Plugin to post updates to your social media profiles using Post Bridge Social Poster, please enter your Post Bridge API Key below.', 'post-bridge-social-poster' );
										?>
									</p>
									<p class="description">
										<?php
										esc_html_e( 'Don\'t have a Post Bridge account?', 'post-bridge-social-poster' );
										?>
										<a href="<?php echo esc_attr( post_bridge_social_poster()->get_class( 'api' )->get_registration_url() ); ?>" target="_blank" rel="nofollow noopener">
											<?php esc_html_e( 'Sign up', 'post-bridge-social-poster' ); ?>
										</a>
									</p>
								</div>

								<div class="wpzinc-option">
									<div class="full">
										<input type="text" name="post_bridge_social_poster_oauth_token" placeholder="<?php esc_attr_e( 'Post Bridge API Key', 'post-bridge-social-poster' ); ?>" class="widefat" required />
									</div>
								</div>

								<div class="wpzinc-option">
									<div class="full">
										<?php
										wp_nonce_field( 'post-bridge-social-poster-oauth-connect', 'post_bridge_social_poster_oauth_connect_nonce' );
										submit_button( esc_attr__( 'Save', 'post-bridge-social-poster' ), 'primary', 'post_bridge_api_key_submit', false );
										?>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
