<?php
/**
 * Outputs the Logs table when viewing/editing an individual Post.
 *
 * @package post_bridge_social_poster
 * @author  Post Bridge Social Poster
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<div class="wpzinc-option">
	<div class="full">
		<table class="widefat wp-to-social-log">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Request Sent', 'post-bridge-social-poster' ); ?></th>
					<th><?php esc_html_e( 'Action', 'post-bridge-social-poster' ); ?></th>
					<th><?php esc_html_e( 'Profile', 'post-bridge-social-poster' ); ?></th>
					<th><?php esc_html_e( 'Status Text', 'post-bridge-social-poster' ); ?></th>
					<th><?php esc_html_e( 'Result', 'post-bridge-social-poster' ); ?></th>
					<th><?php esc_html_e( 'Response', 'post-bridge-social-poster' ); ?></th>
					<th><?php esc_html_e( 'Post Bridge: Status Created At', 'post-bridge-social-poster' ); ?></th>
					<th><?php esc_html_e( 'Post Bridge: Status Scheduled For', 'post-bridge-social-poster' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php
				echo wp_kses(
					post_bridge_social_poster()->get_class( 'log' )->build_log_table_output( $log ),
					array(
						'tr' => array(
							'class' => array(),
						),
						'td' => array(
							'class' => array(),
						),
						'a'  => array(
							'href'   => array(),
							'target' => array(),
						),
						'br' => array(),
					)
				);
				?>
			</tbody>
		</table>
	</div>
</div>
<div class="wpzinc-option">
	<div class="full">
		<a href="<?php echo esc_attr( $urls['refresh'] ); ?>" class="post-bridge-social-poster-refresh-log button" data-action="post_bridge_social_poster_get_log" data-target="#post-bridge-social-poster-log">
			<?php esc_html_e( 'Refresh Log', 'post-bridge-social-poster' ); ?>
		</a>
		<a href="<?php echo esc_attr( $urls['export'] ); ?>" class="post-bridge-social-poster-export-log button">
			<?php esc_html_e( 'Export Log', 'post-bridge-social-poster' ); ?>
		</a>
		<a href="<?php echo esc_attr( $urls['clear'] ); ?>" class="post-bridge-social-poster-clear-log button wpzinc-button-red" data-action="post_bridge_social_poster_clear_log" data-target="#post-bridge-social-poster-log" data-message="<?php esc_attr_e( 'Are you sure you want to clear the logs associated with this Post?', 'post-bridge-social-poster' ); ?>">
			<?php esc_html_e( 'Clear Log', 'post-bridge-social-poster' ); ?>
		</a>
	</div>
</div>
