<?php
/**
 * Defines the deactivation function, which is run when the Plugin is deactivated.
 *
 * @package Post_Bridge_Social_Poster
 * @author WP Zinc
 */

/**
 * Runs the uninstallation routines when the plugin is deactivated.
 *
 * @since   1.0.0
 *
 * @param   bool $network_wide   Is network wide deactivation.
 */
function post_bridge_social_poster_deactivate( $network_wide ) {

	// Initialise Plugin.
	$post_bridge_social_poster = Post_Bridge_Social_Poster::get_instance();
	$post_bridge_social_poster->initialize();

	// Check if we are on a multisite install, activating network wide, or a single install.
	if ( ! is_multisite() || ! $network_wide ) {
		// Single Site deactivation.
		$post_bridge_social_poster->get_class( 'install' )->uninstall();
	} else {
		// Multisite network wide deactivation.
		$sites = get_sites(
			array(
				'number' => 0,
			)
		);
		foreach ( $sites as $site ) {
			switch_to_blog( $site->blog_id );
			$post_bridge_social_poster->get_class( 'install' )->uninstall();
			restore_current_blog();
		}
	}

}
