<?php
/**
 * Defines functions that are called by WordPress' Cron.
 *
 * @package Post_Bridge_Social_Poster
 * @author WP Zinc
 */

/**
 * Define the WP Cron function to perform the log cleanup
 *
 * @since   1.0.0
 */
function post_bridge_social_poster_log_cleanup_cron() {

	// Initialise Plugin.
	$post_bridge_social_poster = Post_Bridge_Social_Poster::get_instance();
	$post_bridge_social_poster->initialize();

	// Call CRON Log Cleanup function.
	$post_bridge_social_poster->get_class( 'cron' )->log_cleanup();

	// Shutdown.
	unset( $post_bridge_social_poster );

}
add_action( 'post_bridge_social_poster_log_cleanup_cron', 'post_bridge_social_poster_log_cleanup_cron' );
