<?php
/**
 * Post class
 *
 * @package Post_Bridge_Social_Poster
 * @author WP Zinc
 */

/**
 * Registers status settings on Posts as a metabox.
 *
 * @package Post_Bridge_Social_Poster
 * @author WP Zinc
 * @version 1.0.0
 */
class Post_Bridge_Social_Poster_Post {

	/**
	 * Constructor
	 *
	 * @since   1.0.0
	 */
	public function __construct() {

		// Admin Notices.
		add_action( 'admin_notices', array( $this, 'admin_notices' ) );

	}

	/**
	 * Outputs a notice if the user is editing a Post, which has a meta key indicating
	 * that status(es) were published to the API.
	 *
	 * @since   1.0.0
	 */
	public function admin_notices() {

		global $post;

		// Check we can get the current screen the user is viewing.
		$screen = get_current_screen();
		if ( ! $screen || ! isset( $screen->base ) || ! isset( $screen->parent_base ) ) {
			return;
		}

		// Check we are on a Post based screen (includes Pages + CPTs).
		if ( $screen->base !== 'post' ) {
			return;
		}

		// Check we are editing a Post, Page or CPT.
		if ( $screen->parent_base !== 'edit' ) {
			return;
		}

		// Get the post ID from the global post object.
		if ( ! $post instanceof WP_Post ) {
			return;
		}
		$post_id = $post->ID;

		// Check if this Post has a success or error meta key set by this plugin.
		$success = get_post_meta( $post_id, '_post_bridge_social_poster_success', true );
		$error   = get_post_meta( $post_id, '_post_bridge_social_poster_error', true );
		$errors  = get_post_meta( $post_id, '_post_bridge_social_poster_errors', true );

		// Check for success.
		if ( $success ) {
			// Show notice and clear meta key, so we don't display this notice again.
			delete_post_meta( $post_id, '_post_bridge_social_poster_success' );
			?>
			<div class="notice notice-success is-dismissible">
				<p>
					<?php
					esc_html_e( 'Post Bridge Social Poster: Post successfully added to Post Bridge Social Poster.', 'post-bridge-social-poster' );
					?>
				</p>
			</div>
			<?php
		}

		// Check for error.
		if ( $error ) {
			// Show notice and clear meta key, so we don't display this notice again.
			delete_post_meta( $post_id, '_post_bridge_social_poster_error' );
			delete_post_meta( $post_id, '_post_bridge_social_poster_errors' );
			?>
			<div class="notice notice-error is-dismissible">
				<p>
					<?php
					esc_html_e( 'Post Bridge Social Poster: Some status(es) could not be sent to Post Bridge Social Poster', 'post-bridge-social-poster' );
					?>
					<br />
					<?php
					foreach ( $errors as $error ) {
						echo esc_html( $error ) . '<br />';
					}
					?>
				</p>
			</div>
			<?php
		}

	}

}