<?php
/**
 * Install class.
 *
 * @package Post_Bridge_Social_Poster
 * @author WP Zinc
 */

/**
 * Runs any steps required on plugin activation and upgrade.
 *
 * @package Post_Bridge_Social_Poster
 * @author WP Zinc
 * @version  1.0.0
 */
class Post_Bridge_Social_Poster_Install {

	/**
	 * Runs installation routines for first time users
	 *
	 * @since   1.0.0
	 */
	public function install() {

		// Enable logging by default.
		post_bridge_social_poster()->get_class( 'settings' )->update_option(
			'log',
			array(
				'enabled'          => 1,
				'display_on_posts' => 1,
				'preserve_days'    => 30,
				'log_level'        => array(
					'success',
					'test',
					'pending',
					'warning',
					'error',
				),
			)
		);

		// Create logging database table.
		post_bridge_social_poster()->get_class( 'log' )->activate();

		// Reschedule the cron events.
		post_bridge_social_poster()->get_class( 'cron' )->schedule_log_cleanup_event();

		// Bail if settings already exist.
		$settings = post_bridge_social_poster()->get_class( 'settings' )->get_settings( 'post' );
		if ( $settings !== false ) {
			return;
		}

		// Get default installation settings.
		$settings = post_bridge_social_poster()->get_class( 'settings' )->default_installation_settings( 'post' );
		post_bridge_social_poster()->get_class( 'settings' )->update_settings( 'post', $settings );

	}

	/**
	 * Runs uninstallation routines
	 *
	 * @since   1.0.0
	 */
	public function uninstall() {

		// Unschedule any CRON events.
		post_bridge_social_poster()->get_class( 'cron' )->unschedule_log_cleanup_event();

	}

}
