<?php
/**
 * Plugin Name: Pointify – Interactive Hotspot
 * Description: Add interactive pins/hotspots with popups to any image in Elementor.
 * Version: 1.0.0
 * Author: Nexiby LLC
 * Text Domain: pointify
 * Requires PHP: 8.0
 * Requires at least: 5.8
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires Elementor version: 3.30.0
 * Requires Plugins: elementor
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define('POINTIFY_VERSION', '1.0.0');
define('POINTIFY_PATH', plugin_dir_path(__FILE__));
define('POINTIFY_URL', plugin_dir_url(__FILE__));

require_once POINTIFY_PATH . 'includes/Plugin.php';

add_action('plugins_loaded', function () {
    // Basic Elementor presence check
    if ( ! did_action('elementor/loaded') ) {
        add_action('admin_notices', function () {
            echo '<div class="notice notice-error"><p>'
                . esc_html__('Pointify requires Elementor to be installed and active.', 'pointify')
                . '</p></div>';
        });
        return;
    }
    \Pointify\Plugin::instance();
});
