<?php
if (!defined('ABSPATH'))
    exit;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;


/*-------------------------------
 * Styles
 *--------------------------------*/

$this->start_controls_section('pointify_style_image', [
    'label' => esc_html__('Image', 'pointify'),
    'tab' => Controls_Manager::TAB_STYLE,
]);

// Image Width
$this->add_responsive_control('image_width', [
    'label' => esc_html__('Image Width', 'pointify'),
    'type' => Controls_Manager::SLIDER,
    'size_units' => ['px', '%', 'em'],
    'range' => ['px' => ['min' => 200, 'max' => 1400]],
    'selectors' => [
        '{{WRAPPER}} .pointify-pinpoint__image-wrap' => 'width: {{SIZE}}{{UNIT}};',
        '{{WRAPPER}} .pointify-pinpoint__image' => 'width: {{SIZE}}{{UNIT}};',
    ],
]);

// Image Height
$this->add_responsive_control('image_height', [
    'label' => esc_html__('Image Height', 'pointify'),
    'type' => Controls_Manager::SLIDER,
    'size_units' => ['px', '%', 'em'],
    'range' => ['px' => ['min' => 20, 'max' => 1400]],
    'selectors' => [
        '{{WRAPPER}} .pointify-pinpoint__image-wrap' => 'height: {{SIZE}}{{UNIT}};',
        '{{WRAPPER}} .pointify-pinpoint__image' => 'height: {{SIZE}}{{UNIT}};',
    ],
]);

$this->end_controls_section(); // Image


// Pin Style
$this->start_controls_section('pointify_style_pin', [
    'label' => esc_html__('Pin Style', 'pointify'),
    'tab' => Controls_Manager::TAB_STYLE,
]);

$this->add_responsive_control('pin_size', [
    'label' => esc_html__('Pin Size', 'pointify'),
    'type' => Controls_Manager::SLIDER,
    'range' => ['px' => ['min' => 12, 'max' => 80]],
    'default' => ['size' => 30, 'unit' => 'px'],
    'selectors' => [
        '{{WRAPPER}} .pointify-pin' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
    ],
]);

$this->add_control('pin_bg', [
    'label' => esc_html__('Pin Background', 'pointify'),
    'type' => Controls_Manager::COLOR,
    'default' => '#ffffff',
    'selectors' => ['{{WRAPPER}} .pointify-pin' => 'background-color: {{VALUE}};'],
]);



$this->add_responsive_control('pin_icon_size', [
    'label' => esc_html__('Icon Size', 'pointify'),
    'type' => Controls_Manager::SLIDER,
    'range' => ['px' => ['min' => 10, 'max' => 80]],
    'default' => ['size' => 20, 'unit' => 'px'],
    'selectors' => [
        '{{WRAPPER}} .pointify-pin .pointify-pin__icon i' => 'font-size: {{SIZE}}{{UNIT}};',
        '{{WRAPPER}} .pointify-pin .pointify-pin__icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
    ],
]);

$this->add_control('pin_icon_color', [
    'label' => esc_html__('Icon Color', 'pointify'),
    'type' => Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .pointify-pin.pin--icon .pointify-pin__icon' => 'color: {{VALUE}};',
        '{{WRAPPER}} .pointify-pin.pin--icon .pointify-pin__icon svg' => 'fill: {{VALUE}};',
    ],
]);

$this->add_control('pin_dot_color', [
    'label' => esc_html__('Dot Color', 'pointify'),
    'type' => Controls_Manager::COLOR,
    'selectors' => [
        '{{WRAPPER}} .pointify-pin__dot .pk-dot' => 'background-color: {{VALUE}};',
    ],
]);

$this->add_group_control(Group_Control_Border::get_type(), [
    'name' => 'pin_border',
    'selector' => '{{WRAPPER}} .pointify-pin',
    'fields_options' => [
        'border' => ['default' => 'solid'],
        'width' => ['default' => ['top' => 2, 'right' => 2, 'bottom' => 2, 'left' => 2, 'isLinked' => true]],
        'color' => ['default' => '#6b46c1'],
    ]
]);

$this->add_responsive_control('pin_border_radius', [
    'label' => esc_html__('Pin Radius', 'pointify'),
    'type' => Controls_Manager::DIMENSIONS,
    'size_units' => ['px', '%', 'em'],
    'default' => [
        'top' => 100,
        'right' => 100,
        'bottom' => 100,
        'left' => 100,
        'unit' => '%',
        'isLinked' => true,
    ],
    'selectors' => [
        '{{WRAPPER}} .pointify-pin' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
    ],
]);

$this->add_control('pulse_color', [
    'label' => esc_html__('Pulse Color', 'pointify'),
    'type' => Controls_Manager::COLOR,
    'default' => 'rgba(107,70,193,.35)',
    'selectors' => ['{{WRAPPER}} .pointify-pin.pulse:after' => 'background: {{VALUE}};'],
    'condition' => ['enable_pulse' => 'yes'],
]);

$this->end_controls_section();

/**
 * STYLE → Popup
 */
$this->start_controls_section('pointify_style_popup', [
    'label' => esc_html__('Popup Style', 'pointify'),
    'tab' => Controls_Manager::TAB_STYLE,
]);

$this->add_control('popup_bg', [
    'label' => esc_html__('Background', 'pointify'),
    'type' => Controls_Manager::COLOR,
    'default' => '#ffffff',
    'selectors' => ['{{WRAPPER}} .pointify-pin-popup' => 'background: {{VALUE}};'],
]);

$this->add_group_control(Group_Control_Border::get_type(), [
    'name' => 'popup_border',
    'selector' => '{{WRAPPER}} .pointify-pin-popup',
]);

$this->add_group_control(Group_Control_Box_Shadow::get_type(), [
    'name' => 'popup_shadow',
    'selector' => '{{WRAPPER}} .pointify-pin-popup',
]);

$this->add_responsive_control('popup_width', [
    'label' => esc_html__('Max Width', 'pointify'),
    'type' => Controls_Manager::SLIDER,
    'range' => ['px' => ['min' => 160, 'max' => 600]],
    'default' => ['size' => 260, 'unit' => 'px'],
    'selectors' => ['{{WRAPPER}} .pointify-pin-popup' => 'width: {{SIZE}}{{UNIT}};'],
]);

$this->add_responsive_control('popup_padding', [
    'label' => esc_html__('Padding', 'pointify'),
    'type' => Controls_Manager::DIMENSIONS,
    'size_units' => ['px', 'em', '%'],
    'default' => ['top' => 14, 'right' => 14, 'bottom' => 14, 'left' => 14, 'unit' => 'px', 'isLinked' => true],
    'selectors' => ['{{WRAPPER}} .pointify-pin-popup' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],
]);

$this->add_group_control(Group_Control_Typography::get_type(), [
    'name' => 'popup_title_typo',
    'label' => esc_html__('Title Typography', 'pointify'),
    'selector' => '{{WRAPPER}} .pointify-pin-popup__title',
]);

$this->add_control('popup_title_color', [
    'label' => esc_html__('Title Color', 'pointify'),
    'type' => Controls_Manager::COLOR,
    'default' => '#111827',
    'selectors' => ['{{WRAPPER}} .pointify-pin-popup__title' => 'color: {{VALUE}};'],
]);

$this->add_group_control(Group_Control_Typography::get_type(), [
    'name' => 'popup_text_typo',
    'selector' => '{{WRAPPER}} .pointify-pin-popup__text',
    'label' => esc_html__('Text Typography', 'pointify'),
]);

$this->add_control('popup_text_color', [
    'label' => esc_html__('Text Color', 'pointify'),
    'type' => Controls_Manager::COLOR,
    'default' => '#4b5563',
    'selectors' => ['{{WRAPPER}} .pointify-pin-popup__text' => 'color: {{VALUE}};'],
]);

$this->end_controls_section();