<?php
if (!defined('ABSPATH')) {
	exit;
}

$settings = $this->get_settings_for_display();
$image_id = isset($settings['image']['id']) ? $settings['image']['id'] : 0;
$image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src(
	$image_id,
	'image_size',
	$settings
);
if (!$image_url && !empty($settings['image']['url'])) {
	$image_url = $settings['image']['url'];
}

$widget_id = $this->get_id();
$exclusive = !empty($settings['open_exclusive']) ? 'true' : 'false';
$pulse = !empty($settings['enable_pulse']) ? 'pulse' : '';
?>
<div class="pointify-pinpoint" data-exclusive="<?php echo esc_attr($exclusive); ?>"
	data-widget="<?php echo esc_attr($widget_id); ?>">

	<div class="pointify-pinpoint__image-wrap">
		<img class="pointify-pinpoint__image" src="<?php echo esc_url($image_url); ?>" alt="">
		<?php if (!empty($settings['pins'])): ?>
			<?php foreach ($settings['pins'] as $index => $pin):
				$x = isset($pin['pos_x']['size']) ? floatval($pin['pos_x']['size']) : 50;
				$y = isset($pin['pos_y']['size']) ? floatval($pin['pos_y']['size']) : 50;
				$trg = !empty($pin['trigger']) ? $pin['trigger'] : 'hover';
				$open = !empty($pin['start_open']) ? 'true' : 'false';
				$hide = !empty($pin['hide_pin']) ? 'true' : 'false';
				$link = (!empty($pin['link']['url'])) ? $pin['link'] : null;
				$mode = !empty($pin['display_type']) ? $pin['display_type'] : 'dot';
				$offset = isset($pin['popup_offset']['size']) ? intval($pin['popup_offset']['size']) : 10;

				// Elementor icons render helper
				ob_start();
				\Elementor\Icons_Manager::render_icon($pin['icon'], ['aria-hidden' => 'true']);
				$icon_html = ob_get_clean();
				?>
				<div class="pointify-pin elementor-repeater-item-<?php echo esc_attr( $pin['_id'] ); ?> <?php echo esc_attr($pulse); ?> <?php echo $hide === 'true' ? 'is-hidden-pin' : ''; ?>"
					role="button" tabindex="0" data-index="<?php echo esc_attr($index); ?>"
					data-trigger="<?php echo esc_attr($trg); ?>" data-open="<?php echo esc_attr($open); ?>"
					style="left: <?php echo esc_attr($x); ?>%; top: <?php echo esc_attr($y); ?>%;" <?php echo $pin['_id'] ? 'id="' . esc_attr($pin['_id']) . '"' : ''; ?>>

					<?php if ($mode === 'icon' && $icon_html): ?>
						<span class="pointify-pin__icon"><?php echo wp_kses_post($icon_html); ?></span>
					<?php else: ?>
						<span class="pointify-pin__dot"><span class="pk-dot"></span></span>
					<?php endif; ?>

					  <div class="pointify-pin-popup" aria-hidden="true" style="--pk-offset: <?php echo esc_attr($offset); ?>px;">
						<?php if (!empty($pin['title'])): ?>
							<div class="pointify-pin-popup__title"><?php echo esc_html($pin['title']); ?></div>
						<?php endif; ?>

						<?php if (!empty($pin['desc'])): ?>
							<div class="pointify-pin-popup__text"><?php echo wp_kses_post($pin['desc']); ?></div>
						<?php endif; ?>

						<?php if ($link):
							$target = !empty($link['is_external']) ? ' target="_blank" rel="noopener"' : '';
							$nofollow = !empty($link['nofollow']) ? ' rel="nofollow"' : '';
							?>
							<div class="pointify-pin-popup__cta">
								<a class="pointify-pin-popup__link" href="<?php echo esc_url($link['url']); ?>" <?php echo esc_attr($target) . esc_attr($nofollow); ?>>
									<?php echo esc_html__('Learn more', 'pointify'); ?>
								</a>
							</div>
						<?php endif; ?>
						<span class="pointify-pin-popup__arrow" aria-hidden="true"></span>
					</div>
				</div>
			<?php endforeach; ?>
		<?php endif; ?>
	</div>
</div>