<?php
namespace Pointify\Widgets\PinPoint;

if (!defined('ABSPATH'))
	exit; // Exit if accessed directly

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Repeater;
use Elementor\Group_Control_Border;

/**
 * Elementor Animated Timeline Widget.
 */
class Main extends Widget_Base
{

	public function get_name()
	{
		return 'pointify-PinPoint';
	}

	public function get_title()
	{
		return esc_html__('Pin Point', 'pointify');
	}

	public function get_icon()
	{
		return 'eicon-google-maps';
	}

	public function get_categories()
	{
		return ['general'];
	}

	public function get_keywords()
	{
		return ['pointify', 'pinpoint', 'hotspot'];
	}

	public function get_style_depends()
	{
		return ['pointify-pinpoint'];
	}

	public function get_script_depends()
	{
		return ['pointify-pinpoint'];
	}

	protected function register_controls()
	{


		/**
		 * CONTENT → Image + Pins
		 */
		$this->start_controls_section('pointify_image_sec', [
			'label' => esc_html__('Image & Pins', 'pointify'),
			'tab' => Controls_Manager::TAB_CONTENT,
		]);

		$this->add_control('image', [
			'label' => esc_html__('Base Image', 'pointify'),
			'type' => Controls_Manager::MEDIA,
			'default' => ['url' => \Elementor\Utils::get_placeholder_image_src()],
		]);
		

		$rep = new Repeater();

		$rep->start_controls_tabs('pin_tabs');

		$rep->start_controls_tab('pin_content_tab', [
			'label' => esc_html__('Content', 'pointify'),
		]);
		$rep->add_control('label', [
			'label' => esc_html__('Label (admin only)', 'pointify'),
			'type' => Controls_Manager::TEXT,
			'default' => 'Pin',
		]);

		$rep->add_responsive_control('pos_x', [
			'label' => esc_html__('Position X (%)', 'pointify'),
			'type' => Controls_Manager::SLIDER,
			'size_units' => ['%'],
			'range' => ['%' => ['min' => 0, 'max' => 100]],
			'default' => ['size' => 50, 'unit' => '%'],
		]);

		$rep->add_responsive_control('pos_y', [
			'label' => esc_html__('Position Y (%)', 'pointify'),
			'type' => Controls_Manager::SLIDER,
			'size_units' => ['%'],
			'range' => ['%' => ['min' => 0, 'max' => 100]],
			'default' => ['size' => 50, 'unit' => '%'],
		]);

		$rep->add_control('trigger', [
			'label' => esc_html__('Open On', 'pointify'),
			'type' => Controls_Manager::CHOOSE,
			'options' => [
				'hover' => ['title' => esc_html__('Hover', 'pointify'), 'icon' => 'eicon-drag-n-drop'],
				'click' => ['title' => esc_html__('Click', 'pointify'), 'icon' => 'eicon-click'],
			],
			'toggle' => false,
			'default' => 'hover',
		]);

		// optional distance knob
		$rep->add_control('popup_offset', [
			'label' => esc_html__('Offset (px)', 'pointify'),
			'type' => Controls_Manager::SLIDER,
			'range' => ['px' => ['min' => 0, 'max' => 40]],
			'default' => ['size' => 10, 'unit' => 'px'],
		]);

		$rep->add_control('display_type', [
			'label' => esc_html__('Display As', 'pointify'),
			'type' => Controls_Manager::CHOOSE,
			'options' => [
				'dot' => ['title' => esc_html__('Point', 'pointify'), 'icon' => 'eicon-dot-circle-o'],
				'icon' => ['title' => esc_html__('Icon', 'pointify'), 'icon' => 'eicon-favorite'],
			],
			'default' => 'dot',
			'toggle' => false,
		]);

		// Keep your existing 'icon' control, but make it show only for icon mode:
		$rep->add_control('icon', [
			'label' => esc_html__('Icon', 'pointify'),
			'type' => Controls_Manager::ICONS,
			'default' => [
				'value' => 'fas fa-map-marker-alt',
				'library' => 'fa-solid',
			],
			'condition' => ['display_type' => 'icon'],
		]);

		$rep->add_control('title', [
			'label' => esc_html__('Popup Title', 'pointify'),
			'type' => Controls_Manager::TEXT,
			'default' => 'Feature',
			'label_block' => true,
		]);

		$rep->add_control('desc', [
			'label' => esc_html__('Popup Content', 'pointify'),
			'type' => Controls_Manager::TEXTAREA,
			'default' => 'Explain or link to more details here.',
			'rows' => 3,
		]);

		$rep->add_control('link', [
			'label' => esc_html__('Optional Link', 'pointify'),
			'type' => Controls_Manager::URL,
			'placeholder' => 'https://example.com',
			'show_external' => true,
		]);

		$rep->add_control('start_open', [
			'label' => esc_html__('Start Open?', 'pointify'),
			'type' => Controls_Manager::SWITCHER,
			'label_on' => esc_html__('Yes', 'pointify'),
			'label_off' => esc_html__('No', 'pointify'),
			'return_value' => 'yes',
			'default' => '',
		]);

		$rep->add_control('hide_pin', [
			'label' => esc_html__('Hide Pin (content only)', 'pointify'),
			'type' => Controls_Manager::SWITCHER,
			'return_value' => 'yes',
			'default' => '',
		]);
		$rep->end_controls_tab();

		$rep->start_controls_tab('pin_style_tab', [
			'label' => esc_html__('Style', 'pointify'),
		]);

		$rep->add_group_control(Group_Control_Border::get_type(), [
			'name' => 'pin_single_border',
			'selector' => '{{WRAPPER}} .pointify-pin{{CURRENT_ITEM}}',
		]);

		$rep->add_responsive_control('pin_single_border_radius', [
			'label' => esc_html__('Pin Radius', 'pointify'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', '%', 'em'],
			'default' => [
				'top' => 100,
				'right' => 100,
				'bottom' => 100,
				'left' => 100,
				'unit' => '%',
				'isLinked' => true,
			],
			'selectors' => [
				'{{WRAPPER}} .pointify-pin{{CURRENT_ITEM}}' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]);

		$rep->add_responsive_control('single_icon_size', [
			'label' => esc_html__('Icon Size', 'pointify'),
			'type' => Controls_Manager::SLIDER,
			'range' => ['px' => ['min' => 10, 'max' => 80]],
			'default' => ['size' => 20, 'unit' => 'px'],
			'selectors' => [
				'{{WRAPPER}} .pointify-pin{{CURRENT_ITEM}} .pointify-pin__icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .pointify-pin{{CURRENT_ITEM}} .pointify-pin__icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
			],
			'condition' => ['display_type' => 'icon'],
		]);

		$rep->add_responsive_control('single_pin_size', [
			'label' => esc_html__('Pin Size', 'pointify'),
			'type' => Controls_Manager::SLIDER,
			'range' => ['px' => ['min' => 12, 'max' => 180]],
			'selectors' => [
				'{{WRAPPER}} .pointify-pin{{CURRENT_ITEM}}' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
			],
		]);

		$rep->add_responsive_control('dot_color', [
			'label' => esc_html__('Dot Color', 'pointify'),
			'type' => Controls_Manager::COLOR,			
			'selectors' => [
				'{{WRAPPER}} .pointify-pin{{CURRENT_ITEM}} .pointify-pin__dot .pk-dot' => 'background-color: {{VALUE}};',
			],
			'condition' => ['display_type' => 'dot'],
		]);

		$rep->add_responsive_control('pulse_color', [
			'label' => esc_html__('Pulse Color', 'pointify'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .pointify-pin{{CURRENT_ITEM}}.pulse:after' => 'background-color: {{VALUE}};',
			],
		]);

		$rep->end_controls_tab();


		$this->add_control('pins', [
			'label' => esc_html__('Pins', 'pointify'),
			'type' => Controls_Manager::REPEATER,
			'fields' => $rep->get_controls(),
			'title_field' => '{{{ label }}}',
			'default' => [
				['label' => 'Pin #1', 'pos_x' => ['size' => 30], 'pos_y' => ['size' => 30]],
				['label' => 'Pin #2', 'pos_x' => ['size' => 60], 'pos_y' => ['size' => 60]],
			],
		]);

		$this->add_control('open_exclusive', [
			'label' => esc_html__('Close others when one opens', 'pointify'),
			'type' => Controls_Manager::SWITCHER,
			'return_value' => 'yes',
			'default' => 'yes',
			'description' => esc_html__('On click/hover, other popups will close.', 'pointify'),
		]);

		$this->add_control('enable_pulse', [
			'label' => esc_html__('Pulse Animation', 'pointify'),
			'type' => Controls_Manager::SWITCHER,
			'return_value' => 'yes',
			'default' => 'yes',
		]);

		$this->end_controls_section();

		include 'styles.php'; // Include styles fields for the widget
	}



	/**
	 * Render the widget output on the frontend.
	 */
	protected function render()
	{
		include 'renderview.php';
	}
}