<?php
namespace Pointify;

if (!defined('ABSPATH')) exit;

class Plugin {

    private static ?Plugin $instance = null;

    public static function instance(): Plugin {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action('elementor/widgets/register', [$this, 'register_widgets']);
        add_action('elementor/frontend/after_register_styles', [$this, 'register_assets']);
        add_action('elementor/frontend/after_register_scripts', [$this, 'register_assets']);
    }

    public function register_assets() {
        // CSS
        wp_register_style(
            'pointify-pinpoint',
            POINTIFY_URL . 'assets/css/pinpoint.css',
            [],
            POINTIFY_VERSION
        );

        // JS
        wp_register_script(
            'pointify-pinpoint',
            POINTIFY_URL . 'assets/js/pinpoint.js',
            ['jquery', 'elementor-frontend'],
            POINTIFY_VERSION,
            true
        );
    }

    public function register_widgets( $widgets_manager ) {
        require_once POINTIFY_PATH . '/includes/Widgets/PinPoint/Main.php';

        $widgets_manager->register( new \Pointify\Widgets\PinPoint\Main() );
    }
}
