(function($){
	'use strict';

	function closeOthers($wrap, except){
		if($wrap.data('exclusive') !== true && $wrap.data('exclusive') !== 'true') return;
		$wrap.find('.pointify-pin.is-open').not(except).removeClass('is-open').find('.pointify-pin-popup').attr('aria-hidden','true');
	}

	function initPinpoint($scope){
		var $wrap = $scope.find('.pointify-pinpoint');
		if(!$wrap.length) return;

		// Normalize exclusive flag
		var ex = $wrap.attr('data-exclusive');
		$wrap.data('exclusive', ex === 'true');

		// Start-open pins
		$wrap.find('.pointify-pin').each(function(){
			var $pin = $(this);
			if($pin.data('open') === true || $pin.data('open') === 'true'){
				$pin.addClass('is-open');
				$pin.find('.pointify-pin-popup').attr('aria-hidden','false');
			}
		});

		// Click trigger
		$wrap.on('click', '.pointify-pin[data-trigger="click"]', function(e){
			e.stopPropagation();
			var $pin = $(this);
			if($pin.hasClass('is-open')){
				$pin.removeClass('is-open').find('.pointify-pin-popup').attr('aria-hidden','true');
			}else{
				closeOthers($wrap, $pin);
				$pin.addClass('is-open').find('.pointify-pin-popup').attr('aria-hidden','false');
			}
		});

		// Keyboard accessibility
		$wrap.on('keydown', '.pointify-pin', function(e){
			if(e.key === 'Enter' || e.key === ' '){
				e.preventDefault();
				$(this).trigger('click');
			}
		});

		// Click outside to close
		$(document).on('click.pointify-pinpoint-' + $wrap.data('widget'), function(){
			closeOthers($wrap, null);
			$wrap.find('.pointify-pin.is-open').removeClass('is-open').find('.pointify-pin-popup').attr('aria-hidden','true');
		});
	}

	// Elementor hooks
	$(window).on('elementor/frontend/init', function(){
		elementorFrontend.hooks.addAction('frontend/element_ready/pointify-PinPoint.default', initPinpoint);
	});
})(jQuery);
