<?php
// Exit if uninstall not called from WordPress.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/**
 * Delete plugin data for a single site (current blog).
 */
function plzcr_uninstall_single_site() {
	// Option entfernen.
	delete_option( 'plzcr_settings' );

	// Geplante Cron-Jobs entfernen.
	wp_clear_scheduled_hook( 'plzcr_digest_event' );

	// Alle genutzten Post-Meta-Keys entfernen (Core-API, keine direkten Queries).
	$meta_keys = array(
		'_plz_fresh_interval_days',
		'_plz_fresh_never',
		'_plz_fresh_snooze_until',
		'_plz_fresh_last_reviewed',
	);

	foreach ( $meta_keys as $key ) {
		delete_post_meta_by_key( $key );
	}
}

if ( is_multisite() ) {
	// Für alle Sites ausführen.
	$sites = get_sites( array( 'fields' => 'ids' ) );
	if ( $sites ) {
		$current_blog_id = get_current_blog_id();

		foreach ( $sites as $site_id ) {
			switch_to_blog( $site_id );
			plzcr_uninstall_single_site();
		}

		// Zur ursprünglichen Site zurückkehren.
		switch_to_blog( $current_blog_id );
	}

	// Netzwerkweite Option falls je verwendet (failsafe, schadet nicht).
	delete_site_option( 'plzcr_settings' );
} else {
	plzcr_uninstall_single_site();
}
