<?php
/**
 * Plugin Name: Pointalize Content Refresh
 * Plugin URI: https://pointalize.com/
 * Description: Keep your WordPress content fresh and SEO-friendly by automatically reminding you to review and update old posts and pages.
 * Version:           1.0
 * Requires at least: 5.0
 * Requires PHP:      7.4
 * Author:            Pointalize
 * Author URI:        https://pointalize.com/about/
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package Pointalize_Content_Refresh
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'PLZCR_VERSION', '1.0.0' );
define( 'PLZCR_FILE', __FILE__ );
define( 'PLZCR_PATH', plugin_dir_path( __FILE__ ) );
define( 'PLZCR_URL', plugin_dir_url( __FILE__ ) );

// Include files
require_once PLZCR_PATH . 'includes/settings.php';
require_once PLZCR_PATH . 'includes/helpers.php';
require_once PLZCR_PATH . 'includes/metabox.php';
require_once PLZCR_PATH . 'includes/admin-page.php';
require_once PLZCR_PATH . 'includes/cron.php';
require_once PLZCR_PATH . 'includes/email.php';

/**
 * Activation: set defaults and schedule cron
 */
function plzcr_activate() {
    plzcr_register_defaults();
    plzcr_schedule_digest();
}
register_activation_hook( __FILE__, 'plzcr_activate' );

/**
 * Deactivation: clear cron
 */
function plzcr_deactivate() {
    wp_clear_scheduled_hook( 'plzcr_digest_event' );
}
register_deactivation_hook( __FILE__, 'plzcr_deactivate' );

