<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function plzcr_render_queue_page() {
    if ( ! current_user_can('edit_posts') ) { echo '<div class="wrap"><h1>Refresh Queue</h1><p>Insufficient permissions.</p></div>'; return; }

    // Bulk actions
    if ( isset($_POST['plzcr_bulk_action']) && check_admin_referer('plzcr_queue_actions','plzcr_queue_nonce') ) {
        $ids = array_map('absint', (array)($_POST['post_ids'] ?? array()));

        $action = '';
        if ( isset( $_POST['plzcr_bulk_action'] ) ) {
            $action = sanitize_text_field( wp_unslash( $_POST['plzcr_bulk_action'] ) );
        }

        foreach ( $ids as $pid ) {
            if ( ! current_user_can('edit_post', $pid) ) continue;
            if ( $action === 'reviewed' ) {
                update_post_meta($pid, '_plz_fresh_last_reviewed', current_time('timestamp'));
            } elseif ( $action === 'snooze7' ) {
                update_post_meta($pid, '_plz_fresh_snooze_until', gmdate('Y-m-d 23:59:59', time() + 7 * DAY_IN_SECONDS));
            } elseif ( $action === 'snooze30' ) {
                update_post_meta($pid, '_plz_fresh_snooze_until', gmdate('Y-m-d 23:59:59', time() + 30 * DAY_IN_SECONDS));
            } elseif ( $action === 'never_on' ) {
                update_post_meta($pid, '_plz_fresh_never', 1);
            }
        }
        echo '<div class="updated notice"><p>Action executed.</p></div>';
    }

    $s = plzcr_get_settings();
    $ids = plzcr_query_due_items(500);
    $now = current_time('timestamp');

    echo '<div class="wrap"><h1>Refresh Queue</h1>';

    echo '<form method="post">';
    wp_nonce_field('plzcr_queue_actions','plzcr_queue_nonce');
    echo '<div style="margin:10px 0;">';
    echo '<select name="plzcr_bulk_action">';
    echo '<option value="">Select bulk action</option>';
    echo '<option value="reviewed">Mark as reviewed</option>';
    echo '<option value="snooze7">Snooze 7 days</option>';
    echo '<option value="snooze30">Snooze 30 days</option>';
    echo '<option value="never_on">Exclude from reminders</option>';
    echo '</select> ';
    echo '<button class="button">Apply</button>';
    echo '</div>';

    echo '<table class="wp-list-table widefat fixed striped">';
    echo '<thead><tr>';
    echo '<td class="manage-column column-cb check-column"><input type="checkbox" onclick="jQuery(\'.plzcr-cb\').prop(\'checked\', this.checked)"/></td>';
    echo '<th>Title</th><th>Type</th><th>Author</th><th>Last modified</th><th>Interval</th><th>Next due</th><th>Status</th><th>Actions</th>';
    echo '</tr></thead><tbody>';

    if ( empty($ids) ) {
        echo '<tr><td colspan="9">No due items.</td></tr>';
    } else {
        foreach ( $ids as $pid ) {
            $post = get_post($pid);
            $status = plzcr_status($pid, $now);
            $interval = get_post_meta($pid, '_plz_fresh_interval_days', true );
            if ( ! $interval ) $interval = intval($s['interval_days']);
            $base = get_post_meta($pid, '_plz_fresh_last_reviewed', true);
            if ( ! $base ) $base = get_post_modified_time('U', true, $pid );
            $snooze = get_post_meta($pid, '_plz_fresh_snooze_until', true);
            $due = intval($base) + DAY_IN_SECONDS * intval($interval);
            if ( $snooze ) { $st = strtotime($snooze); if ($st && $st>$due) $due=$st; }

            echo '<tr>';
            echo '<th scope="row" class="check-column"><input type="checkbox" class="plzcr-cb" name="post_ids[]" value="'.esc_attr($pid).'"/></th>';
            echo '<td><a href="'.esc_url(get_edit_post_link($pid)).'">'.esc_html(get_the_title($pid)).'</a></td>';
            echo '<td>'.esc_html(get_post_type($pid)).'</td>';
            echo '<td>'.esc_html( $post ? get_the_author_meta('display_name', $post->post_author) : '' ).'</td>';
            echo '<td>'.esc_html( wp_date( get_option('date_format') . ' ' . get_option('time_format'), get_post_modified_time('U', true, $pid) ) ).'</td>';
            echo '<td>'.esc_html($interval).' days</td>';
            echo '<td>'.esc_html( wp_date( get_option('date_format') . ' ' . get_option('time_format'), $due ) ).'</td>';

            $style = ( $status === 'overdue' )
                ? 'color:#b32d2e;font-weight:bold;'
                : ( ( $status === 'today' )
                    ? 'color:#dba617;font-weight:bold;'
                    : 'color:#2271b1;font-weight:bold;'
                );

            echo '<td style="' . esc_attr( $style ) . '">' . esc_html( ucfirst( $status ) ) . '</td>';
            echo '<td><a class="button" href="'.esc_url( get_edit_post_link($pid) ).'">Edit</a></td>';
            echo '</tr>';
        }
    }

    echo '</tbody></table></form>';
    echo '</div>';
}
