<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function plzcr_add_metabox() {
    $s = plzcr_get_settings();
    foreach ( (array)$s['post_types'] as $pt ) {
        add_meta_box('plzcr_meta','Content Refresh','plzcr_render_metabox',$pt,'side','default');
    }
}
add_action('add_meta_boxes','plzcr_add_metabox');

function plzcr_render_metabox( $post ) {
    wp_nonce_field('plzcr_save_meta','plzcr_meta_nonce');
    $interval = get_post_meta($post->ID, '_plz_fresh_interval_days', true );
    $never    = get_post_meta($post->ID, '_plz_fresh_never', true );
    $snooze   = get_post_meta($post->ID, '_plz_fresh_snooze_until', true );
    $last     = get_post_meta($post->ID, '_plz_fresh_last_reviewed', true );
    $status   = plzcr_status($post->ID);
    ?>
    <p><strong>Status:</strong> <?php echo esc_html( ucfirst($status) ); ?></p>
    <p>
      <label>Interval override (days)</label><br/>
      <input type="number" name="plzcr_interval" value="<?php echo esc_attr($interval); ?>" min="0" placeholder="0 = global"/>
    </p>
    <p>
      <label><input type="checkbox" name="plzcr_never" value="1" <?php checked($never); ?>/> Never remind</label>
    </p>
    <p>
      <label>Snooze until (date)</label><br/>
      <input type="date" name="plzcr_snooze" value="<?php echo esc_attr( $snooze ? gmdate('Y-m-d', strtotime($snooze)) : '' ); ?>" />
    </p>
    <p>
      <button class="button" name="plzcr_mark_reviewed" value="1">Mark as reviewed</button>
    </p>
    <p><small>Last review: <?php echo $last ? esc_html( wp_date( get_option('date_format').' '.get_option('time_format'), intval($last) ) ) : '–'; ?></small></p>
    <?php
}

function plzcr_save_post_meta( $post_id ) {
    // Guards.
    if ( wp_is_post_autosave( $post_id ) || wp_is_post_revision( $post_id ) ) {
      return;
    }

    // Nonce present?
    if ( ! isset( $_POST['plzcr_meta_nonce'] ) ) {
      return;
    }

    $nonce = wp_unslash( $_POST['plzcr_meta_nonce'] ); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

    // Nonce must be a string.
    if ( ! is_string( $nonce ) ) {
        return;
    }

    // Verify nonce.
    if ( ! wp_verify_nonce( $nonce, 'plzcr_save_meta' ) ) {
        return;
    }

    // Capability.
    if ( ! current_user_can( 'edit_post', $post_id ) ) {
      return;
    }

    // Read + sanitize inputs (always wp_unslash before sanitize).
    $interval = 0;
    if ( isset( $_POST['plzcr_interval'] ) ) {
      $interval = (int) sanitize_text_field( wp_unslash( $_POST['plzcr_interval'] ) );
    }

    $never = 0;
    if ( isset( $_POST['plzcr_never'] ) ) {
      $never = (int) ( '1' === sanitize_text_field( wp_unslash( $_POST['plzcr_never'] ) ) );
    }

    $snooze = '';
    if ( isset( $_POST['plzcr_snooze'] ) ) {
      $snooze = sanitize_text_field( wp_unslash( $_POST['plzcr_snooze'] ) );
    }

    $mark_reviewed = false;
    if ( isset( $_POST['plzcr_mark_reviewed'] ) ) {
      $mark_reviewed = ( '1' === sanitize_text_field( wp_unslash( $_POST['plzcr_mark_reviewed'] ) ) );
    }

    if ( $interval > 0 ) update_post_meta($post_id, '_plz_fresh_interval_days', $interval);
    else delete_post_meta($post_id, '_plz_fresh_interval_days');

    if ( $never ) update_post_meta($post_id, '_plz_fresh_never', 1);
    else delete_post_meta($post_id, '_plz_fresh_never');

    if ( $snooze ) update_post_meta($post_id, '_plz_fresh_snooze_until', $snooze . ' 23:59:59');
    else delete_post_meta($post_id, '_plz_fresh_snooze_until');

    if ( $mark_reviewed ) {
        update_post_meta($post_id, '_plz_fresh_last_reviewed', current_time('timestamp'));
    }
}
add_action('save_post','plzcr_save_post_meta');
