<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function plzcr_render_email_html( $ids ) {
    ob_start();
    ?>
    <div style="font-family:Arial,Helvetica,sans-serif;font-size:14px;color:#222;">
      <h2>Pointalize Content Refresh – Due items</h2>
      <table width="100%" cellpadding="6" cellspacing="0" border="0" style="border-collapse:collapse;">
        <thead>
          <tr style="background:#f0f0f0;">
            <th align="left">Title</th>
            <th align="left">Type</th>
            <th align="left">Author</th>
            <th align="left">Last modified</th>
            <th align="left">Status</th>
            <th align="left">Edit</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ( $ids as $pid ) :
            $post = get_post($pid);
            $status = plzcr_status($pid);
            $color = ($status==='overdue'?'#b32d2e':($status==='today'?'#dba617':'#2271b1'));
            ?>
            <tr>
              <td><a href="<?php echo esc_url(get_permalink($pid)); ?>" style="color:#2271b1;text-decoration:none;"><?php echo esc_html(get_the_title($pid)); ?></a></td>
              <td><?php echo esc_html(get_post_type($pid)); ?></td>
              <td><?php echo esc_html( $post ? get_the_author_meta('display_name', $post->post_author) : '' ); ?></td>
              <td><?php echo esc_html( wp_date( get_option('date_format') . ' ' . get_option('time_format'), get_post_modified_time('U', true, $pid) ) ); ?></td>
              <td style="color:<?php echo esc_attr($color); ?>;font-weight:bold;"><?php echo esc_html( ucfirst($status) ); ?></td>
              <td><a href="<?php echo esc_url( get_edit_post_link($pid) ); ?>" style="color:#2271b1;">Edit</a></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
    <?php
    return ob_get_clean();
}
