<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_action('plzcr_digest_event','plzcr_run_digest');

function plzcr_run_digest() {
    $s = plzcr_get_settings();
    if ( empty($s['notifications_enabled']) ) return;

    $now = current_time('timestamp');

    // Respect weekly setting
    if ( $s['notify_frequency'] === 'weekly' ) {
        $weekday = gmdate('D', $now);
        if ( $weekday !== $s['notify_day'] ) return;
    }

    $ids = plzcr_query_due_items(300);
    if ( empty($ids) ) return;

    if ( $s['overdue_only'] ) {
        $ids = array_filter($ids, function($pid){ return plzcr_status($pid)==='overdue'; });
        if ( empty($ids) ) return;
    }

    $html = plzcr_render_email_html( $ids );
    $subject = sprintf('Content Refresh: %d items need refresh', count($ids) );
    $headers = array('Content-Type: text/html; charset=UTF-8');

    foreach ( (array)$s['recipients'] as $to ) {
        if ( is_email($to) ) wp_mail( $to, $subject, $html, $headers );
    }
}
