<?php
/**
 * Podcast player premium.
 *
 * @link       https://www.vedathemes.com
 * @since      1.0.0
 *
 * @package    Podcast_Player
 */

namespace Podcast_Player\Frontend\Inc;

use Podcast_Player\Helper\Functions\Getters as Get_Fn;
use Podcast_Player\Helper\Core\Singleton;

/**
 * Podcast player premium.
 *
 * @package    Podcast_Player
 * @author     vedathemes <contact@vedathemes.com>
 */
class Icons_Extend extends Singleton {

	/**
	 * SVG icons definition.
	 *
	 * @since 7.3.0
	 *
	 * @param array $icons Icons definitions.
	 */
	public function extend_font_icons_def( $icons = array() ) {
		$font_type = Get_Fn::get_plugin_option( 'fonts' );
		if ( 'tabler' === $font_type ) {
			return $this->add_tabler_icons_def( $icons );
		} elseif ( 'huge' === $font_type ) {
			return $this->add_huge_icons_def( $icons );
		} elseif ( 'framework7' === $font_type ) {
			return $this->add_framework7_icons_def( $icons );
		} else {
			return $icons;
		}
	}

	/**
	 * Add Tabler SVG fonts.
	 *
	 * @since 7.3.0
	 *
	 * @param array $icons Icons definitions.
	 */
	public function add_tabler_icons_def( $icons = array() ) {
		$icons['pp-download'] = '<symbol id="icon-pp-download" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 17v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-2M7 11l5 5l5-5m-5-7v12"/></symbol>';
		$icons['pp-copy'] = '<symbol id="icon-pp-copy" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><path d="M7 9.667A2.667 2.667 0 0 1 9.667 7h8.666A2.667 2.667 0 0 1 21 9.667v8.666A2.667 2.667 0 0 1 18.333 21H9.667A2.667 2.667 0 0 1 7 18.333z"/><path d="M4.012 16.737A2 2 0 0 1 3 15V5c0-1.1.9-2 2-2h10c.75 0 1.158.385 1.5 1"/></g></symbol>';
		$icons['pp-x'] = '<symbol id="icon-pp-x" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 6L6 18M6 6l12 12"/></symbol>';
		$icons['pp-twitter'] = '<symbol id="icon-pp-twitter" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m4 4l11.733 16H20L8.267 4zm0 16l6.768-6.768m2.46-2.46L20 4"/></symbol>';
		$icons['pp-linkedin'] = '<symbol id="icon-pp-linkedin" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><path d="M4 6a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2zm4 5v5m0-8v.01M12 16v-5"/><path d="M16 16v-3a2 2 0 0 0-4 0"/></g></symbol>';
		$icons['pp-facebook'] = '<symbol id="icon-pp-facebook" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 10v4h3v7h4v-7h3l1-4h-4V8a1 1 0 0 1 1-1h3V3h-3a5 5 0 0 0-5 5v2z"/></symbol>';
		$icons['pp-search'] = '<symbol id="icon-pp-search" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10a7 7 0 1 0 14 0a7 7 0 1 0-14 0m18 11l-6-6"/></symbol>';
		$icons['pp-rotate-cw'] = '<symbol id="icon-pp-rotate-cw" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><path d="M5.007 16.478A6 6 0 0 1 9 6h11m-5 9.5v3a1.5 1.5 0 0 0 3 0v-3a1.5 1.5 0 0 0-3 0"/><path d="m17 9l3-3l-3-3M9 14h1.5a1.5 1.5 0 0 1 0 3H10h.5a1.5 1.5 0 0 1 0 3H9"/></g></symbol>';
		$icons['pp-rotate-ccw'] = '<symbol id="icon-pp-rotate-ccw" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><path d="M7 9L4 6l3-3"/><path d="M15.997 17.918A6.002 6.002 0 0 0 15 6H4m2 8v6m3-4.5v3a1.5 1.5 0 0 0 3 0v-3a1.5 1.5 0 0 0-3 0"/></g></symbol>';
		$icons['pp-next'] = '<symbol id="icon-pp-next" viewBox="0 0 24 24"><path fill="currentColor" d="M3 5v14a1 1 0 0 0 1.504.864l12-7a1 1 0 0 0 0-1.728l-12-7A1 1 0 0 0 3 5m17-1a1 1 0 0 1 .993.883L21 5v14a1 1 0 0 1-1.993.117L19 19V5a1 1 0 0 1 1-1"/></symbol>';
		$icons['pp-play'] = '<symbol id="icon-pp-play" viewBox="0 0 24 24"><path fill="currentColor" d="M6 4v16a1 1 0 0 0 1.524.852l13-8a1 1 0 0 0 0-1.704l-13-8A1 1 0 0 0 6 4"/></symbol>';
		$icons['pp-previous'] = '<symbol id="icon-pp-previous" viewBox="0 0 24 24"><path fill="currentColor" d="m19.496 4.136l-12 7a1 1 0 0 0 0 1.728l12 7A1 1 0 0 0 21 19V5a1 1 0 0 0-1.504-.864M4 4a1 1 0 0 1 .993.883L5 5v14a1 1 0 0 1-1.993.117L3 19V5a1 1 0 0 1 1-1"/></symbol>';
		$icons['pp-share'] = '<symbol id="icon-pp-share" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 4v4C6.425 9.028 3.98 14.788 3 20c-.037.206 5.384-5.962 10-6v4l8-7z"/></symbol>';
		$icons['pp-pause'] = '<symbol id="icon-pp-pause" viewBox="0 0 24 24"><path fill="currentColor" d="M9 4H7a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2m8 0h-2a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2"/></symbol>';
		return $icons;
	}

	/**
	 * Add Huge SVG fonts.
	 *
	 * @since 7.3.0
	 *
	 * @param array $icons Icons definitions.
	 */
	public function add_huge_icons_def( $icons = array() ) {
		$icons['pp-copy'] = '<symbol id="icon-pp-copy" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" color="currentColor"><path d="M9 15c0-2.828 0-4.243.879-5.121C10.757 9 12.172 9 15 9h1c2.828 0 4.243 0 5.121.879C22 10.757 22 12.172 22 15v1c0 2.828 0 4.243-.879 5.121C20.243 22 18.828 22 16 22h-1c-2.828 0-4.243 0-5.121-.879C9 20.243 9 18.828 9 16z"/><path d="M17 9c-.003-2.957-.047-4.489-.908-5.538a4 4 0 0 0-.554-.554C14.43 2 12.788 2 9.5 2c-3.287 0-4.931 0-6.038.908a4 4 0 0 0-.554.554C2 4.57 2 6.212 2 9.5c0 3.287 0 4.931.908 6.038a4 4 0 0 0 .554.554c1.05.86 2.58.906 5.538.908"/></g></symbol>';
		$icons['pp-download'] = '<symbol id="icon-pp-download" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 14.5v-10m0 10c-.7 0-2.008-1.994-2.5-2.5m2.5 2.5c.7 0 2.008-1.994 2.5-2.5m5.5 4.5c0 2.482-.518 3-3 3H7c-2.482 0-3-.518-3-3" color="currentColor"/></symbol>';
		$icons['pp-facebook'] = '<symbol id="icon-pp-facebook" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6.182 10.333c-.978 0-1.182.192-1.182 1.111v1.667c0 .92.204 1.111 1.182 1.111h2.363v6.667c0 .92.205 1.111 1.182 1.111h2.364c.978 0 1.182-.192 1.182-1.111v-6.667h2.654c.741 0 .932-.135 1.136-.806l.507-1.666c.349-1.149.133-1.417-1.137-1.417h-3.16V7.556c0-.614.529-1.112 1.181-1.112h3.364c.978 0 1.182-.191 1.182-1.11V3.11C19 2.191 18.796 2 17.818 2h-3.364c-3.263 0-5.909 2.487-5.909 5.556v2.777z" color="currentColor"/></symbol>';
		$icons['pp-twitter'] = '<symbol id="icon-pp-twitter" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="m3 21l7.548-7.548M21 3l-7.548 7.548m0 0L8 3H3l7.548 10.452m2.904-2.904L21 21h-5l-5.452-7.548" color="currentColor"/></symbol>';
		$icons['pp-linkedin'] = '<symbol id="icon-pp-linkedin" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4.5 9.5H4c-.943 0-1.414 0-1.707.293S2 10.557 2 11.5V20c0 .943 0 1.414.293 1.707S3.057 22 4 22h.5c.943 0 1.414 0 1.707-.293S6.5 20.943 6.5 20v-8.5c0-.943 0-1.414-.293-1.707S5.443 9.5 4.5 9.5m2-5.25a2.25 2.25 0 1 1-4.5 0a2.25 2.25 0 0 1 4.5 0m5.826 5.25H11.5c-.943 0-1.414 0-1.707.293S9.5 10.557 9.5 11.5V20c0 .943 0 1.414.293 1.707S10.557 22 11.5 22h.5c.943 0 1.414 0 1.707-.293S14 20.943 14 20v-3.5c0-1.657.528-3 2.088-3c.78 0 1.412.672 1.412 1.5v4.5c0 .943 0 1.414.293 1.707s.764.293 1.707.293h.499c.942 0 1.414 0 1.707-.293c.292-.293.293-.764.293-1.706L22 14c0-2.486-2.364-4.5-4.703-4.5c-1.332 0-2.52.652-3.297 1.673c0-.63 0-.945-.137-1.179a1 1 0 0 0-.358-.358c-.234-.137-.549-.137-1.179-.137" color="currentColor"/></symbol>';
		$icons['pp-search'] = '<symbol id="icon-pp-search" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17.5 17.5L22 22m-2-11a9 9 0 1 0-18 0a9 9 0 0 0 18 0" color="currentColor"/></symbol>';
		$icons['pp-rotate-cw'] = '<symbol id="icon-pp-rotate-cw" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" color="currentColor"><path d="m12 5l1.104-1.545c.41-.576.617-.864.487-1.13c-.13-.268-.46-.283-1.12-.314Q12.237 2 12 2C6.477 2 2 6.477 2 12s4.477 10 10 10s10-4.477 10-10a9.99 9.99 0 0 0-4-8"/><path d="M16.752 12.6c0-1.38.066-1.752-.198-2.196s-.924-.406-1.584-.406s-1.14-.038-1.458.322c-.39.42-.222 1.2-.27 2.28c.108 1.44-.186 2.58.264 3.06c.324.396.9.336 1.584.348c.68-.008 1.092.024 1.428-.36c.372-.336.192-1.668.234-3.048m-9.504-1.476c.132-1.044.972-1.164 1.812-1.122c.66-.03 1.68.018 1.692 1.518c-.012 1.56-1.248 1.451-1.248 1.476s1.296-.036 1.248 1.524C10.74 15.9 9.84 16.044 9 15.996c-.84.06-1.62-.156-1.752-1.116"/></g></symbol>';
		$icons['pp-rotate-ccw'] = '<symbol id="icon-pp-rotate-ccw" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" color="currentColor"><path d="m12 5l-1.104-1.545c-.41-.576-.617-.864-.487-1.13c.13-.268.46-.283 1.12-.314Q11.763 2 12 2c5.523 0 10 4.477 10 10s-4.477 10-10 10S2 17.523 2 12a9.99 9.99 0 0 1 4-8"/><path d="M7.992 11.004C8.52 10.584 9 9.89 9.3 10.02c.3.128.204.552.204 1.212v4.776m6.498-3.408c0-1.38.066-1.752-.198-2.196s-.924-.406-1.584-.406s-1.14-.038-1.458.322c-.39.42-.222 1.2-.27 2.28c.108 1.44-.186 2.58.264 3.06c.324.396.9.336 1.584.348c.68-.008 1.092.024 1.428-.36c.372-.336.192-1.668.234-3.048"/></g></symbol>';
		$icons['pp-next'] = '<symbol id="icon-pp-next" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15.935 12.626c-.254 1.211-1.608 2.082-4.315 3.822c-2.945 1.893-4.417 2.84-5.61 2.475a2.8 2.8 0 0 1-1.088-.635C4 17.418 4 15.612 4 12s0-5.418.922-6.288a2.8 2.8 0 0 1 1.089-.635c1.192-.365 2.664.582 5.609 2.475c2.707 1.74 4.06 2.61 4.315 3.822c.087.412.087.84 0 1.252M20 5v14" color="currentColor"/></symbol>';
		$icons['pp-play'] = '<symbol id="icon-pp-play" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M18.89 12.846c-.353 1.343-2.023 2.292-5.364 4.19c-3.23 1.835-4.845 2.752-6.146 2.384a3.25 3.25 0 0 1-1.424-.841C5 17.614 5 15.743 5 12s0-5.614.956-6.579a3.25 3.25 0 0 1 1.424-.84c1.301-.37 2.916.548 6.146 2.383c3.34 1.898 5.011 2.847 5.365 4.19a3.3 3.3 0 0 1 0 1.692" color="currentColor"/></symbol>';
		$icons['pp-previous'] = '<symbol id="icon-pp-previous" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8.065 12.626c.254 1.211 1.608 2.082 4.315 3.822c2.945 1.893 4.417 2.84 5.61 2.475c.403-.124.775-.34 1.088-.635C20 17.418 20 15.612 20 12s0-5.418-.922-6.288a2.8 2.8 0 0 0-1.088-.635c-1.193-.365-2.665.582-5.61 2.475c-2.707 1.74-4.06 2.61-4.315 3.822c-.087.412-.087.84 0 1.252M4 4v16" color="currentColor"/></symbol>';
		$icons['pp-share'] = '<symbol id="icon-pp-share" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" color="currentColor"><path d="m20.393 8.032l-1.747-1.517c-1.259-1.093-1.752-1.681-2.434-1.474c-.85.26-.57 1.895-.57 2.447c-1.321 0-2.695-.101-3.998.11c-4.3.7-5.644 3.759-5.644 7.055c1.217-.747 2.433-1.578 3.895-1.924c1.826-.432 3.865-.226 5.747-.226c0 .552-.28 2.188.57 2.447c.772.236 1.175-.38 2.434-1.473l1.747-1.517C21.464 11.03 22 10.564 22 9.996s-.536-1.034-1.607-1.964"/><path d="M10.568 3c-3.86.007-5.882.102-7.174 1.39C2 5.783 2 8.022 2 12.5s0 6.717 1.394 8.109C4.788 22 7.032 22 11.52 22s6.73 0 8.125-1.391C20.615 19.64 20.91 18.26 21 16"/></g></symbol>';
		$icons['pp-pause'] = '<symbol id="icon-pp-pause" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 7c0-1.414 0-2.121.44-2.56C4.878 4 5.585 4 7 4s2.121 0 2.56.44C10 4.878 10 5.585 10 7v10c0 1.414 0 2.121-.44 2.56C9.122 20 8.415 20 7 20s-2.121 0-2.56-.44C4 19.122 4 18.415 4 17zm10 0c0-1.414 0-2.121.44-2.56C14.878 4 15.585 4 17 4s2.121 0 2.56.44C20 4.878 20 5.585 20 7v10c0 1.414 0 2.121-.44 2.56c-.439.44-1.146.44-2.56.44s-2.121 0-2.56-.44C14 19.122 14 18.415 14 17z" color="currentColor"/></symbol>';
		return $icons;
	}

	/**
	 * Add Huge SVG fonts.
	 *
	 * @since 7.3.0
	 *
	 * @param array $icons Icons definitions.
	 */
	public function add_framework7_icons_def( $icons = array() ) {
		$icons['pp-download'] = '<symbol id="icon-pp-download" viewBox="0 0 56 56"><path fill="currentColor" d="M28.012 31.094c.468 0 .867-.164 1.359-.633l7.899-7.64c.351-.352.562-.727.562-1.243c0-.937-.727-1.64-1.711-1.64a1.71 1.71 0 0 0-1.266.562l-3.562 3.797l-1.57 1.64l.14-3.492V3.906c0-.984-.843-1.828-1.851-1.828s-1.875.844-1.875 1.828v18.54l.14 3.515l-1.57-1.664l-3.563-3.797c-.328-.375-.843-.562-1.289-.562c-.984 0-1.687.703-1.687 1.64c0 .516.21.89.562 1.242l7.922 7.641c.469.469.867.633 1.36.633M7.715 53.922h40.57c4.899 0 7.36-2.437 7.36-7.266V32.781c0-2.11-.305-3.164-1.336-4.453l-8.11-10.008c-2.742-3.375-4.43-5.343-8.578-5.343h-3.445v3.28h3.703c1.71 0 3.492 1.524 4.664 2.977l8.297 10.477c.937 1.195.609 1.664-.68 1.664H35.23c-1.195 0-1.78.914-1.78 1.898v.07c0 2.72-2.134 5.602-5.462 5.602c-3.305 0-5.437-2.882-5.437-5.601v-.07c0-.985-.586-1.899-1.781-1.899H5.863c-1.336 0-1.594-.539-.703-1.664l8.297-10.477c1.172-1.453 2.953-2.976 4.664-2.976h3.727v-3.281h-3.47c-4.148 0-5.835 1.968-8.577 5.343L1.69 28.328C.661 29.618.355 30.672.355 32.781v13.875c0 4.852 2.485 7.266 7.36 7.266m.07-3.773c-2.344 0-3.656-1.243-3.656-3.68V34.797h14.86c.585 4.383 4.241 7.617 9 7.617c4.757 0 8.437-3.258 9-7.617H51.87v11.672c0 2.437-1.336 3.68-3.656 3.68Z"/></symbol>';
		$icons['pp-facebook'] = '<symbol id="icon-pp-facebook" viewBox="0 0 56 56"><path fill="currentColor" fill-rule="evenodd" d="M3 7.007A4.007 4.007 0 0 1 7.007 3h41.986A4.007 4.007 0 0 1 53 7.007v41.986A4.007 4.007 0 0 1 48.993 53H7.007A4.007 4.007 0 0 1 3 48.993zM37.28 51V31.842h6.486l.971-7.466H37.28v-4.767c0-2.162.605-3.635 3.732-3.635L45 15.972V9.294C44.31 9.204 41.943 9 39.189 9c-5.75 0-9.686 3.48-9.686 9.87v5.506H23v7.466h6.503V51z"/></symbol>';
		$icons['pp-linkedin'] = '<symbol id="icon-pp-linkedin" viewBox="0 0 56 56"><path fill="currentColor" fill-rule="evenodd" d="M45.608 45.607h-7.415V34.002c0-2.766-.048-6.326-3.853-6.326c-3.86 0-4.449 3.015-4.449 6.129v11.802h-7.407V21.745h7.108v3.263h.103c.99-1.877 3.409-3.855 7.016-3.855c7.51 0 8.897 4.94 8.897 11.367zM14.123 18.485a4.299 4.299 0 0 1-4.303-4.301a4.3 4.3 0 0 1 8.6 0a4.3 4.3 0 0 1-4.297 4.301m-3.714 27.122h7.423V21.745H10.41zM49.3 3H6.688C4.653 3 3 4.614 3 6.606v42.787c0 1.992 1.653 3.608 3.688 3.608H49.3c2.04 0 3.699-1.616 3.699-3.608V6.606C53 4.614 51.34 3 49.301 3"/></symbol>';
		$icons['pp-search'] = '<symbol id="icon-pp-search" viewBox="0 0 56 56"><path fill="currentColor" d="M23.957 41.77a18.02 18.02 0 0 0 10.477-3.376l11.109 11.11a2.658 2.658 0 0 0 1.898.773c1.524 0 2.625-1.172 2.625-2.672c0-.703-.234-1.359-.75-1.874L38.277 34.668c2.32-3.047 3.703-6.82 3.703-10.922c0-9.914-8.109-18.023-18.023-18.023c-9.937 0-18.023 8.109-18.023 18.023S14.02 41.77 23.957 41.77m0-3.891c-7.758 0-14.133-6.398-14.133-14.133c0-7.734 6.375-14.133 14.133-14.133c7.734 0 14.133 6.399 14.133 14.133c0 7.735-6.399 14.133-14.133 14.133"/></symbol>';
		$icons['pp-rotate-cw'] = '<symbol id="icon-pp-rotate-cw" viewBox="0 0 56 56"><path fill="currentColor" d="M28 54.402c13.055 0 23.906-10.828 23.906-23.906c0-7.875-3.984-14.953-10.008-19.336c-1.03-.797-2.32-.539-2.906.422c-.586.984-.281 2.086.656 2.813c4.993 3.562 8.25 9.445 8.274 16.101C47.945 41.56 39.039 50.418 28 50.418c-11.063 0-19.899-8.86-19.899-19.922c0-9.492 6.516-17.39 15.376-19.406v3.375c0 1.664 1.148 2.11 2.413 1.195l7.5-5.25c1.055-.726 1.079-1.851 0-2.625l-7.476-5.25c-1.29-.937-2.437-.492-2.437 1.196v3.304C12.507 9.168 4.094 18.965 4.094 30.496c0 13.078 10.828 23.906 23.906 23.906m7.71-14.039c3.891 0 6.423-3.68 6.423-9.304c0-5.672-2.532-9.399-6.422-9.399c-3.914 0-6.445 3.703-6.445 9.399c0 5.625 2.554 9.304 6.445 9.304m-15.116 0c3.68 0 6.304-2.226 6.304-5.39c0-2.18-1.453-3.985-3.515-4.36c1.64-.468 2.93-2.203 2.93-4.172c0-2.812-2.297-4.78-5.579-4.78c-2.836 0-5.203 1.593-5.719 3.866c-.046.282-.07.516-.07.774c0 .844.54 1.43 1.336 1.43c.656 0 1.078-.352 1.36-1.102c.468-1.477 1.453-2.25 3.023-2.25c1.64 0 2.766.984 2.766 2.414c0 1.5-1.149 2.602-2.79 2.602h-1.007c-.797 0-1.313.539-1.313 1.359c0 .773.54 1.36 1.313 1.36h1.101c1.992 0 3.235 1.1 3.235 2.742c0 1.593-1.407 2.812-3.352 2.812c-1.64 0-2.812-.82-3.328-2.273c-.305-.774-.703-1.102-1.36-1.102c-.773 0-1.335.61-1.335 1.43c0 .258.023.515.093.773c.493 2.203 3.024 3.867 5.907 3.867m15.117-2.836c-2.086 0-3.399-2.46-3.399-6.468c0-4.079 1.29-6.563 3.399-6.563c2.086 0 3.351 2.461 3.351 6.563c0 4.007-1.289 6.468-3.351 6.468"/></symbol>';
		$icons['pp-rotate-ccw'] = '<symbol id="icon-pp-rotate-ccw" viewBox="0 0 56 56"><path fill="currentColor" d="M28 54.402c13.055 0 23.906-10.828 23.906-23.906c0-11.531-8.437-21.305-19.383-23.46v-3.33c0-1.664-1.148-2.11-2.437-1.195l-7.477 5.226c-1.054.75-1.078 1.875 0 2.649l7.453 5.25c1.313.937 2.461.492 2.461-1.196v-3.35c8.86 2.015 15.375 9.914 15.375 19.406A19.84 19.84 0 0 1 28 50.418c-11.063 0-19.945-8.86-19.922-19.922c.023-6.656 3.258-12.539 8.25-16.101c.961-.727 1.266-1.829.656-2.813c-.562-.96-1.851-1.219-2.883-.422C8.055 15.543 4.094 22.621 4.094 30.496c0 13.078 10.828 23.906 23.906 23.906m5.648-14.039c3.891 0 6.446-3.68 6.446-9.304c0-5.672-2.555-9.399-6.446-9.399c-3.89 0-6.445 3.727-6.445 9.399c0 5.625 2.555 9.304 6.445 9.304m-12.21-.281c.913 0 1.5-.633 1.5-1.617V23.723c0-1.149-.61-1.875-1.665-1.875c-.633 0-1.078.21-1.922.773l-3.257 2.18c-.516.375-.774.797-.774 1.36c0 .773.61 1.429 1.36 1.429c.445 0 .656-.094 1.125-.422l2.18-1.594v12.89c0 .962.585 1.618 1.452 1.618m12.21-2.555c-2.062 0-3.398-2.46-3.398-6.468c0-4.079 1.312-6.563 3.398-6.563c2.11 0 3.375 2.461 3.375 6.563c0 4.007-1.289 6.468-3.375 6.468"/></symbol>';
		$icons['pp-next'] = '<symbol id="icon-pp-next" viewBox="0 0 56 56"><path fill="currentColor" d="M9.484 46.387c.961 0 1.758-.305 2.696-.867l23.883-14.04c1.289-.773 1.992-1.617 2.25-2.601v15.07c0 2.063 1.078 3.14 3.14 3.14h5.32c2.063 0 3.118-1.077 3.118-3.14V12.027c0-2.132-1.055-3.117-3.117-3.117h-5.32c-2.063 0-3.142 1.078-3.142 3.117v15.047c-.257-.96-.96-1.828-2.25-2.578L12.18 10.434c-.961-.563-1.735-.868-2.696-.868c-1.828 0-3.375 1.407-3.375 4.032v28.78c0 2.626 1.547 4.009 3.375 4.009"/></symbol>';
		$icons['pp-play'] = '<symbol id="icon-pp-play" viewBox="0 0 56 56"><path fill="currentColor" d="M13.094 47.84c.937 0 1.734-.375 2.672-.914l27.328-15.797c1.945-1.149 2.625-1.899 2.625-3.14c0-1.243-.68-1.993-2.625-3.118L15.766 9.051c-.938-.54-1.735-.89-2.672-.89c-1.735 0-2.813 1.312-2.813 3.35v32.954c0 2.039 1.078 3.375 2.813 3.375"/></symbol>';
		$icons['pp-previous'] = '<symbol id="icon-pp-previous" viewBox="0 0 56 56"><path fill="currentColor" d="M9.25 47.09h5.32c2.063 0 3.117-1.078 3.117-3.14V28.878a3.71 3.71 0 0 1-.117-.89c0-.329.047-.634.117-.915V12.027c0-2.132-1.054-3.117-3.117-3.117H9.25c-2.062 0-3.14 1.078-3.14 3.117V43.95c0 2.063 1.077 3.14 3.14 3.14m37.266-.703c1.851 0 3.375-1.383 3.375-4.008V13.598c0-2.625-1.524-4.032-3.375-4.032c-.938 0-1.735.305-2.696.868L19.938 24.496c-1.266.75-1.97 1.617-2.25 2.578v1.805c.28.984.984 1.828 2.25 2.601L43.82 45.52c.961.562 1.758.867 2.696.867"/></symbol>';
		$icons['pp-share'] = '<symbol id="icon-pp-share" viewBox="0 0 56 56"><path fill="currentColor" d="M30.344 49.504c1.148 0 2.039-.516 3.234-1.523L52.07 30.52c.867-.868 1.196-1.735 1.196-2.508c0-.797-.329-1.664-1.196-2.532L33.578 8.185c-1.336-1.102-2.039-1.688-3.188-1.688c-1.617 0-2.788 1.313-2.788 2.883v8.86h-.68c-16.852 0-24.188 10.804-24.188 28.124c0 2.016 1.149 3.14 2.39 3.14c1.009 0 2.087-.233 2.884-1.733c4.101-7.665 9.844-9.961 18.914-9.961h.68v8.953c0 1.57 1.171 2.742 2.742 2.742"/></symbol>';
		$icons['pp-pause'] = '<symbol id="icon-pp-pause" viewBox="0 0 56 56"><path fill="currentColor" d="M16.832 47.09h5.32c2.063 0 3.117-1.078 3.117-3.14V12.026c0-2.132-1.054-3.117-3.117-3.117h-5.32c-2.062 0-3.14 1.078-3.14 3.117V43.95c0 2.063 1.078 3.14 3.14 3.14m17.016 0h5.32c2.063 0 3.14-1.078 3.14-3.14V12.026c0-2.132-1.078-3.117-3.14-3.117h-5.32c-2.063 0-3.117 1.078-3.117 3.117V43.95c0 2.063 1.054 3.14 3.117 3.14"/></symbol>';
		return $icons;
	}

	/**
	 * Add Fluent UI SVG fonts.
	 *
	 * @since 7.3.0
	 *
	 * @param array $icons Icons definitions.
	 */
	public function add_fluentui_icons_def( $icons = array() ) {
		$icons['pp-copy'] = '<symbol id="icon-pp-copy" viewBox="0 0 32 32"><path fill="currentColor" d="M11.75 2A3.25 3.25 0 0 0 8.5 5.25v18a3.25 3.25 0 0 0 3.25 3.25h12A3.25 3.25 0 0 0 27 23.25v-18A3.25 3.25 0 0 0 23.75 2zM10.5 5.25c0-.69.56-1.25 1.25-1.25h12c.69 0 1.25.56 1.25 1.25v18c0 .69-.56 1.25-1.25 1.25h-12c-.69 0-1.25-.56-1.25-1.25zM7 5.749c-1.174.49-2 1.649-2 3V23.5a6.5 6.5 0 0 0 6.5 6.5h8.75a3.25 3.25 0 0 0 3.001-2H11.5A4.5 4.5 0 0 1 7 23.5z"/></symbol>';
		$icons['pp-download'] = '<symbol id="icon-pp-download" viewBox="0 0 32 32"><path fill="currentColor" d="M11.399 7.008C10.439 8.182 10 9.7 10 11a1 1 0 0 1-1 1c-3.624 0-5 2.528-5 4c0 .855.216 1.835.878 2.592C5.515 19.32 6.708 20 9 20h4.852c-.185.64-.3 1.31-.338 2H9c-2.707 0-4.515-.82-5.628-2.091C2.284 18.665 2 17.145 2 16c0-2.356 1.93-5.53 6.057-5.953c.172-1.456.74-3.016 1.794-4.305C11.166 4.134 13.201 3 16 3c1.7 0 3.682.562 5.258 1.851c1.421 1.163 2.473 2.887 2.697 5.206c1.378.165 2.714.683 3.781 1.508C29.063 12.589 30 14.114 30 16q.001.696-.124 1.342a9 9 0 0 0-1.942-2.017c-.173-.868-.681-1.607-1.42-2.177C25.577 12.424 24.296 12 23 12a1 1 0 0 1-1-1c0-2.2-.866-3.666-2.008-4.601C18.818 5.439 17.3 5 16 5c-2.2 0-3.666.866-4.601 2.008M30 22.5a7.5 7.5 0 1 1-15 0a7.5 7.5 0 0 1 15 0m-11.78 1.28l4 4a.75.75 0 0 0 1.06 0l4-4a.75.75 0 1 0-1.06-1.06l-2.72 2.72v-7.69a.75.75 0 0 0-1.5 0v7.69l-2.72-2.72a.75.75 0 1 0-1.06 1.06"/></symbol>';
		$icons['pp-search'] = '<symbol id="icon-pp-search" viewBox="0 0 28 28"><path fill="currentColor" d="M5 11.5a6.5 6.5 0 1 1 13 0a6.5 6.5 0 0 1-13 0M11.5 3a8.5 8.5 0 1 0 5.262 15.176l6.53 6.531a1 1 0 0 0 1.415-1.414l-6.531-6.531A8.5 8.5 0 0 0 11.5 3"/></symbol>';
		$icons['pp-rotate-cw'] = '<symbol id="icon-pp-rotate-cw" viewBox="0 0 28 28"><path fill="currentColor" d="M4.844 10.537C7.142 6.925 10.15 5 14.25 5c3.948 0 7.367 1.701 9.05 4H19a1 1 0 1 0 0 2h6a1 1 0 0 0 1-1V4a1 1 0 1 0-2 0v2.747C21.723 4.442 18.115 3 14.25 3C9.35 3 5.755 5.38 3.156 9.463a1 1 0 0 0 1.688 1.074M20.238 13c-1.658 0-2.86.74-3.59 1.947c-.684 1.133-.91 2.597-.91 4.053s.226 2.92.91 4.053C17.378 24.26 18.58 25 20.238 25c1.66 0 2.86-.74 3.59-1.947c.685-1.133.91-2.597.91-4.053s-.225-2.92-.91-4.053c-.73-1.207-1.93-1.947-3.59-1.947m-2.5 6c0-1.305.212-2.341.622-3.018c.364-.602.912-.982 1.878-.982s1.515.38 1.879.982c.41.677.621 1.713.621 3.018s-.212 2.341-.621 3.018c-.364.602-.913.982-1.879.982s-1.514-.38-1.878-.982c-.41-.677-.622-1.713-.622-3.018m-5.74-1.554c-.348.287-.98.554-1.998.554a1 1 0 1 0 0 2c1.018 0 1.65.267 1.998.554c.34.279.455.605.44.896c-.026.526-.63 1.55-2.688 1.55a3.84 3.84 0 0 1-1.927-.493a3 3 0 0 1-.57-.417l-.016-.015a1 1 0 0 0-1.481 1.343v.001l.002.002l.003.003l.008.008l.02.022l.063.063q.075.077.21.191c.178.151.435.344.768.535A5.84 5.84 0 0 0 9.75 25c2.692 0 4.588-1.476 4.686-3.45c.048-.959-.367-1.883-1.168-2.541l-.01-.009l.01-.009c.8-.658 1.216-1.582 1.168-2.54C14.338 14.475 12.442 13 9.75 13a5.84 5.84 0 0 0-2.92.757c-.333.19-.59.384-.768.535a4 4 0 0 0-.273.254l-.02.022l-.008.008l-.003.003l-.001.002l-.001.001a1 1 0 1 0 1.497 1.328q.029-.028.102-.092a3 3 0 0 1 .468-.325A3.84 3.84 0 0 1 9.75 15c2.058 0 2.662 1.024 2.689 1.55c.014.291-.101.617-.441.896"/></symbol>';
		$icons['pp-rotate-ccw'] = '<symbol id="icon-pp-rotate-ccw" viewBox="0 0 28 28"><path fill="currentColor" d="M3 3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h6a1 1 0 1 0 0-2H4.7c1.683-2.299 5.102-4 9.05-4c4.1 0 7.108 1.925 9.406 5.537a1 1 0 0 0 1.688-1.074C22.243 5.38 18.65 3 13.75 3C9.885 3 6.277 4.442 4 6.747V4a1 1 0 0 0-1-1m7.267 10.036A1 1 0 0 1 11 14v10a1 1 0 0 1-2 0v-7.265a9 9 0 0 1-1.485 1.123a1 1 0 0 1-1.03-1.716c.812-.486 1.48-1.15 1.955-1.71a10 10 0 0 0 .667-.89l.03-.048l.006-.009v-.001a1 1 0 0 1 1.124-.448m4.381 1.911C15.378 13.74 16.58 13 18.238 13c1.66 0 2.86.74 3.59 1.947c.685 1.133.91 2.597.91 4.053s-.225 2.92-.91 4.053c-.73 1.207-1.93 1.947-3.59 1.947c-1.658 0-2.86-.74-3.59-1.947c-.684-1.133-.91-2.597-.91-4.053s.226-2.92.91-4.053m1.712 1.035c-.41.677-.622 1.713-.622 3.018s.212 2.341.622 3.018c.364.602.912.982 1.878.982s1.515-.38 1.879-.982c.41-.677.621-1.713.621-3.018s-.212-2.341-.621-3.018c-.364-.602-.913-.982-1.879-.982s-1.514.38-1.878.982"/></symbol>';
		$icons['pp-next'] = '<symbol id="icon-pp-next" viewBox="0 0 32 32"><path fill="currentColor" d="M26.002 5a1 1 0 1 1 2 0v22a1 1 0 0 1-2 0zM3.999 6.504c0-2.002 2.236-3.192 3.897-2.073l14.003 9.432A2.5 2.5 0 0 1 21.912 18L7.909 27.56c-1.66 1.132-3.91-.056-3.91-2.065z"/></symbol>';
		$icons['pp-play'] = '<symbol id="icon-pp-play" viewBox="0 0 28 28"><path fill="currentColor" d="M10.138 3.382C8.304 2.31 6 3.632 6 5.756v16.489c0 2.123 2.304 3.445 4.138 2.374l14.697-8.59c1.552-.907 1.552-3.15 0-4.057z"/></symbol>';
		$icons['pp-previous'] = '<symbol id="icon-pp-previous" viewBox="0 0 28 28"><path fill="currentColor" d="M4.5 3.75a.75.75 0 0 0-1.5 0v20.5a.75.75 0 0 0 1.5 0zM25 5.254c0-1.816-2.041-2.884-3.533-1.848l-12.504 8.68a2.25 2.25 0 0 0-.013 3.688l12.504 8.81c1.49 1.05 3.546-.015 3.546-1.839z"/></symbol>';
		$icons['pp-share'] = '<symbol id="icon-pp-share" viewBox="0 0 28 28"><path fill="currentColor" d="m18.27 3.21l7.5 7.25a.75.75 0 0 1 0 1.08l-7.5 7.25a.73.73 0 0 1-.52.21a.75.75 0 0 1-.75-.75v-3.74c-6.7.27-9.52 4.02-9.64 4.18a.77.77 0 0 1-.84.27a.75.75 0 0 1-.52-.71c0-8.02 6.59-10.48 11-10.73V3.75a.75.75 0 0 1 .46-.69a.74.74 0 0 1 .81.15M7.75 4A4.75 4.75 0 0 0 3 8.75v11.5A4.75 4.75 0 0 0 7.75 25h11.5A4.75 4.75 0 0 0 24 20.25v-.5a.75.75 0 0 0-1.5 0v.5a3.25 3.25 0 0 1-3.25 3.25H7.75a3.25 3.25 0 0 1-3.25-3.25V8.75A3.25 3.25 0 0 1 7.75 5.5h4.5a.75.75 0 0 0 0-1.5z"/></symbol>';
		$icons['pp-pause'] = '<symbol id="icon-pp-pause" viewBox="0 0 28 28"><path fill="currentColor" d="M6.75 3A2.75 2.75 0 0 0 4 5.75v16.5A2.75 2.75 0 0 0 6.75 25h3a2.75 2.75 0 0 0 2.75-2.75V5.75A2.75 2.75 0 0 0 9.75 3zm11.5 0a2.75 2.75 0 0 0-2.75 2.75v16.5A2.75 2.75 0 0 0 18.25 25h3A2.75 2.75 0 0 0 24 22.25V5.75A2.75 2.75 0 0 0 21.25 3z"/></symbol>';
		return $icons;
	}
}
