<?php
/**
 * Podcast player new products page
 *
 * @package Podcast Player
 * @since 7.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<div class="pp-products-page">
	<ol class="pp-products-list">
		<li class="pp-product">
			<h2 class="pp-product-title"><?php esc_html_e( 'Selfhost Podcasting', 'podcast-player' ); ?></h2>
			<div class="pp-product-subtitle"><?php esc_html_e( 'Host and publish podcast from your WordPress dashboard. Clean, lightweight, and Apple/Spotify-compliant podcasting RSS feeds.', 'podcast-player' ); ?></div>
			<p class="pp-product-description"><?php esc_html_e( 'Selfhost Podcasting is a clean and efficient WordPress plugin that helps you create and host multiple podcasts directly from your WordPress dashboard. It provides a clean and focused admin interface where you can enter podcast and episode details. The plugin then generates a fully formatted RSS feed that meets the technical specifications of Apple Podcasts and Spotify.', 'podcast-player' ); ?></p>
			<div><a class="pp-product-link" href="https://easypodcastpro.com/selfhost-podcasting/" target="_blank">Create a Podcast</a></div>
		</li>
		<li class="pp-product">
			<h2 class="pp-product-title"><?php esc_html_e( 'Podcast Feed Composer', 'podcast-player' ); ?></h2>
			<div class="pp-product-subtitle"><?php esc_html_e( 'Create new podcast feeds by merging, splitting, rearranging your existing feeds', 'podcast-player' ); ?></div>
			<p class="pp-product-description"><?php esc_html_e( 'Personalize your feed URL, merge and split podcasts, rearrange and edit episodes, and do so much more with our WordPress plugin.', 'podcast-player' ); ?></p>
			<div><a class="pp-product-link" href="https://easypodcastpro.com/podcast-feed-composer/" target="_blank">Learn More</a></div>
		</li>
		<li class="pp-product">
			<h2 class="pp-product-title"><?php esc_html_e( 'Book - Podcasting the Human Way', 'podcast-player' ); ?></h2>
			<div class="pp-product-subtitle"><?php esc_html_e( 'A heartfelt novel about the human side of podcasting, purpose, and connection.', 'podcast-player' ); ?></div>
			<p class="pp-product-description"><?php esc_html_e( '"Podcasting The Human Way" is a heartfelt novel about a first-time podcaster navigating doubt, purpose, and connection. More than a guide, it’s a story for creators and listeners who value meaning over metrics. Perfect for those who believe podcasting is about people, not just plays.', 'podcast-player' ); ?></p>
			<div><a class="pp-product-link" href="https://easypodcastpro.com/book/" target="_blank">Read Now</a></div>
		</li>
	</ol>
</div>
